/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.core;

import com.sigge.filerunner.core.ResurrectionDecorator;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CardHolder<E> {
    protected List<E> holder;
    protected int cursorPosition = -1;
    protected List<E> HIStory;
    protected List<E> resurrection;
    protected int numberOfDeletedElementsToKeep;
    private final List<CardHolderListener<E>> listeners = new ArrayList<CardHolderListener<E>>();
    private ResurrectionDecorator<E> decorator;

    public CardHolder() {
        this(new ArrayList(), 0);
    }

    public CardHolder(int numberOfDeletedElementsToKeep) {
        this(new ArrayList(), numberOfDeletedElementsToKeep, null);
    }

    public CardHolder(List<E> elements, int numberOfDeletedElementsToKeep) {
        this(elements, numberOfDeletedElementsToKeep, null);
    }

    public CardHolder(int numberOfDeletedElementsToKeep, ResurrectionDecorator<E> decorator) {
        this(new ArrayList(), numberOfDeletedElementsToKeep, decorator);
    }

    public CardHolder(List<E> elements, int numberOfDeletedElementsToKeep, ResurrectionDecorator<E> decorator) {
        this.holder = new ArrayList<E>(elements);
        if (this.holder.size() > 0) {
            this.cursorPosition = 0;
        }
        this.decorator = decorator == null ? new ResurrectionDecorator<E>(){} : decorator;
        this.numberOfDeletedElementsToKeep = numberOfDeletedElementsToKeep;
        this.HIStory = new ArrayList();
        this.resurrection = new ArrayList();
    }

    public final void addListener(CardHolderListener<E> listener) {
        this.listeners.add(listener);
    }

    public final void removeListener(CardHolderListener<E> listener) {
        this.listeners.remove(listener);
    }

    public synchronized E add(E element) {
        int size = this.holder.size();
        this.holder.add(element);
        if (this.cursorPosition >= 0) {
            this.HIStory.add(this.current());
        }
        this.cursorPosition = size;
        if (this.numberOfDeletedElementsToKeep > 0) {
            this.resurrection.remove(element);
            this.decorator.clear(element);
        }
        int x = 0;
        while (x < this.listeners.size()) {
            try {
                this.listeners.get(x).added(element, this.cursorPosition);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++x;
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E justAdd(E element) {
        this.holder.add(element);
        if (this.numberOfDeletedElementsToKeep > 0) {
            this.resurrection.remove(element);
            this.decorator.clear(element);
        }
        int x = 0;
        while (x < this.listeners.size()) {
            this.listeners.get(x).added(element, this.holder.size() - 1);
            ++x;
        }
        return element;
    }

    public E cyclePrevious() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot cycle empty holder");
        }
        if (this.HIStory.size() == 0) {
            return this.current();
        }
        E prev = this.HIStory.get(this.HIStory.size() - 1);
        return this.current(prev);
    }

    public E move(int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return this.current();
        }
        boolean end = toIndex >= this.holder.size();
        E el = this.holder.get(fromIndex);
        if (end) {
            this.holder.add(el);
            this.holder.remove(fromIndex);
        } else {
            this.holder.add(toIndex > fromIndex ? toIndex : toIndex, el);
            this.holder.remove(toIndex > fromIndex ? fromIndex : fromIndex + 1);
        }
        this.cursorPosition = end ? this.holder.size() - 1 : (toIndex > fromIndex ? toIndex - 1 : toIndex);
        return this.getCurrentAndRaiseEvent();
    }

    public E getNextInCycle() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot cycle empty holder");
        }
        if (this.HIStory.size() == 0) {
            return this.current();
        }
        return this.HIStory.get(this.HIStory.size() - 1);
    }

    public E next() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot next when no elements");
        }
        int oldPosition = this.cursorPosition;
        this.cursorPosition = (this.cursorPosition == this.holder.size() - 1 ? -1 : this.cursorPosition) + 1;
        if (oldPosition != this.cursorPosition) {
            this.HIStory.add(this.holder.get(oldPosition));
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E restore() {
        if (this.numberOfDeletedElementsToKeep == 0) {
            throw new IllegalStateException("Restoring isn't supported");
        }
        if (this.resurrection.size() == 0) {
            return null;
        }
        this.HIStory.add(this.current());
        return this.add(this.decorator.decorateFromRestore(this.resurrection.remove(this.resurrection.size() - 1)));
    }

    public E previous() {
        if (this.holder.size() == 0) {
            throw new IllegalStateException("Cannot previous when no elements");
        }
        int oldPosition = this.cursorPosition;
        this.cursorPosition = (this.cursorPosition == 0 ? this.holder.size() : this.cursorPosition) - 1;
        if (oldPosition != this.cursorPosition) {
            this.HIStory.add(this.holder.get(oldPosition));
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E remove() {
        return this.removeIndices(this.asSet(this.cursorPosition));
    }

    public E removeAndChangeToPrevious() {
        return this.removeIndices(this.asSet(this.cursorPosition), true);
    }

    public E removeAndChangeToPrevious(int index) {
        return this.removeIndices(this.asSet(index), true);
    }

    public E removeLeft() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).filter(i -> i < this.cursorPosition).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    public E removeAll() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    public E removeRight() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).filter(i -> i > this.cursorPosition).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    public E removeOthers() {
        return this.removeIndices(IntStream.range(0, this.holder.size()).filter(i -> i != this.cursorPosition).mapToObj(i -> i).collect(Collectors.toSet()));
    }

    private E removeIndices(Set<Integer> indices) {
        return this.removeIndices(indices, false);
    }

    /*
     * Unable to fully structure code
     */
    private E removeIndices(Set<Integer> indices, boolean previousAsCurrent) {
        if (this.cursorPosition < 0) {
            throw new IllegalArgumentException("No elements so no current");
        }
        if (indices.size() == 0) {
            return this.current();
        }
        itemsToRemove = new LinkedHashMap<Integer, E>();
        cursorShift = 0;
        for (Integer i : indices.stream().sorted((Comparator)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)I, lambda$7(java.lang.Integer java.lang.Integer ), (Ljava/lang/Integer;Ljava/lang/Integer;)I)()).collect(Collectors.toList())) {
            if (i < 0 || i >= this.holder.size()) {
                throw new ArrayIndexOutOfBoundsException("Indice " + i + " is outside of bounds");
            }
            itemsToRemove.put(i, this.holder.get(i));
            if (i > this.cursorPosition) continue;
            --cursorShift;
        }
        oldCursorPosition = this.cursorPosition;
        var7_9 = itemsToRemove.keySet().iterator();
        while (var7_9.hasNext()) {
            item = (Integer)var7_9.next();
            i = 0;
            while (i < this.listeners.size()) {
                l = this.listeners.get(i);
                if (!l.previewDeleted(this.holder.get(item), item)) {
                    this.cursorPosition = item;
                    return this.getCurrentAndRaiseEvent();
                }
                ++i;
            }
            this.holder.remove(item);
            element = itemsToRemove.get(item);
            this.removeRelated(element);
            i = 0;
            while (i < this.listeners.size()) {
                try {
                    this.listeners.get(i).deleted(element, item);
                }
                catch (Exception var10_15) {
                    // empty catch block
                }
                ++i;
            }
        }
        if (previousAsCurrent && this.HIStory.size() > 0) {
            element = this.HIStory.remove(this.HIStory.size() - 1);
            prevCurrent = oldCursorPosition + cursorShift;
            this.cursorPosition = this.holder.indexOf(element);
            if (this.cursorPosition != prevCurrent && prevCurrent > -1) {
                this.HIStory.add(this.holder.get(prevCurrent));
            }
            return this.getCurrentAndRaiseEvent();
        }
        this.cursorPosition = oldCursorPosition + cursorShift;
        if (this.cursorPosition < 0 && this.holder.size() > 0) {
            this.cursorPosition = 0;
        }
        if (this.cursorPosition >= 0) ** GOTO lbl56
        return null;
lbl-1000:
        // 1 sources

        {
            this.HIStory.remove(this.HIStory.size() - 1);
lbl56:
            // 2 sources

            ** while (this.HIStory.size() > 0 && this.HIStory.get((int)(this.HIStory.size() - 1)).equals(this.holder.get((int)this.cursorPosition)))
        }
lbl57:
        // 1 sources

        return this.getCurrentAndRaiseEvent();
    }

    public int size() {
        return this.holder.size();
    }

    public E remove(int index) {
        return this.removeIndices(this.asSet(index));
    }

    private void checkIndexParam(int index) {
        if (index < 0 || index >= this.holder.size()) {
            throw new IllegalArgumentException("Index " + index + " out of bounds");
        }
    }

    @SafeVarargs
    private final <T> Set<T> asSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    public E remove(E el) {
        if (el == null) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        int i = this.holder.indexOf(el);
        if (i == -1) {
            throw new IllegalArgumentException(String.format("Element %s not found", el));
        }
        return this.remove((E)i);
    }

    public E replaceCurrent(E newElement) {
        if (this.cursorPosition < 0) {
            return this.add(newElement);
        }
        Object oldCurrent = this.current();
        this.HIStory.replaceAll(l -> {
            if (l.equals(oldCurrent)) {
                return newElement;
            }
            return l;
        });
        this.holder.set(this.cursorPosition, newElement);
        int x = 0;
        while (x < this.listeners.size()) {
            this.listeners.get(x).replaced(newElement, oldCurrent, this.cursorPosition);
            ++x;
        }
        return this.getCurrentAndRaiseEvent();
    }

    public E replaceWith(E oldEl, E newEl) {
        int index;
        this.cursorPosition = index = this.holder.indexOf(oldEl);
        return this.replaceCurrent(newEl);
    }

    public E current() {
        if (this.cursorPosition < 0) {
            throw new IllegalArgumentException("No elements so no current");
        }
        return this.holder.get(this.cursorPosition);
    }

    public E current(E element) {
        if (element == null) {
            throw new IllegalArgumentException("cannot set current to null");
        }
        int index = this.holder.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException("Element " + element + " not found");
        }
        if (this.cursorPosition >= 0 && index != this.cursorPosition) {
            this.HIStory.add(this.current());
        }
        this.cursorPosition = index;
        return this.getCurrentAndRaiseEvent();
    }

    public E current(int index) {
        this.checkIndexParam(index);
        if (this.cursorPosition >= 0 && index != this.cursorPosition) {
            this.HIStory.add(this.current());
        }
        this.cursorPosition = index;
        return this.getCurrentAndRaiseEvent();
    }

    public List<E> view() {
        return Collections.unmodifiableList(this.holder);
    }

    public List<E> historyView() {
        LinkedHashSet<E> items = new LinkedHashSet<E>(this.view());
        LinkedHashSet finalItems = new LinkedHashSet();
        if (this.size() > 0) {
            finalItems.add(this.current());
        }
        int i = this.HIStory.size() - 1;
        while (i >= 0) {
            if (finalItems.size() == items.size()) {
                return new ArrayList(finalItems);
            }
            finalItems.add(this.HIStory.get(i));
            --i;
        }
        for (Object item : items) {
            if (finalItems.size() == items.size()) break;
            finalItems.add(item);
        }
        return new ArrayList(finalItems);
    }

    public int currentIndex() {
        return this.cursorPosition;
    }

    public E getValueAt(int index) {
        this.checkIndexParam(index);
        return this.holder.get(index);
    }

    public int getIndex(E element) {
        return this.holder.indexOf(element);
    }

    private E getCurrentAndRaiseEvent() {
        E current = this.holder.get(this.cursorPosition);
        int x = 0;
        while (x < this.listeners.size()) {
            this.listeners.get(x).newCurrent(current, this.cursorPosition);
            ++x;
        }
        return current;
    }

    private void removeRelated(E element) {
        if (this.numberOfDeletedElementsToKeep > 0) {
            this.resurrection.remove(element);
            this.decorator.clear(element);
            if (this.resurrection.size() == this.numberOfDeletedElementsToKeep) {
                E removed = this.resurrection.remove(0);
                this.decorator.clear(removed);
                int x2 = 0;
                while (x2 < this.listeners.size()) {
                    this.listeners.get(x2).removedFromResurrection(removed);
                    ++x2;
                }
            }
            int x3 = 0;
            while (x3 < this.listeners.size()) {
                this.listeners.get(x3).resyncElementBeforeDelete(element);
                ++x3;
            }
            this.resurrection.add(this.decorator.decorateToRestore(element));
        }
        this.HIStory = this.HIStory.stream().filter(f -> !f.equals(element)).collect(() -> new ArrayList(), (l, x) -> {
            if (l.size() == 0 || !l.get(l.size() - 1).equals(x)) {
                l.add(x);
            }
        }, (l, x) -> l.addAll(x));
    }

    private static /* synthetic */ int lambda$7(Integer a, Integer b) {
        return b.compareTo(a);
    }

    public static interface CardHolderListener<E> {
        default public boolean previewDeleted(E element, int index) {
            return true;
        }

        public void deleted(E var1, int var2);

        public void replaced(E var1, E var2, int var3);

        public void added(E var1, int var2);

        public void newCurrent(E var1, int var2);

        default public void removedFromResurrection(E element) {
        }

        default public E resyncElementBeforeDelete(E element) {
            return element;
        }
    }
}

