/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.core.CommandBinding;
import com.sigge.filerunner.core.GsonFactory;
import com.siggemannen.backgroundrunner.AccumulatedBackgroundRunner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import javax.swing.KeyStroke;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigHandler {
    private static final String SETTING_FILE_ENCODING = "UTF-8";
    private static final String SETTING_FILE = "settings.json";
    private static volatile Config CONFIG = new Config();
    private static volatile boolean loading = true;
    private static boolean configError = false;
    private static boolean backupError = false;
    private static boolean mock = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigHandler.class);
    private static final Gson GSON_WRITER = GsonFactory.forWriting();

    public static void load() {
        ConfigHandler.load(SETTING_FILE, SETTING_FILE_ENCODING);
    }

    public static Config load(String file, String encoding) {
        loading = true;
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(SETTING_FILE), SETTING_FILE_ENCODING);){
                CONFIG = (Config)GsonFactory.forReading().fromJson((Reader)reader, Config.class);
                if (CONFIG == null) {
                    CONFIG = new Config();
                    LOGGER.error("Config was null when loaded");
                    configError = true;
                    try {
                        ConfigHandler.createBackup();
                    }
                    catch (IOException e) {
                        backupError = true;
                    }
                } else {
                    configError = false;
                    backupError = false;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonSyntaxException jsonE) {
            configError = true;
            CONFIG = new Config();
            try {
                ConfigHandler.createBackup();
            }
            catch (IOException e) {
                backupError = true;
            }
        }
        catch (FileNotFoundException jsonE) {
        }
        catch (Exception e) {
            LOGGER.error("Couldn't load config file", (Throwable)e);
        }
        loading = false;
        return CONFIG;
    }

    private static void createBackup() throws IOException, FileNotFoundException {
        ConfigHandler.createBackup("backup_settings.json");
    }

    private static void createBackup(String name) throws IOException, FileNotFoundException {
        Files.copy(Paths.get(SETTING_FILE, new String[0]), new FileOutputStream(name));
    }

    public static void saveInBackground() {
        AccumulatedBackgroundRunner.schedule((String)"saveSettings", () -> ConfigHandler.saveAndIgnoreErrors(), (int)300, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public static void saveAndIgnoreErrors() {
        try {
            ConfigHandler.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void save() throws Exception {
        if (mock || CONFIG == null) {
            return;
        }
        int i = 0;
        while (i < 3) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(SETTING_FILE), SETTING_FILE_ENCODING);){
                    GSON_WRITER.toJson((Object)CONFIG, (Appendable)writer);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                if (i == 2) {
                    throw new Exception("Error while saving config, check backup file");
                }
                ++i;
            }
        }
    }

    public static Config getConfig() {
        while (loading) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return CONFIG;
    }

    public static boolean isConfigError() {
        return configError;
    }

    public static boolean isBackupError() {
        return backupError;
    }

    public static KeyStroke getForCommand(FileRunnerAction action, String scope) {
        KeyStroke k = action.getDefaultKeyStroke();
        for (CommandBinding cb : CONFIG.getBindings()) {
            if (cb.getBinding() == null || !cb.getCommandId().equals(action.id())) continue;
            if (Objects.equal((Object)scope, (Object)cb.getScope())) {
                return KeyStroke.getKeyStroke(cb.getBinding());
            }
            if (cb.getScope() != null) continue;
            k = KeyStroke.getKeyStroke(cb.getBinding());
        }
        return k;
    }

    @VisibleForTesting
    public static void setConfig(Config c) {
        CONFIG = c;
        loading = false;
        mock = true;
    }
}

