/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.awt.Color;
import java.lang.reflect.Type;

public class ColorTypeAdapter
implements JsonDeserializer<Color>,
JsonSerializer<Color> {
    public Color deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonObject)) {
            throw new JsonParseException("The color " + json + " is not an object!");
        }
        if (!json.getAsJsonObject().has("value")) {
            throw new JsonParseException("The color " + json + " has no value!");
        }
        Color color = new Color(json.getAsJsonObject().get("value").getAsInt());
        return color;
    }

    public JsonElement serialize(Color value, Type type, JsonSerializationContext context) {
        JsonObject colorObject = new JsonObject();
        colorObject.add("value", (JsonElement)new JsonPrimitive((Number)value.getRGB()));
        colorObject.add("falpha", (JsonElement)new JsonPrimitive((Number)Float.valueOf(0.0f)));
        return colorObject;
    }
}

