/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.IUsageObject;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SQLSubObject
implements Comparable<SQLSubObject>,
IUsageObject {
    private static final String USAGE = "usage";
    private final String name;
    private final String type;
    private Map<String, Object> customProperties = null;

    public SQLSubObject(String name, String datatype) {
        this.name = name;
        this.type = datatype;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Optional<Map<String, Object>> getCustomProperties() {
        return Optional.ofNullable(this.customProperties);
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    @Override
    public int compareTo(SQLSubObject o) {
        if (o == null) {
            return 1;
        }
        return this.getName().compareToIgnoreCase(o.getName());
    }

    public String toString() {
        return "\nSubject=[" + this.name + ", type=" + this.type + " props=" + this.customProperties;
    }

    public <T> T getCustomProperty(String property) {
        if (this.customProperties == null) {
            return null;
        }
        return (T)this.customProperties.get(property);
    }

    public <T> T getCustomProperty(String name, T defaultValue) {
        T t = this.getCustomProperty(name);
        return t == null ? defaultValue : t;
    }

    public <T> SQLSubObject putCustomProperty(String property, T value) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        this.customProperties.put(property, value);
        return this;
    }

    @Override
    public Optional<SQLObjectUsage> getUsage() {
        return Optional.ofNullable((SQLObjectUsage)this.getCustomProperty(USAGE));
    }

    @Override
    public void setUsage(SQLObjectUsage usage) {
        this.putCustomProperty(USAGE, usage);
    }

    public static class SQLSubObjectBuilder {
        private final SQLSubObject sub;

        public SQLSubObjectBuilder(String name, String dataType) {
            this.sub = new SQLSubObject(name, dataType);
        }

        public SQLSubObject build() {
            return this.sub;
        }
    }
}

