/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.dbrunner.Database;
import com.sigge.filerunner.completion.domain.IUsageObject;
import com.sigge.filerunner.completion.domain.SQLIndex;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLObjectUsage;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.DatabaseFromConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SQLObject
implements Comparable<SQLObject>,
IUsageObject {
    private static final String CONTEXT_DB = "$db";
    private static final String SERVER_ID = "$id";
    private static final String USAGE = "usage";
    private final int id;
    private final String name;
    private final String nativeType;
    private List<SQLSubObject> columns = new ArrayList<SQLSubObject>();
    private List<SQLSubObject> parameters = new ArrayList<SQLSubObject>();
    private List<SQLIndex> indexes = new ArrayList<SQLIndex>();
    private final String schemaName;
    private String returnType = null;
    private final SQLObjectType sqlType;
    private final DatabaseContext context;
    private final boolean systemObject;
    private final boolean builtIn;
    private Map<String, Object> customProperties = null;

    public SQLObject(DatabaseContext context, int id, String name, String nativeType, SQLObjectType type, String schemaName, boolean systemObject) {
        this(context, id, name, nativeType, type, schemaName, systemObject, false);
    }

    public SQLObject(DatabaseContext context, int id, String name, String nativeType, SQLObjectType type, String schemaName, boolean systemObject, boolean builtIn) {
        this.context = context;
        this.id = id;
        this.name = name;
        this.nativeType = nativeType;
        this.schemaName = schemaName;
        this.systemObject = systemObject;
        this.sqlType = type;
        this.builtIn = builtIn;
    }

    public SQLObject(SQLObject object) {
        this(object, false);
    }

    public SQLObject(SQLObject object, boolean keepContext) {
        this(object, keepContext, null);
    }

    public SQLObject(SQLObject object, boolean keepContext, String newName) {
        Database db;
        this.context = keepContext ? object.context : null;
        this.id = object.id;
        this.name = newName != null ? newName : object.name;
        this.nativeType = object.nativeType;
        this.schemaName = object.schemaName;
        this.systemObject = object.systemObject;
        this.sqlType = object.sqlType;
        this.columns.addAll(object.columns);
        this.parameters.addAll(object.parameters);
        this.indexes.addAll(object.indexes);
        this.builtIn = object.isBuiltIn();
        this.customProperties = object.customProperties;
        if (this.context == null && object.context != null && (db = object.context.getDatabase().getDb()) instanceof DatabaseFromConfig) {
            this.putCustomProperty(SERVER_ID, ((DatabaseFromConfig)db).getConfig().getId());
            this.putCustomProperty(CONTEXT_DB, object.context.getDatabase().getDatabase());
        }
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    public void addColumn(SQLSubObject object) {
        this.columns.add(object);
    }

    public void addParameter(SQLSubObject param) {
        this.parameters.add(param);
    }

    public void addIndex(SQLIndex index) {
        this.indexes.add(index);
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public <T> T getCustomProperty(String property) {
        if (this.customProperties == null) {
            return null;
        }
        return (T)this.customProperties.get(property);
    }

    public <T> SQLObject putCustomProperty(String property, T value) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, Object>();
        }
        this.customProperties.put(property, value);
        return this;
    }

    public boolean ofType(SQLObjectType ... objectTypes) {
        SQLObjectType[] sQLObjectTypeArray = objectTypes;
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            SQLObjectType type = sQLObjectTypeArray[n2];
            if (type == this.sqlType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getFullName() {
        return this.schemaName.length() == 0 ? this.name : String.valueOf(this.schemaName) + "." + this.name;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public List<SQLSubObject> getColumns() {
        return this.columns;
    }

    public List<? extends SQLSubObject> getParameters() {
        return this.parameters;
    }

    public List<SQLIndex> getIndexes() {
        return this.indexes;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void finish() {
        if (this.columns.size() == 0) {
            this.columns = Collections.EMPTY_LIST;
        }
        if (this.parameters.size() == 0) {
            this.parameters = Collections.EMPTY_LIST;
        }
        if (this.indexes.size() == 0) {
            this.indexes = Collections.EMPTY_LIST;
        }
    }

    @Override
    public int compareTo(SQLObject o) {
        int compare = this.getName().compareToIgnoreCase(o.getName());
        return compare != 0 ? compare : this.getSchemaName().compareToIgnoreCase(o.getSchemaName());
    }

    public SQLObjectType getSQLType() {
        return this.sqlType;
    }

    public DatabaseContext getContext() {
        return this.context;
    }

    public boolean isSystemObject() {
        return this.systemObject;
    }

    public String toString() {
        return "[id=" + this.id + ", name=" + this.name + ", type=" + this.nativeType + "]";
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    @Override
    public Optional<SQLObjectUsage> getUsage() {
        return Optional.ofNullable((SQLObjectUsage)this.getCustomProperty(USAGE));
    }

    @Override
    public void setUsage(SQLObjectUsage usage) {
        this.putCustomProperty(USAGE, usage);
    }

    public Integer getContextServerId() {
        return (Integer)this.getCustomProperty(SERVER_ID);
    }

    public String getContextDatabase() {
        return (String)this.getCustomProperty(CONTEXT_DB);
    }
}

