/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SQLIndex {
    private final String name;
    private final SQLObject parent;
    private final boolean isPrimary;
    private final boolean isUnique;
    private final boolean isClustered;
    private Map<String, Object> customProperties = null;
    private final List<SQLSubObject> columns = new ArrayList<SQLSubObject>();
    private final List<SQLSubObject> includeColumns = new ArrayList<SQLSubObject>();

    public SQLIndex(String name, SQLObject parent, boolean isPrimary, boolean isUnique, boolean isClustered) {
        this.name = name;
        this.parent = parent;
        this.isPrimary = isPrimary;
        this.isUnique = isUnique;
        this.isClustered = isClustered;
    }

    public String getName() {
        return this.name;
    }

    public SQLObject getParent() {
        return this.parent;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    public void addColumn(SQLSubObject column) {
        this.columns.add(column);
    }

    public void addIncluded(SQLSubObject column) {
        this.includeColumns.add(column);
    }

    public Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, Object> customProperties) {
        this.customProperties = customProperties;
    }

    public List<SQLSubObject> getColumns() {
        return this.columns;
    }

    public List<SQLSubObject> getIncludeColumns() {
        return this.includeColumns;
    }

    public String toString() {
        return "Index[" + this.name + ", parent=" + this.parent + "is primary=" + this.isPrimary + ", unique:" + this.isUnique + ", clustered=" + this.isClustered + ", custom=" + this.customProperties + ", cols=" + this.columns + this.includeColumns;
    }
}

