/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion.domain;

import com.sigge.filerunner.completion.domain.ISQLCompletion;
import com.sigge.filerunner.completion.domain.IWeightedCompletion;
import com.sigge.filerunner.completion.domain.SQLObject;
import javax.swing.Icon;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.FunctionCompletion;

public class SQLBaseFunctionCompletion
extends FunctionCompletion
implements ISQLCompletion,
IWeightedCompletion {
    protected SQLObject object;
    protected final boolean appendSchema;
    private int weight;

    public SQLBaseFunctionCompletion(CompletionProvider provider, SQLObject object, Icon icon, int relevance, boolean appendSchema) {
        super(provider, object.getContext().getQuotedIdentifier(object.getName()), object.getReturnType());
        this.object = new SQLObject(object);
        this.appendSchema = appendSchema;
        this.setIcon(icon);
        this.setRelevance(relevance);
    }

    @Override
    public SQLObject getObject() {
        return this.object;
    }

    @Override
    public boolean appendSchema() {
        return this.appendSchema;
    }

    @Override
    public int compareTo(Completion c2) {
        IWeightedCompletion bs = (IWeightedCompletion)c2;
        int relevanceCompare = Integer.compare(this.getRelevance(), bs.getRelevance());
        if (relevanceCompare != 0) {
            return -relevanceCompare;
        }
        int weight = Integer.compare(this.getWeight(), bs.getWeight());
        if (weight != 0) {
            return -weight;
        }
        return super.compareTo(c2);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(int weight) {
        this.weight = weight;
    }
}

