/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.sql.sqlserver.ClauseUtility;
import com.sigge.filerunner.sql.transform.Clause;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupAction;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.text.JTextComponent;
import org.antlr.v4.runtime.ParserRuleContext;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBContextOperator
extends DefaultCompletionProvider {
    private final DBCompletion completion;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBContextOperator.class);

    public DBContextOperator(DBCompletion completion) {
        this.completion = completion;
    }

    protected List<Completion> getCompletionsImpl(JTextComponent comp) {
        String lexeme = this.getAlreadyEnteredText(comp);
        ArrayList<Completion> retVal = new ArrayList<Completion>();
        SQLFile ctx = this.completion.getParseTree();
        Clause cx = ClauseUtility.findNearestStatement(comp.getCaretPosition(), ctx);
        TokenFinder f = null;
        if (cx != null && cx.getContext() != null && (f = CompletionUtils.getTokenAtPosition(cx.getContext(), comp.getCaretPosition())) != null && f.getNode() != null) {
            ParserRuleContext rx = f.getRule();
            String text = f.getNode().getText();
            if (CompletionUtils.isInExpression(rx, 651)) {
                text = rx.getParent().getText();
            }
            lexeme = text;
        }
        List<IPopupAction> actions = this.completion.getActionsForIdentifier(lexeme, f, new ArrayList<SQLObject>());
        try {
            retVal.addAll(actions.stream().map(l -> new ActionCompletion((CompletionProvider)this, (IPopupAction)l)).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOGGER.error("Error while building completion tree", (Throwable)e);
        }
        return retVal;
    }

    public static class ActionCompletion
    extends BasicCompletion {
        private final Runnable runnable;

        public ActionCompletion(CompletionProvider provider, IPopupAction action) {
            super(provider, action.getName());
            this.runnable = action.getAction();
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public int compareTo(Completion c2) {
            return 0;
        }
    }
}

