/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.completion.FinishedWalkingException;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectFilter;
import com.sigge.filerunner.completion.domain.TextToken;
import com.sigge.filerunner.view.IconUtils;
import com.siggemannen.core.ListUtils;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class CompletionUtils {
    static final String TABLE_NAME = "table.png";
    static final String VARIABLE_NAME = "variable.png";
    static final String PROCEDURE_NAME = "procedure.png";
    static final String FUNCTION_NAME = "function.png";
    static final String VIEW_NAME = "view.png";
    static final String COLUMN_NAME = "column.png";
    static final String DATABASE_NAME = "data.png";
    static final String KEY_NAME = "key.png";
    public static final ImageIcon TABLE_ICON = IconUtils.getSmallIcon("table.png");
    public static final ImageIcon COLUMN_ICON = IconUtils.getSmallIcon("column.png");
    public static final ImageIcon DATABASE_ICON = IconUtils.getSmallIcon("data.png");
    public static final ImageIcon VIEW_ICON = IconUtils.getSmallIcon("view.png");
    public static final ImageIcon FUNCTION_ICON = IconUtils.getSmallIcon("function.png");
    public static final ImageIcon PROCEDURE_ICON = IconUtils.getSmallIcon("procedure.png");
    public static final ImageIcon VARIABLE_ICON = IconUtils.getSmallIcon("variable.png");
    public static final ImageIcon KEY_ICON = IconUtils.getSmallIcon("key.png");
    public static final Predicate<SQLObject> SELECTABLE_PREDICATE = SQLObjectFilter.ofTables().or(SQLObjectFilter.ofTableFunctions()).or(SQLObjectFilter.ofViews());

    public static boolean isInExpression(ParserRuleContext pr, Integer ... rules) {
        if (pr == null) {
            return false;
        }
        if (ListUtils.in((Object)pr.getRuleIndex(), (Object[])rules)) {
            return true;
        }
        return CompletionUtils.isInExpression(pr.getParent(), rules);
    }

    public static int getContextEndIndex(ParserRuleContext context, int defaultIfMissing) {
        if (context == null || context.getStop() == null) {
            return defaultIfMissing;
        }
        return context.getStop().getStopIndex();
    }

    public static boolean tokenMatches(TextToken t, String ... s) {
        String[] stringArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            String toke = stringArray[n2];
            if (t.getText().equalsIgnoreCase(toke)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static TokenFinder getTokenAtPosition(ParserRuleContext context, int position) {
        return CompletionUtils.getTokenAtPosition(context, position, position);
    }

    public static TokenFinder getTokenAtPosition(ParserRuleContext context, int start, int end) {
        TokenFinder w = new TokenFinder(start, end);
        ParseTreeWalker tv = new ParseTreeWalker();
        try {
            tv.walk((ParseTreeListener)w, (ParseTree)context);
        }
        catch (FinishedWalkingException finishedWalkingException) {
            // empty catch block
        }
        return w;
    }

    public static ImageIcon getIconForType(SQLObject obj) {
        switch (obj.getSQLType()) {
            case STORED_PROCEDURE: {
                return PROCEDURE_ICON;
            }
            case INLINE_TABLE_FUNCTION: {
                return FUNCTION_ICON;
            }
            case TABLE_FUNCTION: {
                return FUNCTION_ICON;
            }
            case SCALAR_FUNCTION: {
                return FUNCTION_ICON;
            }
            case TABLE: {
                return TABLE_ICON;
            }
            case VIEW: {
                return VIEW_ICON;
            }
            case DATABASE: {
                return DATABASE_ICON;
            }
        }
        return null;
    }
}

