/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.completion;

import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.DBCompletionProviderDelegate;
import com.sigge.filerunner.completion.domain.BasicSQLCompletion;
import com.sigge.filerunner.completion.domain.IWeightedCompletion;
import com.sigge.filerunner.completion.domain.SQLCompletion;
import com.sigge.filerunner.completion.domain.SQLFunctionCompletion;
import com.sigge.filerunner.completion.domain.SQLIndex;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.completion.domain.SQLSubObject;
import com.sigge.filerunner.completion.domain.TextToken;
import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.sql.transform.declare.DeclareBlock;
import com.sigge.filerunner.view.rsyntaxtextarea.TSQLTokenMaker;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TSQLLexer;
import com.sigge.parsql.sql.transform.TokenType;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ADBCompletionProvider
extends DefaultCompletionProvider {
    protected final Map<Tuple<DatabaseContext, SQLObjectType>, CompletionProvider> contextHash = new HashMap<Tuple<DatabaseContext, SQLObjectType>, CompletionProvider>();
    private static final Logger LOGGER = LoggerFactory.getLogger(ADBCompletionProvider.class);

    protected IWeightedCompletion createCompletionFromString(String value) {
        BasicSQLCompletion cc = new BasicSQLCompletion((CompletionProvider)this, value);
        cc.setRelevance(-1);
        return cc;
    }

    protected IWeightedCompletion createCompletionFromVariable(DeclareBlock f) {
        return new BasicSQLCompletion((CompletionProvider)this, f.getVariable(), CompletionUtils.VARIABLE_ICON, String.valueOf(f.type.toUpperCase()) + (f.getDefaultValue() != null ? " DEFAULT " + f.getDefaultValue() : ""), "");
    }

    protected IWeightedCompletion createCompletionFromColumn(SQLObject so, SQLSubObject sob) {
        return new SQLCompletion((CompletionProvider)this, so, sob, CompletionUtils.COLUMN_ICON, 2, false, sob.getType());
    }

    protected IWeightedCompletion createCompletionFromTableOrAlias(String column) {
        BasicSQLCompletion col = new BasicSQLCompletion((CompletionProvider)this, column);
        col.setRelevance(3);
        return col;
    }

    public boolean isColumnPartOfPK(SQLObject so, SQLSubObject sub) {
        for (SQLIndex ix : so.getIndexes()) {
            if (!ix.isPrimary()) continue;
            for (SQLSubObject sox : ix.getColumns()) {
                if (sox.getName() == null || !sox.getName().equals(sub.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected IWeightedCompletion createCompletionFromColumn(String column) {
        BasicSQLCompletion basicSQLCompletion = new BasicSQLCompletion((CompletionProvider)this, column, CompletionUtils.COLUMN_ICON);
        basicSQLCompletion.setRelevance(1);
        return basicSQLCompletion;
    }

    protected IWeightedCompletion createCompletionFromColumn(String column, String alias) {
        if (alias != null && alias.length() > 0) {
            column = String.valueOf(alias) + "." + column;
        }
        BasicSQLCompletion basicSQLCompletion = new BasicSQLCompletion((CompletionProvider)this, column, CompletionUtils.COLUMN_ICON);
        basicSQLCompletion.setRelevance(1);
        return basicSQLCompletion;
    }

    protected IWeightedCompletion createCompletionFromSQLObject(SQLObject l, boolean appendSchema) {
        SQLObjectType objectType = l.getSQLType();
        ImageIcon icon = CompletionUtils.getIconForType(l);
        if (!l.isBuiltIn() && ListUtils.in((Object)((Object)objectType), (Object[])new SQLObjectType[]{SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.STORED_PROCEDURE, SQLObjectType.TABLE_FUNCTION})) {
            return new SQLFunctionCompletion(this.getProviderForSQLObject(l), l, icon, this.relevance(l), appendSchema);
        }
        if (l.isBuiltIn() && (l.getCustomProperties() == null || !((Boolean)l.getCustomProperties().get("niladic")).booleanValue())) {
            return new SQLFunctionCompletion(this.getProviderForSQLObject(l), l, icon, this.relevance(l), appendSchema);
        }
        return new SQLCompletion((CompletionProvider)this, l, (Icon)icon, this.relevance(l), appendSchema);
    }

    protected String getTypeFromObject(SQLObject so) {
        String type = null;
        switch (so.getSQLType()) {
            case DATABASE: {
                type = "Database";
                break;
            }
            case INLINE_TABLE_FUNCTION: {
                type = "Inline table function";
                break;
            }
            case SCALAR_FUNCTION: {
                type = "Scalar function";
                break;
            }
            case TABLE_FUNCTION: {
                type = "Table function";
                break;
            }
            case STORED_PROCEDURE: {
                type = "Procedure";
                break;
            }
            case TABLE: {
                type = "Table";
                break;
            }
            case VIEW: {
                type = "View";
                break;
            }
            case SCHEMA: {
                type = "Schema";
                break;
            }
            case SYNONYM: {
                type = "Synonym";
                break;
            }
            default: {
                type = "Other";
            }
        }
        if (so.isBuiltIn()) {
            type = "Built-in " + type;
        }
        return type;
    }

    private CompletionProvider getProviderForSQLObject(SQLObject so) {
        Tuple contextType = Tuple.of((Object)so.getContext(), (Object)((Object)so.getSQLType()));
        CompletionProvider val = this.contextHash.get(contextType);
        if (val == null) {
            char paramStart = so.getContext().getParameterListStart(so);
            char paramEnd = so.getContext().getParameterListEnd(so);
            String paramList = this.getParameterListSeparator();
            val = new DBCompletionProviderDelegate((CompletionProvider)this, paramStart, paramEnd, paramList);
        }
        return val;
    }

    protected boolean isOnCommentedLine(RSyntaxTextArea area) {
        int caretPos = area.getCaretPosition();
        Document doc = area.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(caretPos);
        Token tokenListForLine = area.getTokenListForLine(lineNum);
        while (tokenListForLine != null) {
            int type = tokenListForLine.getType();
            if (type == 1) {
                return true;
            }
            if (tokenListForLine.containsPosition(caretPos)) {
                return tokenListForLine.getType() == 2 || tokenListForLine.getType() < -100000;
            }
            tokenListForLine = tokenListForLine.getNextToken();
        }
        return false;
    }

    protected boolean isOnString(RSyntaxTextArea area) {
        int caretPos = area.getCaretPosition();
        Document doc = area.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(caretPos);
        Token tokenListForLine = area.getTokenListForLine(lineNum);
        while (tokenListForLine != null) {
            if (tokenListForLine.containsPosition(caretPos) || tokenListForLine.getEndOffset() == caretPos && tokenListForLine.getType() == 14) {
                return tokenListForLine.getType() == 14;
            }
            tokenListForLine = tokenListForLine.getNextToken();
        }
        return false;
    }

    protected Tuple<TextToken, TextToken> getPreviousToken(RSyntaxTextArea sta) {
        int lineNumber = sta.getCaretLineNumber();
        Token tokenOnLine = sta.getTokenListForLine(lineNumber);
        Token tokenOnLinePrev = null;
        boolean wrapped = false;
        if (lineNumber > 0) {
            for (tokenOnLinePrev = sta.getTokenListForLine(lineNumber - 1); tokenOnLinePrev != null && tokenOnLinePrev.getType() != 0; tokenOnLinePrev = tokenOnLinePrev.getNextToken()) {
                if (tokenOnLinePrev.getType() >= 0) continue;
                wrapped = true;
                break;
            }
        }
        List<ISQLToken> tokenz = null;
        String line = TextPaneUtil.getTextOnLine((RTextArea)sta);
        tokenz = wrapped && tokenOnLine != null ? this.fromRSToken(tokenOnLine) : TSQLLexer.parse((String)line);
        int charPos = sta.getCaretOffsetFromLineStart();
        ISQLToken lastT = null;
        ISQLToken currToken = null;
        for (ISQLToken t : tokenz) {
            if (t.in(new TokenType[]{TokenType.WHITESPACE, TokenType.NEWLINE, TokenType.COMMENT, TokenType.MULTICOMMENT, TokenType.NESTED_MULTICOMMENT, TokenType.TAB})) continue;
            if (t.getEnd() < charPos - 1) {
                lastT = t;
                continue;
            }
            currToken = t;
            break;
        }
        TextToken prev = lastT != null ? new TextToken(lastT, line.substring(lastT.getStart(), lastT.getEnd() + 1)) : null;
        TextToken curr = currToken != null ? new TextToken(currToken, line.substring(currToken.getStart(), currToken.getEnd() + 1)) : null;
        return new Tuple((Object)prev, (Object)curr);
    }

    private List<ISQLToken> fromRSToken(Token token) {
        ArrayList<ISQLToken> toke = new ArrayList<ISQLToken>();
        while (token != null) {
            if (token.getType() == 0) break;
            com.sigge.parsql.sql.transform.Token t = new com.sigge.parsql.sql.transform.Token(TSQLTokenMaker.mapTokenToToken(token.getType()), 0, token.length());
            toke.add((ISQLToken)t);
            token = token.getNextToken();
        }
        return toke;
    }

    protected int relevance(SQLObject o) {
        SQLObjectType objectType = o.getSQLType();
        if (objectType.in(SQLObjectType.DATABASE, SQLObjectType.SCHEMA)) {
            return o.isSystemObject() ? -6 : -4;
        }
        if (objectType.in(SQLObjectType.VIEW, SQLObjectType.TABLE) && o.isSystemObject()) {
            return -3;
        }
        if (objectType.in(SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.STORED_PROCEDURE, SQLObjectType.TABLE_FUNCTION)) {
            return o.isSystemObject() ? -3 : -2;
        }
        return o.isSystemObject() ? -5 : 1;
    }

    protected void verifyCompletions(List<Completion> completions) {
        int i = 0;
        while (i < completions.size()) {
            int j = 0;
            while (j < completions.size()) {
                int x = 0;
                while (x < completions.size()) {
                    IWeightedCompletion zz = (IWeightedCompletion)completions.get(i);
                    IWeightedCompletion zz1 = (IWeightedCompletion)completions.get(j);
                    IWeightedCompletion zz2 = (IWeightedCompletion)completions.get(x);
                    int compareTo = zz.compareTo(zz1);
                    int compareTo23 = zz1.compareTo(zz2);
                    int compareTo13 = zz.compareTo(zz2);
                    if (compareTo < 0 && compareTo23 < 0 && compareTo13 > 0) {
                        LOGGER.error("Error between: " + zz + ", rel:" + zz.getRelevance() + ", weight:" + zz.getWeight() + " to " + zz1 + ", rel:" + zz1.getRelevance() + ", weight:" + zz1.getWeight() + zz2 + ", rel:" + zz2.getRelevance() + ", weight:" + zz2.getWeight() + ", result1:" + compareTo + ", result23:" + compareTo23 + " result13:" + compareTo13);
                    }
                    ++x;
                }
                ++j;
            }
            ++i;
        }
    }

    public static class Wrapee {
        private final String original;
        private final String lowercase;

        public Wrapee(String s) {
            this.original = s;
            this.lowercase = s.toLowerCase();
        }

        public int hashCode() {
            return this.lowercase.hashCode();
        }

        public boolean equals(Object obj) {
            return this.lowercase.equals(((Wrapee)obj).lowercase);
        }

        public String getOriginal() {
            return this.original;
        }

        public String getLowercase() {
            return this.lowercase;
        }
    }
}

