/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.commands;

import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.sql.sqlserver.SQLServerSQLService;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.view.IEditorManager;
import com.siggemannen.core.Tuple;
import java.util.List;
import java.util.Map;
import javax.swing.text.JTextComponent;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public abstract class ARotateOccurancesAction {
    protected final IEditorManager manager;
    protected final Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap;
    private final boolean forward;

    ARotateOccurancesAction(IEditorManager manager, Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> completionMap, boolean forward) {
        this.manager = manager;
        this.completionMap = completionMap;
        this.forward = forward;
    }

    protected void move() {
        RSyntaxTextArea currentTextArea = this.manager.getCurrentTab();
        DBCompletion provider = (DBCompletion)this.completionMap.get(currentTextArea).second();
        SQLFile file = provider.getParseTree();
        if (file == null) {
            return;
        }
        TokenFinder w = CompletionUtils.getTokenAtPosition(file.getContext(), Math.min(currentTextArea.getCaret().getDot(), currentTextArea.getCaret().getMark()), Math.max(currentTextArea.getCaret().getDot(), currentTextArea.getCaret().getMark()));
        if (w == null || w.getRule() == null) {
            return;
        }
        if (w.getRule() != null && w.getNode().getSymbol().getType() == 951) {
            ARotateOccurancesAction.getOccurances(file, w, (JTextComponent)currentTextArea, w.getNode().getText(), this.forward);
        }
    }

    public static void getOccurances(SQLFile file, TokenFinder w, JTextComponent currentTextArea, String text, boolean forward) {
        int caretpos = w.getNode().getSymbol().getStartIndex();
        List<TerminalNode> params = SQLServerSQLService.getVariableOccurences(file, caretpos, text, true);
        if (params.size() > 0) {
            int token = 0;
            int i = 0;
            while (i < params.size()) {
                Token tn = params.get(i).getSymbol();
                if (caretpos >= tn.getStartIndex() && caretpos <= tn.getStopIndex()) {
                    token = i;
                    break;
                }
                ++i;
            }
            if (forward) {
                if (++token == params.size()) {
                    token = 0;
                }
            } else if (--token < 0) {
                token = params.size() - 1;
            }
            currentTextArea.getCaret().setDot(params.get(token).getSymbol().getStartIndex());
            currentTextArea.getCaret().moveDot(params.get(token).getSymbol().getStopIndex() + 1);
        }
    }
}

