/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.sigge.dbrunner.sqlserver.SQLServerDatabase;
import com.sigge.filerunner.completion.CompletionManager;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.Feedback;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.export.csv.CsvExportAction;
import com.sigge.filerunner.export.excel.ExcelAction;
import com.sigge.filerunner.export.inserts.IScripter;
import com.sigge.filerunner.export.inserts.ScriptExportAction;
import com.sigge.filerunner.export.inserts.Scripter;
import com.sigge.filerunner.export.json.JsonExportAction;
import com.sigge.filerunner.export.xml.XMLExportAction;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.ISQLManager;
import com.sigge.filerunner.sql.edit.IEditor;
import com.sigge.filerunner.sql.edit.ParserEditor;
import com.sigge.filerunner.sql.sqlserver.TSQLFoldParser;
import com.sigge.filerunner.sql.sqlserver.jobs.SQLServerJobManager;
import com.sigge.filerunner.view.EditorManager;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IEditorResource;
import com.sigge.filerunner.view.IQueryActionHolder;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.MainPanel;
import com.sigge.filerunner.view.RunnerPresenter;
import com.sigge.filerunner.view.StatusUpdater;
import com.sigge.filerunner.view.TabContentCellRenderer;
import com.sigge.filerunner.view.changedb.ChangeDatabasePreviewer;
import com.sigge.filerunner.view.core.Cleanuper;
import com.sigge.filerunner.view.core.ITableSerializer;
import com.sigge.filerunner.view.core.IWindowState;
import com.sigge.filerunner.view.core.TableSerializer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.sigge.filerunner.view.menu.MenuBuilder;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.export.scripter.IScriptOutputPresenter;
import com.sigge.filerunner.view.results.export.scripter.ScriptOutputPresenter;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.DefaultPopupHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupHandler;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.SQLScriptReporter;
import com.sigge.filerunner.view.tabs.ITabManagerSwitcher;
import com.sigge.filerunner.view.tabs.ITabSaver;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentEditorListener;
import com.sigge.filerunner.view.tabs.TabContentOffloader;
import com.sigge.filerunner.view.tabs.TabManager;
import com.sigge.filerunner.view.tabs.TabManagerSaver;
import com.sigge.filerunner.view.tabs.TabManagerSwitcher;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.Component;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunnerModule
extends AbstractModule {
    public static final String MAIN_FRAME = "mainFrame";
    public static final String EXIT_LISTENER = "exitListener";
    public static final String MAIN_TAB = "mainTab";
    public static final String MODEL_REPOSITORY = "model_repository";
    public static final String TABCONTENT_RENDERER = "tabContentRenderer";
    private static final Logger LOGGER = LoggerFactory.getLogger(RunnerModule.class);

    protected void configure() {
        LOGGER.info("start bind");
        this.bind(MenuBuilder.class).in(Singleton.class);
        this.bind(IEditorManager.class).to(EditorManager.class).in(Singleton.class);
        this.bind(IPopupHandler.class).to(DefaultPopupHandler.class);
        this.bind(ListCellRenderer.class).annotatedWith((Annotation)Names.named((String)TABCONTENT_RENDERER)).to(TabContentCellRenderer.class).in(Singleton.class);
        this.bind(DefaultCompletionProvider.class).toInstance((Object)CompletionManager.createProvider());
        this.bind(ChangeDatabasePreviewer.class).to(RunnerPresenter.class).in(Singleton.class);
        this.bind(IFeedback.class).to(Feedback.class).in(Singleton.class);
        this.bind(ITabSaver.class).to(TabManagerSaver.class).in(Singleton.class);
        this.bind(ITabManagerSwitcher.class).to(TabManagerSwitcher.class).in(Singleton.class);
        this.bind(IStatusUpdater.class).to(StatusUpdater.class).in(Singleton.class);
        this.bind(ISQLManager.class).to(RunnerPresenter.class).in(Singleton.class);
        this.bind(IRunningState.class).to(SQLScriptReporter.class).in(Singleton.class);
        this.bind(IEditor.class).to(ParserEditor.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<Consumer<File>>(){}).toProvider(TabManager.class).in(Singleton.class);
        this.bind(DatabaseManager.class);
        this.bind(IWindowState.class).to(Cleanuper.class);
        this.bind(IScriptOutputPresenter.class).to(ScriptOutputPresenter.class).in(Singleton.class);
        this.bind(IScripter.class).to(Scripter.class).in(Singleton.class);
        this.bind(IQueryActionHolder.class).to(RunnerPresenter.class).in(Singleton.class);
        this.bind(ITableSerializer.class).to(TableSerializer.class).in(Singleton.class);
        Multibinder actions = Multibinder.newSetBinder((Binder)this.binder(), ExportAction.class);
        actions.addBinding().to(ExcelAction.class);
        actions.addBinding().to(CsvExportAction.class);
        actions.addBinding().to(XMLExportAction.class);
        actions.addBinding().to(JsonExportAction.class);
        actions.addBinding().to(ScriptExportAction.class);
        Multibinder tabListeners = Multibinder.newSetBinder((Binder)this.binder(), TabContentEditorListener.class);
        tabListeners.addBinding().to(RunnerPresenter.class);
        tabListeners.addBinding().to(EditorManager.class);
        Multibinder resources = Multibinder.newSetBinder((Binder)this.binder(), IEditorResource.class);
        resources.addBinding().to(TSQLFoldParser.class);
        MapBinder jobServerManagerBinder = MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)new TypeLiteral<String>(){}, (TypeLiteral)new TypeLiteral<IJobServerManager>(){});
        jobServerManagerBinder.addBinding((Object)SQLServerDatabase.PROVIDER_NAME).to(SQLServerJobManager.class);
        LOGGER.info("finish bind");
    }

    @Provides
    @Singleton
    @Named(value="mainFrame")
    JFrame mainFrame(MainPanel panel, Cleanuper listener) {
        JFrame f = new JFrame("FileRunner");
        f.setIconImages(Arrays.asList(IconUtils.getIcon("flash.png").getImage(), IconUtils.getSmallIcon("flash.png").getImage()));
        f.add((Component)((Object)panel));
        f.setFocusTraversalKeysEnabled(false);
        f.setExtendedState(ConfigHandler.getConfig().getBooleanConfigValue("viewConfig.maximizedState", true) != false ? 6 : 0);
        f.setLocationRelativeTo(null);
        f.setDefaultCloseOperation(0);
        f.addWindowListener(listener);
        return f;
    }

    @Provides
    @Singleton
    @Named(value="mainTab")
    DnDTabbedPane mainTabPane() {
        return new DnDTabbedPane();
    }

    @Provides
    @Singleton
    CardHolder<TabContent> getHolder() {
        return new CardHolder<TabContent>(30, new TabContentOffloader());
    }

    @Provides
    @Singleton
    @Named(value="model_repository")
    Map<String, IResultSetTable> getModelRepository() {
        return new HashMap<String, IResultSetTable>();
    }

    @Singleton
    @Provides
    public Map<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>> getCompletionMap() {
        return new HashMap<RSyntaxTextArea, Tuple<List<AutoCompletion>, DBCompletion>>();
    }
}

