/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.parsql.sql.transform;

import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TokenType;

public class OptimizedToken
implements ISQLToken {
    private final int start;
    private final short end;
    private final short tokenType;

    public OptimizedToken(TokenType tokenType, int start, int end) {
        this.tokenType = (short)tokenType.ordinal();
        this.start = start;
        this.end = (short)(end - start);
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.start + Short.toUnsignedInt(this.end);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.getFromTypeOrdinal(this.tokenType);
    }

    public String toString() {
        return "Token:" + this.tokenType + "; start=" + this.start + "; end =" + this.end;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        result = 31 * result + Short.hashCode(this.tokenType);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ISQLToken)) {
            return false;
        }
        ISQLToken other = (ISQLToken)obj;
        if (this.start != other.getStart()) {
            return false;
        }
        if (this.getTokenType() != other.getTokenType()) {
            return false;
        }
        return this.getEnd() == other.getEnd();
    }
}

