/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.thinlogger;

import com.siggemannen.thinlogger.Appender;
import java.io.PrintStream;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.event.Level;

public class ConsoleAppender
implements Appender {
    private final ReentrantLock rl = new ReentrantLock();

    @Override
    public void append(Level level, Throwable throwable, String sb) {
        if (!this.applicable(level)) {
            return;
        }
        PrintStream ps = level.compareTo((Enum)Level.INFO) >= 0 ? System.out : System.err;
        try {
            this.rl.lock();
            ps.println(sb);
            if (throwable != null) {
                throwable.printStackTrace(ps);
            }
            ps.flush();
        }
        finally {
            this.rl.unlock();
        }
    }

    @Override
    public boolean applicable(Level level) {
        return true;
    }
}

