/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.fileutils;

import com.sigge.fileutils.FileWatcherListener;
import com.sigge.fileutils.FileWatcherService;
import io.methvin.watcher.hashing.FileHasher;
import io.methvin.watchservice.MacOSXListeningWatchService;
import io.methvin.watchservice.WatchablePath;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FileWatcher
implements FileWatcherService {
    private WatchService watchService2;
    private final Map<Path, List<File>> filesToWatch = new ConcurrentHashMap<Path, List<File>>();
    private final Map<Path, WatchKey> keys = new ConcurrentHashMap<Path, WatchKey>();
    private volatile Boolean isrunning = false;
    private final List<FileWatcherListener> listeners = new ArrayList<FileWatcherListener>();
    private static final boolean MACOS = System.getProperty("os.name").toLowerCase().contains("mac");
    private static final ExecutorService EXECUTOR = Executors.newWorkStealingPool();
    private final Set<File> ignoreChangeQueue = Collections.synchronizedSet(new HashSet());
    private boolean inited;

    public FileWatcher() {
        try {
            this.watchService2 = MACOS ? new MacOSXListeningWatchService(new MacOSXListeningWatchService.Config(){

                public FileHasher fileHasher() {
                    return null;
                }
            }) : FileSystems.getDefault().newWatchService();
            this.inited = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void addFileToWatch(File fileToWatch) throws IOException {
        if (!this.inited) {
            return;
        }
        EXECUTOR.submit(() -> {
            try {
                this.addFileToWatchAsync(fileToWatch);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileToWatchAsync(File fileToWatch) throws IOException {
        Path p = fileToWatch.getParentFile().toPath();
        WatchKey wk = this.keys.get(p);
        if (wk == null) {
            wk = MACOS ? new WatchablePath(p).register(this.watchService2, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE}) : p.register(this.watchService2, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            this.keys.put(p, wk);
        }
        this.filesToWatch.computeIfAbsent(p, z -> new ArrayList()).add(fileToWatch);
        Boolean bl = this.isrunning;
        synchronized (bl) {
            if (!this.isrunning.booleanValue()) {
                Thread thread = new Thread(this::mainLoop);
                thread.setName("FileWatcher");
                thread.start();
            }
        }
    }

    @Override
    public void removeFileToWatch(File file) {
        Path p = file.getParentFile().toPath();
        List<File> list = this.filesToWatch.get(p);
        boolean b = list.remove(file);
        if (!b) {
            return;
        }
        if (list.size() == 0) {
            WatchKey w = this.keys.remove(p);
            w.cancel();
        }
    }

    @Override
    public void addFileChangeListener(FileWatcherListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeFileChangeListener(FileWatcherListener listener) {
        this.listeners.remove(listener);
    }

    private void mainLoop() {
        this.isrunning = true;
        while (true) {
            WatchKey key;
            try {
                key = this.watchService2.take();
            }
            catch (InterruptedException x) {
                return;
            }
            Path dir = FileWatcher.findKeyForValue(this.keys, key);
            if (dir == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<Path> ev;
                Path name;
                File child;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW || this.ignoreChangeQueue.contains(child = dir.resolve(name = (ev = this.cast(event)).context()).toFile()) || !this.filesToWatch.get(dir).contains(child)) continue;
                for (FileWatcherListener listener : this.listeners) {
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        listener.fileChanged(child);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    listener.fileDeleted(child);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            Path x = null;
            for (Map.Entry<Path, WatchKey> entry : this.keys.entrySet()) {
                if (entry.getValue() != key) continue;
                x = entry.getKey();
                break;
            }
            if (x != null) {
                this.keys.remove(x);
            }
            if (this.keys.isEmpty()) break;
        }
        this.isrunning = false;
    }

    private WatchEvent<Path> cast(WatchEvent<?> event) {
        return event;
    }

    private static <T, X> T findKeyForValue(Map<T, X> map, X value) {
        for (T key : map.keySet()) {
            if (!value.equals(map.get(key))) continue;
            return key;
        }
        return null;
    }

    @Override
    public void addFileSuspendWatch(File f) {
        this.ignoreChangeQueue.add(f);
    }

    @Override
    public void removeFileSuspendWatch(File f) {
        this.ignoreChangeQueue.remove(f);
    }
}

