/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.fileutils;

import com.sigge.fileutils.ArrayUtils;
import com.sigge.fileutils.IBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Bufferer
implements IBuffer {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int INITIAL_SIZE = 1000000;
    private final BufferType type;
    private long size;
    private final RandomAccessFile rafs;
    private File tempFile;
    private MappedByteBuffer buffer;
    private int valueSize;
    private int position;
    private int reposition1Count = 0;
    private int reposition2Count = 0;
    private long windowSize;
    private boolean sortMode = false;
    private boolean sortModePrevious = false;
    private long[] byteIndexes = new long[10];
    private int items = 0;
    private long index;
    private static List<File> CLEANING_QUEUE = new ArrayList<File>();
    private static ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();

    static {
        exec.scheduleWithFixedDelay(() -> Bufferer.cleanUpFiles(new AtomicInteger()), 1L, 1L, TimeUnit.MINUTES);
    }

    public Bufferer(BufferType bf, String dirPath) throws IOException {
        this(bf, 1000000L, dirPath);
    }

    public Bufferer(BufferType bf, long initialSize, String dirPath) throws IOException {
        this.type = bf;
        switch (this.type) {
            case INT: {
                this.valueSize = 4;
                break;
            }
            case DOUBLE: {
                this.valueSize = 8;
                break;
            }
            case LONG: {
                this.valueSize = 8;
                break;
            }
            case STRING: 
            case BYTE: {
                this.valueSize = -1;
            }
        }
        this.size = initialSize <= 0L ? 1000000L : initialSize;
        this.tempFile = new File(dirPath);
        if (this.tempFile.isDirectory() || !dirPath.contains(".")) {
            this.tempFile.mkdir();
            this.tempFile = new File(this.tempFile, String.valueOf(UUID.randomUUID().toString()) + ".buf");
        }
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
        if (!this.tempFile.createNewFile()) {
            throw new IOException("For some reason file " + this.tempFile + " couldn't be created");
        }
        this.tempFile.deleteOnExit();
        this.rafs = new RandomAccessFile(this.tempFile, "rw");
        this.rafs.setLength(this.size);
        this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.size);
    }

    @Override
    public void writeInt(int value) throws IOException {
        this.resize(this.valueSize);
        this.buffer.putInt(value);
        this.position += this.valueSize;
    }

    @Override
    public void writeLong(long value) throws IOException {
        this.resize(this.valueSize);
        this.buffer.putLong(value);
        this.position += this.valueSize;
    }

    @Override
    public void writeDouble(double value) throws IOException {
        this.resize(this.valueSize);
        this.buffer.putDouble(value);
        this.position += this.valueSize;
    }

    @Override
    public void writeString(String value) throws IOException {
        this.writeByte(value == null ? null : value.getBytes());
    }

    @Override
    public void setSortMode(boolean sortMode) {
        this.sortModePrevious = this.sortMode;
        this.sortMode = sortMode;
    }

    @Override
    public void setToReadMode() throws IOException {
        this.windowSize = Math.max(1000000L, Math.min(1000000L, this.size));
        this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.windowSize);
        this.index = 0L;
    }

    private void reposition(int bufferIndex) throws IOException {
        if (this.type == BufferType.BYTE || this.type == BufferType.STRING) {
            if (this.byteIndexes.length <= bufferIndex) {
                throw new RuntimeException("Out of bounds index: " + bufferIndex + " / " + (this.byteIndexes.length - 1));
            }
            long packedValue = this.byteIndexes[bufferIndex];
            int pos = ArrayUtils.unpackHigh(packedValue);
            int size = ArrayUtils.unpackLow(packedValue);
            if ((long)pos < this.index || this.windowSize < (long)size) {
                this.index = pos;
                this.windowSize = size > 0 ? Math.max(size, 100000) : 100000;
                this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_ONLY, this.index, this.windowSize);
                ++this.reposition1Count;
            } else if ((long)pos >= this.index + this.windowSize || this.windowSize < (long)size) {
                this.index = pos;
                this.windowSize = size > 0 ? Math.max(size, 100000) : 100000;
                this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_ONLY, this.index, this.windowSize);
                ++this.reposition2Count;
            }
            return;
        }
        int pos = bufferIndex * this.valueSize;
        if (this.sortMode != this.sortModePrevious && !this.sortMode || this.windowSize <= 0L) {
            this.recalculateWindowSize();
        }
        if ((long)pos < this.index) {
            long b = (long)pos - this.windowSize / 2L - ((long)pos - this.windowSize / 2L) % (long)this.valueSize;
            this.index = Math.max(0L, b);
            this.recalculateWindowSize();
            this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_ONLY, this.index, this.windowSize);
            ++this.reposition1Count;
        } else if ((long)pos >= this.index + this.windowSize) {
            this.index = pos;
            this.recalculateWindowSize();
            this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_ONLY, this.index, this.windowSize);
            ++this.reposition2Count;
        }
    }

    private void recalculateWindowSize() {
        if (this.sortMode == this.sortModePrevious && this.windowSize > 0L) {
            return;
        }
        if (this.sortMode) {
            this.windowSize = (int)Math.min(100000000L, this.size);
        } else {
            this.windowSize = Math.max(1000000L, Math.min(10000000L, this.size));
            this.reposition1Count = 0;
            this.reposition2Count = 0;
        }
        this.sortModePrevious = this.sortMode;
    }

    int getReposition1Count() {
        return this.reposition1Count;
    }

    int getReposition2Count() {
        return this.reposition2Count;
    }

    @Override
    public int readInt(int index) throws IOException {
        this.reposition(index);
        return this.buffer.getInt((int)((long)(index * this.valueSize) - this.index));
    }

    @Override
    public long readLong(int index) throws IOException {
        this.reposition(index);
        return this.buffer.getLong((int)((long)(index * this.valueSize) - this.index));
    }

    @Override
    public double readDouble(int index) throws IOException {
        this.reposition(index);
        return this.buffer.getDouble((int)((long)(index * this.valueSize) - this.index));
    }

    @Override
    public String readString(int index) throws IOException {
        byte[] b = this.readByte(index);
        if (b == null) {
            return null;
        }
        if (b.length == 0) {
            return "";
        }
        return new String(b);
    }

    private void resize(long sizeNeeded) throws IOException {
        if ((long)this.position + sizeNeeded <= this.size) {
            return;
        }
        this.size += Math.max(sizeNeeded, 1000000L);
        this.buffer.force();
        this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_WRITE, this.position, this.size);
    }

    private static void cleanUpFiles(AtomicInteger atomicInteger) {
        if (CLEANING_QUEUE.size() == 0) {
            return;
        }
        int time = atomicInteger.get();
        if (time >= 3) {
            System.gc();
            atomicInteger.set(0);
            time = 0;
        }
        int i = CLEANING_QUEUE.size() - 1;
        while (i >= 0) {
            try {
                File f = CLEANING_QUEUE.get(i);
                System.out.println("File to clean: " + f);
                if (!f.exists() || f.delete()) {
                    CLEANING_QUEUE.remove(i);
                } else if (time == atomicInteger.get()) {
                    atomicInteger.incrementAndGet();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            --i;
        }
    }

    @Override
    public void close() throws IOException {
        this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 1L);
        this.rafs.close();
        this.buffer = null;
        this.byteIndexes = new long[0];
        boolean delete = this.tempFile.delete();
        if (!delete) {
            CLEANING_QUEUE.add(new File(this.tempFile.getAbsolutePath()));
            this.tempFile = null;
        }
    }

    @Override
    public void writeByte(byte[] value) throws IOException {
        int oldItems = this.items++;
        this.byteIndexes = ArrayUtils.grow(this.byteIndexes, oldItems);
        if (value == null) {
            this.byteIndexes[oldItems] = ArrayUtils.pack(this.position, -1);
            return;
        }
        if (value.length == 0) {
            this.byteIndexes[oldItems] = ArrayUtils.pack(this.position, 0);
            return;
        }
        this.resize(value.length);
        this.buffer.put(value);
        this.byteIndexes[oldItems] = ArrayUtils.pack(this.position, value.length);
        this.position += value.length;
    }

    @Override
    public byte[] readByte(int index) throws IOException {
        this.reposition(index);
        long packedValue = this.byteIndexes[index];
        int size = ArrayUtils.unpackLow(packedValue);
        if (size == -1) {
            return null;
        }
        if (size == 0) {
            return EMPTY_BYTES;
        }
        byte[] dest = new byte[size];
        int pos = ArrayUtils.unpackHigh(packedValue);
        this.buffer.position((int)((long)pos - this.index));
        this.buffer.get(dest, 0, size);
        return dest;
    }

    @Override
    public void setToLowMemoryMode() throws IOException {
        this.windowSize = 0L;
        this.buffer = this.rafs.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, 1L);
        this.index = 0L;
    }

    public static enum BufferType {
        INT,
        LONG,
        DOUBLE,
        STRING,
        BYTE;

    }
}

