/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.fileutils;

import java.util.Arrays;

public class ArrayUtils {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public static long pack(int high, int low) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public static int unpackHigh(long packed) {
        return (int)(packed >> 32);
    }

    public static int unpackLow(long packed) {
        return (int)packed;
    }

    public static long[] grow(long[] arr, int minCapacity) {
        int oldCapacity = arr.length;
        if (oldCapacity > minCapacity) {
            return arr;
        }
        int newCapacity = oldCapacity + ArrayUtils.getGrowthValue(oldCapacity);
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = ArrayUtils.hugeCapacity(minCapacity);
        }
        return Arrays.copyOf(arr, newCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    private static int getGrowthValue(int oldCapacity) {
        if (oldCapacity < 200000) {
            return oldCapacity >> 1;
        }
        return oldCapacity + 100000;
    }
}

