/*
 * Decompiled with CFR 0.152.
 */
package dnl.utils.text.table;

import dnl.utils.text.table.SeparatorPolicy;
import dnl.utils.text.table.TextTable;
import dnl.utils.text.table.TextTreeTableRenderer;
import java.io.PrintStream;
import javax.swing.table.TableModel;

public class TextTreeTable
extends TextTable {
    protected int hierarchicalColumn;

    public TextTreeTable(String[] columnNames, String[][] data) {
        super(columnNames, data);
        this.addSeparatorPolicy(new TreeTableSeparatorPolicy());
    }

    public TextTreeTable(TableModel tableModel, boolean addNumbering) {
        super(tableModel, addNumbering);
        this.addSeparatorPolicy(new TreeTableSeparatorPolicy());
    }

    public TextTreeTable(TableModel tableModel) {
        super(tableModel);
        this.addSeparatorPolicy(new TreeTableSeparatorPolicy());
    }

    protected void setHierarchicalColumn(int hierarchicalColumn) {
        this.hierarchicalColumn = hierarchicalColumn;
    }

    @Override
    public void printTable(PrintStream ps, int indent) {
        TextTreeTableRenderer renderer = new TextTreeTableRenderer(this);
        renderer.render(ps, indent);
    }

    private class TreeTableSeparatorPolicy
    extends SeparatorPolicy {
        private TreeTableSeparatorPolicy() {
        }

        @Override
        boolean hasSeparatorAt(int row) {
            if (row == 0) {
                return false;
            }
            Object rowAgo = TextTreeTable.this.getValueAt(row - 1, TextTreeTable.this.hierarchicalColumn);
            Object hierarchicalColumnVal = TextTreeTable.this.getValueAt(row, TextTreeTable.this.hierarchicalColumn);
            return !hierarchicalColumnVal.equals(rowAgo);
        }
    }
}

