/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.WritableToken;
import org.antlr.v4.runtime.misc.Interval;

public class BufferedTokenStream
implements TokenStream {
    protected TokenSource tokenSource;
    protected List<Token> tokens = new ArrayList<Token>(100);
    protected int p = -1;
    protected boolean fetchedEOF;

    public BufferedTokenStream(TokenSource tokenSource) {
        if (tokenSource == null) {
            throw new NullPointerException("tokenSource cannot be null");
        }
        this.tokenSource = tokenSource;
    }

    public TokenSource getTokenSource() {
        return this.tokenSource;
    }

    public int index() {
        return this.p;
    }

    public int mark() {
        return 0;
    }

    public void release(int marker) {
    }

    @Deprecated
    public void reset() {
        this.seek(0);
    }

    public void seek(int index) {
        this.lazyInit();
        this.p = this.adjustSeekIndex(index);
    }

    public int size() {
        return this.tokens.size();
    }

    public void consume() {
        if (this.sync(this.p + 1)) {
            this.p = this.adjustSeekIndex(this.p + 1);
        }
    }

    protected boolean sync(int i) {
        assert (i >= 0);
        int n = i - this.tokens.size() + 1;
        if (n > 0) {
            int fetched = this.fetch(n);
            return fetched >= n;
        }
        return true;
    }

    protected int fetch(int n) {
        if (this.fetchedEOF) {
            return 0;
        }
        int i = 0;
        while (i < n) {
            Token t = this.tokenSource.nextToken();
            if (t instanceof WritableToken) {
                ((WritableToken)t).setTokenIndex(this.tokens.size());
            }
            this.tokens.add(t);
            if (t.getType() == -1) {
                this.fetchedEOF = true;
                return i + 1;
            }
            ++i;
        }
        return n;
    }

    public Token get(int i) {
        if (i < 0 || i >= this.tokens.size()) {
            throw new IndexOutOfBoundsException("token index " + i + " out of range 0.." + (this.tokens.size() - 1));
        }
        return this.tokens.get(i);
    }

    public List<Token> get(int start, int stop) {
        if (start < 0 || stop < 0) {
            return null;
        }
        this.lazyInit();
        ArrayList<Token> subset = new ArrayList<Token>();
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        int i = start;
        while (i <= stop) {
            Token t = this.tokens.get(i);
            if (t.getType() == -1) break;
            subset.add(t);
            ++i;
        }
        return subset;
    }

    public int LA(int i) {
        return this.LT(i).getType();
    }

    protected Token LB(int k) {
        if (this.p - k < 0) {
            return null;
        }
        return this.tokens.get(this.p - k);
    }

    public Token LT(int k) {
        this.lazyInit();
        if (k == 0) {
            return null;
        }
        if (k < 0) {
            return this.LB(-k);
        }
        int i = this.p + k - 1;
        this.sync(i);
        if (i >= this.tokens.size()) {
            return this.tokens.get(this.tokens.size() - 1);
        }
        return this.tokens.get(i);
    }

    protected int adjustSeekIndex(int i) {
        return i;
    }

    protected final void lazyInit() {
        if (this.p == -1) {
            this.setup();
        }
    }

    protected void setup() {
        this.sync(0);
        this.p = this.adjustSeekIndex(0);
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = tokenSource;
        this.tokens.clear();
        this.p = -1;
        this.fetchedEOF = false;
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public List<Token> getTokens(int start, int stop) {
        return this.getTokens(start, stop, null);
    }

    public List<Token> getTokens(int start, int stop, Set<Integer> types) {
        this.lazyInit();
        if (start < 0 || stop >= this.tokens.size() || stop < 0 || start >= this.tokens.size()) {
            throw new IndexOutOfBoundsException("start " + start + " or stop " + stop + " not in 0.." + (this.tokens.size() - 1));
        }
        if (start > stop) {
            return null;
        }
        ArrayList<Token> filteredTokens = new ArrayList<Token>();
        int i = start;
        while (i <= stop) {
            Token t = this.tokens.get(i);
            if (types == null || types.contains(t.getType())) {
                filteredTokens.add(t);
            }
            ++i;
        }
        if (filteredTokens.isEmpty()) {
            filteredTokens = null;
        }
        return filteredTokens;
    }

    public List<Token> getTokens(int start, int stop, int ttype) {
        HashSet<Integer> s = new HashSet<Integer>(ttype);
        s.add(ttype);
        return this.getTokens(start, stop, s);
    }

    protected int nextTokenOnChannel(int i, int channel) {
        this.sync(i);
        if (i >= this.size()) {
            return this.size() - 1;
        }
        Token token = this.tokens.get(i);
        while (token.getChannel() != channel) {
            if (token.getType() == -1) {
                return i;
            }
            this.sync(++i);
            token = this.tokens.get(i);
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    protected int previousTokenOnChannel(int i, int channel) {
        this.sync(i);
        if (i < this.size()) ** GOTO lbl9
        return this.size() - 1;
lbl-1000:
        // 1 sources

        {
            token = this.tokens.get(i);
            if (token.getType() == -1 || token.getChannel() == channel) {
                return i;
            }
            --i;
lbl9:
            // 2 sources

            ** while (i >= 0)
        }
lbl10:
        // 1 sources

        return i;
    }

    public List<Token> getHiddenTokensToRight(int tokenIndex, int channel) {
        this.lazyInit();
        if (tokenIndex < 0 || tokenIndex >= this.tokens.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(tokenIndex) + " not in 0.." + (this.tokens.size() - 1));
        }
        int nextOnChannel = this.nextTokenOnChannel(tokenIndex + 1, 0);
        int from = tokenIndex + 1;
        int to = nextOnChannel == -1 ? this.size() - 1 : nextOnChannel;
        return this.filterForChannel(from, to, channel);
    }

    public List<Token> getHiddenTokensToRight(int tokenIndex) {
        return this.getHiddenTokensToRight(tokenIndex, -1);
    }

    public List<Token> getHiddenTokensToLeft(int tokenIndex, int channel) {
        this.lazyInit();
        if (tokenIndex < 0 || tokenIndex >= this.tokens.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(tokenIndex) + " not in 0.." + (this.tokens.size() - 1));
        }
        if (tokenIndex == 0) {
            return null;
        }
        int prevOnChannel = this.previousTokenOnChannel(tokenIndex - 1, 0);
        if (prevOnChannel == tokenIndex - 1) {
            return null;
        }
        int from = prevOnChannel + 1;
        int to = tokenIndex - 1;
        return this.filterForChannel(from, to, channel);
    }

    public List<Token> getHiddenTokensToLeft(int tokenIndex) {
        return this.getHiddenTokensToLeft(tokenIndex, -1);
    }

    protected List<Token> filterForChannel(int from, int to, int channel) {
        ArrayList<Token> hidden = new ArrayList<Token>();
        int i = from;
        while (i <= to) {
            Token t = this.tokens.get(i);
            if (channel == -1) {
                if (t.getChannel() != 0) {
                    hidden.add(t);
                }
            } else if (t.getChannel() == channel) {
                hidden.add(t);
            }
            ++i;
        }
        if (hidden.size() == 0) {
            return null;
        }
        return hidden;
    }

    public String getSourceName() {
        return this.tokenSource.getSourceName();
    }

    public String getText() {
        return this.getText(Interval.of((int)0, (int)(this.size() - 1)));
    }

    public String getText(Interval interval) {
        int start = interval.a;
        int stop = interval.b;
        if (start < 0 || stop < 0) {
            return "";
        }
        this.fill();
        if (stop >= this.tokens.size()) {
            stop = this.tokens.size() - 1;
        }
        StringBuilder buf = new StringBuilder();
        int i = start;
        while (i <= stop) {
            Token t = this.tokens.get(i);
            if (t.getType() == -1) break;
            buf.append(t.getText());
            ++i;
        }
        return buf.toString();
    }

    public String getText(RuleContext ctx) {
        return this.getText(ctx.getSourceInterval());
    }

    public String getText(Token start, Token stop) {
        if (start != null && stop != null) {
            return this.getText(Interval.of((int)start.getTokenIndex(), (int)stop.getTokenIndex()));
        }
        return "";
    }

    public void fill() {
        int fetched;
        this.lazyInit();
        int blockSize = 1000;
        while ((fetched = this.fetch(1000)) >= 1000) {
        }
    }
}

