/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.rjent;

import java.lang.instrument.Instrumentation;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class ClassPathAppender {
    public static void premain(String args, Instrumentation instrumentation) {
        Path path = Paths.get(args, new String[0]);
        try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().endsWith(".jar")).forEach(e -> ClassPathAppender.appendPathToInstrumentation(instrumentation, e));
        }
        catch (Exception iex) {
            System.err.println("Failed to append path of " + args + " to classpath. Exception was:" + iex);
        }
    }

    private static void appendPathToInstrumentation(Instrumentation instrumentation, Path e) {
        try {
            instrumentation.appendToSystemClassLoaderSearch(new JarFile(e.toFile().getAbsolutePath()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

