/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.datacomparer.text;

import com.siggemannen.datacomparer.text.LinePositionTracker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;

public class EditLineDetector {
    private TextAndArea area;
    private List<LinePositionTracker> trackers = new ArrayList<LinePositionTracker>();

    public EditLineDetector(TextAndArea areas) {
        this.area = areas;
        this.area.area.setText(this.area.initialText);
    }

    public Position addNewLine(JTextArea a, int row) throws BadLocationException {
        LinePositionTracker lt = new LinePositionTracker(a.getDocument(), row);
        this.trackers.add(lt);
        return lt.positionStart;
    }

    public Position addNewLine(int row) throws BadLocationException {
        try {
            LinePositionTracker lt = new LinePositionTracker(this.area.area.getDocument(), row);
            this.trackers.add(lt);
            return lt.positionStart;
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception on line: " + row, ex);
        }
    }

    public TextAndArea getArea() {
        return this.area;
    }

    public String getText() {
        List rest = this.trackers.stream().filter(f -> !f.isLineChanged()).sorted(Comparator.comparing(c -> c.adjustedIndex)).collect(Collectors.toList());
        if (rest.size() == 0) {
            return this.area.area.getText();
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (LinePositionTracker tracker : this.trackers) {
            int indexBeforeTracker = tracker.adjustedIndex - 1;
            try {
                String text = this.area.area.getText(index, indexBeforeTracker - index);
                sb.append(text);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            index = tracker.adjustedIndexEnd;
        }
        try {
            sb.append(this.area.area.getText(index, this.area.area.getDocument().getLength() - index));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void reset() {
        this.trackers.forEach(t -> t.close());
        this.trackers.clear();
    }

    public static String getElementName(Element e) {
        return e.toString();
    }

    public static class TextAndArea {
        String initialText;
        JTextArea area;

        public TextAndArea(String text, JTextArea area) {
            this.initialText = text;
            this.area = area;
        }

        public JTextArea getArea() {
            return this.area;
        }

        public String getInitialText() {
            return this.initialText;
        }
    }

    public static class DiffIndex {
        int diffIndex;
        int distance;

        public DiffIndex(int diffIndex, int distance) {
            this.diffIndex = diffIndex;
            this.distance = distance;
        }

        public int getDiffIndex() {
            return this.diffIndex;
        }

        public int getDistance() {
            return this.distance;
        }
    }
}

