/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.datacomparer;

import com.github.difflib.DiffUtils;
import com.github.difflib.algorithm.DiffAlgorithmListener;
import com.github.difflib.patch.AbstractDelta;
import com.github.difflib.patch.DeltaType;
import com.github.difflib.patch.Patch;
import com.siggemannen.datacomparer.DiffLineTracker;
import com.siggemannen.datacomparer.DiffTextMouseListener;
import com.siggemannen.datacomparer.Synchronizer;
import com.siggemannen.datacomparer.text.EditLineDetector;
import com.siggemannen.datacomparer.view.diff.DiffView;
import com.siggemannen.datacomparer.view.diff.TextDiffView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.MalformedURLException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jdesktop.swingx.JXStatusBar;

public class DiffViewer {
    public static final Color DELETED_COLOR = new Color(239, 119, 116);
    public static final Color DELETED_NEW_LINE_COLOR = new Color(192, 192, 192);
    public static final Color CHANGED_COLOR = new Color(239, 204, 5);
    public static final Color DELETED_SELECTED_NEW_LINE_COLOR = new Color(240, 192, 192);
    private AbstractAction diffAction;
    private AbstractAction nextDiffAction;
    private AbstractAction prevDiffAction;
    private RSyntaxTextArea lastTextArea;
    private final TextDiffView textDiffView = new TextDiffView();
    private AbstractAction copyRightDiffAction;
    private AbstractAction copyLeftDiffAction;

    public DiffViewer(Container container, String ... text) {
        container.add(this.textDiffView);
        this.textDiffView.getGenerateTextOnly().setVisible(false);
        final DiffView dv = new DiffView();
        this.textDiffView.add((Component)dv, "Center");
        this.lastTextArea = dv.getTextArea();
        dv.getTextArea().setSyntaxEditingStyle("text/sql");
        dv.getTextArea2().setSyntaxEditingStyle("text/sql");
        final JLabel statusLabel = new JLabel("Left text: ");
        JXStatusBar.Constraint c1 = new JXStatusBar.Constraint();
        c1.setFixedWidth(100);
        this.textDiffView.getStatusBar().add((Component)statusLabel, (Object)c1);
        final JLabel statusLabel2 = new JLabel("Right text: ");
        this.textDiffView.getStatusBar().add((Component)statusLabel2, (Object)c1);
        dv.getTextArea().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DiffViewer.this.lastTextArea = dv.getTextArea();
            }
        });
        dv.getTextArea().getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                statusLabel.setText("Left text: " + (dv.getTextArea().getCaretPosition() + 1));
            }
        });
        dv.getTextArea2().getCaret().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                statusLabel2.setText("Right text: " + (dv.getTextArea2().getCaretPosition() + 1));
            }
        });
        dv.getTextArea2().addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DiffViewer.this.lastTextArea = dv.getTextArea2();
            }
        });
        Synchronizer sync = new Synchronizer((JScrollPane)dv.getPane(), (JScrollPane)dv.getPane2(), true, true);
        dv.getPane().getVerticalScrollBar().addAdjustmentListener(sync);
        dv.getPane2().getVerticalScrollBar().addAdjustmentListener(sync);
        dv.getPane().getHorizontalScrollBar().addAdjustmentListener(sync);
        dv.getPane2().getHorizontalScrollBar().addAdjustmentListener(sync);
        String f1 = text.length < 2 ? "" : text[0];
        String f2 = text.length < 2 ? "" : text[1];
        final EditLineDetector ed = new EditLineDetector(new EditLineDetector.TextAndArea(f1, (JTextArea)dv.getTextArea()));
        final EditLineDetector ed2 = new EditLineDetector(new EditLineDetector.TextAndArea(f2, (JTextArea)dv.getTextArea2()));
        final DiffLineTracker diffTracker = new DiffLineTracker(ed, ed2);
        new DiffTextMouseListener(diffTracker);
        this.textDiffView.getRevertButton().addActionListener(al -> {
            Element element2;
            JTextArea ra = ed.getArea().getArea();
            int lineOld = ra.getDocument().getDefaultRootElement().getElementIndex(ra.getCaretPosition());
            JTextArea ra2 = ed2.getArea().getArea();
            int line2Old = ra2.getDocument().getDefaultRootElement().getElementIndex(ra2.getCaretPosition());
            DiffViewer.resetTextAreas(ed, ed2);
            ra.setText(f1);
            ra2.setText(f2);
            ed.reset();
            ed2.reset();
            Element element = ra.getDocument().getDefaultRootElement().getElement(lineOld);
            if (element != null) {
                ra.setCaretPosition(element.getStartOffset());
            }
            if ((element2 = ra2.getDocument().getDefaultRootElement().getElement(line2Old)) != null) {
                ra2.setCaretPosition(element2.getStartOffset());
            }
        });
        this.textDiffView.getGenerateTextOnly().addActionListener(al -> DiffViewer.resetTextAreas(ed, ed2));
        this.nextDiffAction = new AbstractAction("Next diff"){

            @Override
            public void actionPerformed(ActionEvent e) {
                diffTracker.nextDiff();
            }
        };
        this.prevDiffAction = new AbstractAction("Prev diff"){

            @Override
            public void actionPerformed(ActionEvent e) {
                diffTracker.prevDiff();
            }
        };
        this.textDiffView.getNextDiff().setAction(this.nextDiffAction);
        this.textDiffView.getPrevDiff().setAction(this.prevDiffAction);
        this.copyRightDiffAction = new AbstractAction("Copy diff to right"){

            @Override
            public void actionPerformed(ActionEvent e) {
                diffTracker.applyDiff(0);
            }
        };
        this.copyLeftDiffAction = new AbstractAction("Copy diff to left"){

            @Override
            public void actionPerformed(ActionEvent e) {
                diffTracker.applyDiff(1);
            }
        };
        try {
            this.copyRightDiffAction.putValue("SmallIcon", new ImageIcon(Paths.get("src/main/resources/right-arrow.png", new String[0]).toUri().toURL()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            this.copyLeftDiffAction.putValue("SmallIcon", new ImageIcon(Paths.get("src/main/resources/left-arrow.png", new String[0]).toUri().toURL()));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.textDiffView.getCopyToLeftButton().setAction(this.copyLeftDiffAction);
        this.textDiffView.getCopyToRightButton().setAction(this.copyRightDiffAction);
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(40, 512), this.textDiffView.getNextDiff(), this.nextDiffAction, "nextDiff");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(38, 512), this.textDiffView.getPrevDiff(), this.prevDiffAction, "prevDiff");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(40, 512), (JComponent)dv.getTextArea(), this.nextDiffAction, "nextDiff");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(38, 512), (JComponent)dv.getTextArea(), this.prevDiffAction, "prevDiff");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(40, 512), (JComponent)dv.getTextArea2(), this.nextDiffAction, "nextDiff");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(38, 512), (JComponent)dv.getTextArea2(), this.prevDiffAction, "prevDiff");
        this.nextDiffAction.setEnabled(false);
        this.prevDiffAction.setEnabled(false);
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(39, 512), this.textDiffView.getCopyToRightButton(), this.copyRightDiffAction, "copyRight");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(37, 512), this.textDiffView.getCopyToLeftButton(), this.copyLeftDiffAction, "copyLeft");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(39, 512), (JComponent)dv.getTextArea(), this.copyRightDiffAction, "copyRight");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(37, 512), (JComponent)dv.getTextArea(), this.copyLeftDiffAction, "copyLeft");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(39, 512), (JComponent)dv.getTextArea2(), this.copyRightDiffAction, "copyRight");
        DiffViewer.bindStroke(KeyStroke.getKeyStroke(37, 512), (JComponent)dv.getTextArea2(), this.copyLeftDiffAction, "copyLeft");
        this.copyLeftDiffAction.setEnabled(false);
        this.copyRightDiffAction.setEnabled(false);
        this.diffAction = new AbstractAction("Diff"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffViewer.resetTextAreas(ed, ed2);
                DiffViewer.this.nextDiffAction.setEnabled(true);
                DiffViewer.this.prevDiffAction.setEnabled(true);
                DiffViewer.this.copyRightDiffAction.setEnabled(true);
                DiffViewer.this.copyLeftDiffAction.setEnabled(true);
                Patch patch = DiffUtils.diff(Arrays.asList(ed.getText().split("\r?\n")), Arrays.asList(ed2.getText().split("\r?\n")), (DiffAlgorithmListener)new DiffAlgorithmListener(){

                    public void diffStep(int value, int max) {
                    }

                    public void diffStart() {
                    }

                    public void diffEnd() {
                    }
                });
                try {
                    dv.getTextArea().beginAtomicEdit();
                    dv.getTextArea2().beginAtomicEdit();
                    DiffViewer.highlightPatches((Patch<String>)patch, ed, ed2, diffTracker);
                }
                finally {
                    dv.getTextArea().endAtomicEdit();
                    dv.getTextArea2().endAtomicEdit();
                }
            }
        };
        this.textDiffView.getDiffButton().setAction(this.diffAction);
    }

    public AbstractAction getDiffAction() {
        return this.diffAction;
    }

    public AbstractAction getNextDiffAction() {
        return this.nextDiffAction;
    }

    public AbstractAction getPrevDiffAction() {
        return this.prevDiffAction;
    }

    public RSyntaxTextArea getLastTextArea() {
        return this.lastTextArea;
    }

    public JXStatusBar getStatusBar() {
        return this.textDiffView.getStatusBar();
    }

    public static void bindStroke(KeyStroke k, JComponent j, Action a, String name) {
        j.getInputMap(2).put(k, name);
        j.getInputMap(0).put(k, name);
        j.getInputMap(1).put(k, name);
        j.getActionMap().put(name, a);
    }

    public static void resetTextAreas(EditLineDetector ed, EditLineDetector ed2) {
        JTextArea ra = ed.getArea().getArea();
        JTextArea ra2 = ed2.getArea().getArea();
        ra.getHighlighter().removeAllHighlights();
        ra2.getHighlighter().removeAllHighlights();
        ((DefaultHighlighter)ra.getHighlighter()).setDrawsLayeredHighlights(false);
        ((DefaultHighlighter)ra2.getHighlighter()).setDrawsLayeredHighlights(false);
        ra.setText(ed.getText());
        ra2.setText(ed2.getText());
        ed.reset();
        ed2.reset();
        ra.setCaretPosition(0);
        ra2.setCaretPosition(0);
    }

    public static void highlightPatches(Patch<String> patch, EditLineDetector ed, EditLineDetector ed2, DiffLineTracker diffTracker) {
        ed.reset();
        ed2.reset();
        diffTracker.reset();
        JTextArea ra = ed.getArea().getArea();
        JTextArea ra2 = ed2.getArea().getArea();
        List deltas = patch.getDeltas();
        int offset1 = 0;
        int offset2 = 0;
        int delta = 0;
        for (AbstractDelta d : deltas) {
            switch (d.getType()) {
                case CHANGE: {
                    int line;
                    int i;
                    int count1 = 0;
                    int count2 = 0;
                    for (i = d.getSource().getPosition(); i <= d.getSource().last(); ++i) {
                        line = i + offset1;
                        DiffViewer.addHighlight(line, ra, CHANGED_COLOR);
                        diffTracker.addDiffLine(delta, 0, line, CHANGED_COLOR, d.getType());
                        ++count1;
                    }
                    for (i = d.getTarget().getPosition(); i <= d.getTarget().last(); ++i) {
                        line = i + offset2;
                        DiffViewer.addHighlight(line, ra2, CHANGED_COLOR);
                        diffTracker.addDiffLine(delta, 1, line, CHANGED_COLOR, d.getType());
                        ++count2;
                    }
                    if (count1 == count2) break;
                    for (i = 0; i < Math.abs(count1 - count2); ++i) {
                        if (count1 > count2) {
                            try {
                                int row = i + offset2 + d.getTarget().last() + 1;
                                ed2.addNewLine(row);
                                DiffViewer.addHighlight(row, ra2, DELETED_NEW_LINE_COLOR);
                                diffTracker.addDiffLine(delta, 1, row, DELETED_NEW_LINE_COLOR, DeltaType.DELETE);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            continue;
                        }
                        try {
                            int row = i + offset1 + d.getSource().last() + 1;
                            ed.addNewLine(row);
                            DiffViewer.addHighlight(row, ra, DELETED_NEW_LINE_COLOR);
                            diffTracker.addDiffLine(delta, 0, row, DELETED_NEW_LINE_COLOR, DeltaType.DELETE);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    if (count1 > count2) {
                        offset2 += Math.abs(count1 - count2);
                        break;
                    }
                    offset1 += Math.abs(count1 - count2);
                    break;
                }
                case DELETE: {
                    int offsetY = 0;
                    for (int i = d.getSource().getPosition(); i <= d.getSource().last(); ++i) {
                        int row = i + offset1;
                        DiffViewer.addHighlight(row, ra, CHANGED_COLOR);
                        diffTracker.addDiffLine(delta, 0, row, CHANGED_COLOR, DeltaType.CHANGE);
                        try {
                            ed2.addNewLine(row);
                            ++offsetY;
                            DiffViewer.addHighlight(row, ra2, DELETED_NEW_LINE_COLOR);
                            diffTracker.addDiffLine(delta, 1, row, DELETED_NEW_LINE_COLOR, DELETED_SELECTED_NEW_LINE_COLOR, DeltaType.DELETE);
                            continue;
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                    offset2 += offsetY;
                    break;
                }
                case EQUAL: {
                    break;
                }
                case INSERT: {
                    int offsetX = 0;
                    for (int i = d.getTarget().getPosition(); i <= d.getTarget().last(); ++i) {
                        ++offsetX;
                        int row = i + offset2;
                        DiffViewer.addHighlight(row, ra2, CHANGED_COLOR);
                        diffTracker.addDiffLine(delta, 1, row, CHANGED_COLOR, DeltaType.CHANGE);
                        try {
                            ed.addNewLine(row);
                            DiffViewer.addHighlight(row, ra, DELETED_NEW_LINE_COLOR);
                            diffTracker.addDiffLine(delta, 0, row, DELETED_NEW_LINE_COLOR, DELETED_SELECTED_NEW_LINE_COLOR, DeltaType.DELETE);
                            continue;
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                        }
                    }
                    offset1 += offsetX;
                    break;
                }
            }
            ++delta;
        }
    }

    public static void addHighlight(int line, JTextArea area, Color color) {
        Element el = area.getDocument().getDefaultRootElement().getElement(line);
        if (el != null) {
            try {
                area.getHighlighter().addHighlight(el.getStartOffset(), el.getEndOffset(), new DefaultHighlighter.DefaultHighlightPainter(color){});
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }
}

