/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.datacomparer;

import com.github.difflib.patch.DeltaType;
import com.siggemannen.datacomparer.DiffViewer;
import com.siggemannen.datacomparer.text.EditLineDetector;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;

public class DiffLineTracker {
    public static final Color DEFAULT_HIGHLIGHT_COLOR = new Color(239, 119, 116);
    private List<EditLineDetector> lineDetectors = new ArrayList<EditLineDetector>();
    List<List<DiffInfo>> diffs = new ArrayList<List<DiffInfo>>();
    private int currentDiff = -1;

    public DiffLineTracker(EditLineDetector ... detectors) {
        Arrays.asList(detectors).forEach(this.lineDetectors::add);
    }

    public void addDiffLine(int diffNumber, int diffSide, int line, Color color, DeltaType typeOfDiff) {
        this.addDiffLine(diffNumber, diffSide, line, color, DEFAULT_HIGHLIGHT_COLOR, typeOfDiff);
    }

    public List<? extends EditLineDetector> getLineDetectors() {
        return this.lineDetectors;
    }

    public void addDiffLine(int diffNumber, int diffSide, int line, Color color, Color colorHighlight, DeltaType typeOfDiff) {
        DiffInfo prev;
        EditLineDetector ed = this.lineDetectors.get(diffSide);
        JTextArea jt = ed.getArea().getArea();
        DiffInfo dinfo = new DiffInfo(jt, line, color, colorHighlight, typeOfDiff);
        if (this.diffs.size() <= diffNumber) {
            ArrayList<Object> e = new ArrayList<Object>();
            this.diffs.add(e);
            for (int i = 0; i < this.lineDetectors.size(); ++i) {
                e.add(null);
            }
        }
        if ((prev = this.diffs.get(diffNumber).get(diffSide)) == null || !prev.merge(dinfo)) {
            this.diffs.get(diffNumber).set(diffSide, dinfo);
        } else {
            this.diffs.get(diffNumber).set(diffSide, prev);
        }
    }

    public void moveToDiffAtLine(int line, int prioLineDetectorIndex) {
        Element e = this.lineDetectors.get(prioLineDetectorIndex).getArea().getArea().getDocument().getDefaultRootElement().getElement(line);
        int x = -1;
        for (int i = 0; i < this.diffs.size(); ++i) {
            DiffInfo diff = this.diffs.get(i).get(prioLineDetectorIndex);
            if (!DiffLineTracker.intersects(e.getStartOffset(), e.getEndOffset(), diff.startPos.getOffset(), diff.endPos.getOffset())) continue;
            x = i;
            break;
        }
        if (x >= 0) {
            this.moveTo(x);
        }
    }

    public static boolean intersects(int start, int end, int start2, int end2) {
        return start >= start2 && start < end2 || end > start2 && end <= end2;
    }

    public void nextDiff() {
        this.moveTo(this.currentDiff + 1);
    }

    public void prevDiff() {
        this.moveTo(this.currentDiff - 1);
    }

    public void removeHighlights() {
        ArrayList<DiffInfo> prevDiffs = this.currentDiff >= 0 ? this.diffs.get(this.currentDiff) : new ArrayList<DiffInfo>();
        this.highlightDiff(prevDiffs, false);
    }

    public void removeHighlightsUnlessOnLineAlready(int editorIndex, int line) {
        if (this.currentDiff < 0) {
            return;
        }
        Element e = this.lineDetectors.get(editorIndex).getArea().getArea().getDocument().getDefaultRootElement().getElement(line);
        for (int i = 0; i < this.diffs.size(); ++i) {
            DiffInfo diff = this.diffs.get(i).get(editorIndex);
            if (!DiffLineTracker.intersects(e.getStartOffset(), e.getEndOffset(), diff.startPos.getOffset(), diff.endPos.getOffset())) continue;
            return;
        }
        ArrayList<DiffInfo> prevDiffs = this.currentDiff >= 0 ? this.diffs.get(this.currentDiff) : new ArrayList<DiffInfo>();
        this.highlightDiff(prevDiffs, false);
    }

    public void applyDiff(int editorFrom) {
        JTextArea area = this.lineDetectors.get(editorFrom).getArea().getArea();
        int line = area.getDocument().getDefaultRootElement().getElementIndex(area.getCaretPosition());
        this.applyDiff(editorFrom, this.getOtherEditors(editorFrom), line, false, false);
    }

    private List<Integer> getOtherEditors(int editor) {
        ArrayList<Integer> editors = new ArrayList<Integer>();
        for (int i = 0; i < this.lineDetectors.size(); ++i) {
            if (i == editor) continue;
            editors.add(i);
        }
        return editors;
    }

    private List<Integer> getDiffsOnLine(int editor, int line) {
        Element e = this.lineDetectors.get(editor).getArea().getArea().getDocument().getDefaultRootElement().getElement(line);
        int x = -1;
        for (int i = 0; i < this.diffs.size(); ++i) {
            DiffInfo diff = this.diffs.get(i).get(editor);
            if (!DiffLineTracker.intersects(e.getStartOffset(), e.getEndOffset(), diff.startPos.getOffset(), diff.endPos.getOffset())) continue;
            x = i;
            break;
        }
        ArrayList<Integer> diffLine = new ArrayList<Integer>();
        if (x >= 0) {
            diffLine.add(x);
        }
        return diffLine;
    }

    public void applyDiff(int editorFrom, List<Integer> editorTo, int diffLine, boolean applyAll, boolean advance) {
        System.out.println("Apply diff:" + editorFrom + " -" + editorTo + ", diff line:" + diffLine + ", applyall: " + applyAll + ", advance:" + advance);
        if (editorTo == null || editorTo.size() == 0) {
            editorTo = this.getOtherEditors(editorFrom);
        }
        if (applyAll) {
            advance = false;
            diffLine = -1;
        }
        List<Integer> diffs = !applyAll ? this.getDiffsOnLine(editorFrom, diffLine) : DiffLineTracker.range(0, this.diffs.size());
        for (int i = 0; i < diffs.size(); ++i) {
            DiffInfo dinfo = this.diffs.get(diffs.get(i)).get(editorFrom);
            String text = null;
            try {
                text = dinfo.textArea.getText(dinfo.startPos.getOffset(), dinfo.endPos.getOffset() - dinfo.startPos.getOffset() - 1);
                System.out.println("Diff text:\"" + text + "\"");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                return;
            }
            boolean deleteType = dinfo.diffType == DeltaType.DELETE;
            for (int editorOther : editorTo) {
                DiffInfo odiff = this.diffs.get(diffs.get(i)).get(editorOther);
                System.out.println("Replacing: " + odiff.startPos.getOffset() + " - " + odiff.endPos.getOffset());
                try {
                    System.out.println("Replacing: \"" + dinfo.textArea.getText(odiff.startPos.getOffset(), odiff.endPos.getOffset() - odiff.startPos.getOffset()) + "\"");
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                odiff.textArea.replaceRange(deleteType ? "" : text, odiff.startPos.getOffset(), odiff.endPos.getOffset() - (deleteType ? 0 : 1));
            }
            if (deleteType) {
                dinfo.textArea.replaceRange("", dinfo.startPos.getOffset(), dinfo.endPos.getOffset());
            }
            this.highlightDiff(Arrays.asList(dinfo), false);
        }
        if (advance) {
            this.nextDiff();
        }
    }

    public static List<Integer> range(int from, int to) {
        ArrayList<Integer> range = new ArrayList<Integer>();
        for (int i = from; i < to; ++i) {
            range.add(i);
        }
        return range;
    }

    public void moveTo(int diff) {
        if (diff >= this.getDiffCount() || diff < 0) {
            return;
        }
        ArrayList<DiffInfo> prevDiffs = this.currentDiff >= 0 ? this.diffs.get(this.currentDiff) : new ArrayList<DiffInfo>();
        this.highlightDiff(prevDiffs, false);
        List<DiffInfo> diffo = this.diffs.get(diff);
        int minStart = this.highlightDiff(diffo, true);
        JTextArea mainTextArea = diffo.get(0).textArea;
        mainTextArea.setCaretPosition(minStart);
        try {
            int line = mainTextArea.getDocument().getDefaultRootElement().getElementIndex(mainTextArea.getCaretPosition());
            line = this.currentDiff < diff ? (line += 5) : (line -= 5);
            if (line > 0 && line < mainTextArea.getDocument().getDefaultRootElement().getElementCount()) {
                Rectangle r = mainTextArea.modelToView(mainTextArea.getDocument().getDefaultRootElement().getElement(line).getStartOffset());
                mainTextArea.scrollRectToVisible(r);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        this.currentDiff = diff;
    }

    private int highlightDiff(List<DiffInfo> diffo, boolean useCurrentHighlight) {
        int minStart = Integer.MAX_VALUE;
        for (int differ = 0; differ < diffo.size(); ++differ) {
            DiffInfo dif = diffo.get(differ);
            if (differ == 0) {
                minStart = dif.start;
            }
            for (int i = dif.lineStart; i <= dif.lineEnd; ++i) {
                DiffViewer.addHighlight(i, dif.textArea, useCurrentHighlight ? dif.highlight : dif.previousHighlight);
            }
        }
        return minStart;
    }

    public void reset() {
        this.diffs.clear();
        this.currentDiff = -1;
    }

    public int getDiffCount() {
        return this.diffs.size();
    }

    public static class DiffInfo {
        int start;
        int end;
        int lineStart;
        int lineEnd;
        private JTextArea textArea;
        private Color previousHighlight;
        private Color highlight;
        Position startPos;
        Position endPos;
        private DeltaType diffType;

        public DiffInfo(JTextArea ja, int line, Color previousHighlight, Color highlight, DeltaType diffType) {
            this(ja, line, line, previousHighlight, highlight, diffType);
        }

        public DiffInfo(JTextArea ja, int line, int lineEnd, Color previousHighlight, Color highlight, DeltaType diffType) {
            this.textArea = ja;
            this.diffType = diffType;
            Element el = ja.getDocument().getDefaultRootElement().getElement(line);
            this.start = el.getStartOffset();
            this.end = el.getEndOffset();
            try {
                this.startPos = ja.getDocument().createPosition(this.start);
                this.endPos = ja.getDocument().createPosition(this.end);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.lineStart = line;
            this.lineEnd = lineEnd;
            this.previousHighlight = previousHighlight;
            this.highlight = highlight;
        }

        public boolean merge(DiffInfo d) {
            if (d.lineStart == this.lineEnd + 1 && d.previousHighlight.equals(this.previousHighlight) && d.highlight.equals(this.highlight)) {
                this.end = d.end;
                this.lineEnd = d.lineEnd;
                this.endPos = d.endPos;
                return true;
            }
            return false;
        }
    }
}

