/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.gribbs;

import com.siggemannen.core.CancellationToken;
import com.siggemannen.core.Tuple;
import com.siggemannen.core.storage.IResult;
import com.siggemannen.core.storage.IStorer;
import com.siggemannen.gribbs.ComposableStream;
import com.siggemannen.gribbs.IGeoXDFile;
import com.siggemannen.gribbs.IVariableData;
import com.siggemannen.gribbs.ImportOptions;
import com.siggemannen.gribbs.ParseCancelException;
import com.siggemannen.gribbs.ParseException;
import com.siggemannen.gribbs.ParseStatistics;
import com.siggemannen.gribbs.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.units.DateUnit;

public class TimeGridFile
implements IGeoXDFile {
    private final NetcdfFile ncfile;
    private final String fileName;
    private Variable lat;
    private Variable lon;
    private Variable v;
    private Optional<Variable> time;
    private final List<Variable> loopVars = new ArrayList<Variable>();
    private final List<Integer> loopVarsSize = new ArrayList<Integer>();
    private final List<Scaler> scalers = new ArrayList<Scaler>();
    private Scaler geoScaler;
    private final Map<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> dimensionMap = new HashMap<Integer, Integer>();
    private int latIndex = -1;
    private int lonIndex = -1;
    private int timeIndex = -1;
    private int[] size;
    private int objectShapeSize;
    private final List<Tuple<Integer, Integer>> copies = new ArrayList<Tuple<Integer, Integer>>();
    private final ImportOptions options;
    private final Logger LOGGER = LoggerFactory.getLogger(TimeGridFile.class);

    public TimeGridFile(String filename) throws IOException {
        this(filename, new ImportOptions(true));
    }

    public TimeGridFile(String filename, ImportOptions options) throws IOException {
        Grib1ParamTables.setStrict((boolean)false);
        try {
            this.ncfile = NetcdfFile.open((String)filename);
            this.fileName = filename;
            this.options = options;
        }
        catch (Exception ex) {
            this.LOGGER.error("Error while opening file", (Throwable)ex);
            this.closeExisting();
            throw ex;
        }
    }

    @Override
    public ParseStatistics parse(IVariableData latitudeVariable, IVariableData longitudeVariable, IVariableData geo, Optional<IVariableData> timeVariable, List<IVariableData> dimensionVariables, List<IVariableData> copyFromTo) {
        if (dimensionVariables.size() > 0) {
            throw new ParseException("For now, multiple dimension variables aren't supported");
        }
        this.LOGGER.debug("Started parsing " + this.fileName);
        this.v = Utils.findGeospatVariable(this.ncfile, geo, timeVariable.isPresent());
        if (this.v == null) {
            throw new RuntimeException("Geo variable not found!");
        }
        this.LOGGER.info("Found geo-variable: " + this.v);
        this.geoScaler = new Scaler(this.v);
        this.lon = TimeGridFile.checkVariable(Utils.findByNameOrArray(this.ncfile, longitudeVariable, "longitude", "lon"), "longitude");
        this.lat = TimeGridFile.checkVariable(Utils.findByNameOrArray(this.ncfile, latitudeVariable, "latitude", "lat"), "latitude");
        this.objectShapeSize = 3;
        if (timeVariable.isPresent()) {
            this.time = Utils.findByNameOrArray(this.ncfile, timeVariable.get(), "time");
            TimeGridFile.checkVariable(this.time, "time");
            ++this.objectShapeSize;
            this.LOGGER.info("Found time-variable: " + this.time);
        } else {
            this.time = Optional.empty();
        }
        int dimensions = this.v.getDimensions().size();
        this.size = (int[])this.v.getShape().clone();
        int[] dimArr = (int[])this.v.getShape().clone();
        this.loopVars.clear();
        this.indexMap.clear();
        this.loopVarsSize.clear();
        this.dimensionMap.clear();
        this.scalers.clear();
        this.copies.clear();
        int i = 0;
        while (i < dimensions) {
            Dimension dimension = this.v.getDimension(i);
            Variable findVariable = this.ncfile.findVariable(dimension.getShortName());
            if (this.lat == findVariable) {
                this.latIndex = i;
            } else if (this.lon == findVariable) {
                this.lonIndex = i;
            } else if (this.time.isPresent() && this.time.get() == findVariable) {
                if (timeVariable.map(IVariableData::isImported).orElse(false).booleanValue()) {
                    this.timeIndex = i;
                }
                this.loopVars.add(findVariable);
                this.indexMap.put(this.loopVars.size() - 1, i);
                this.size[i] = 1;
                Integer preferredDim = timeVariable.flatMap(IVariableData::getPreferredDimension).orElse(-1);
                if (preferredDim >= 0 && dimension.getLength() > 1) {
                    this.loopVarsSize.add(1);
                    if (dimension.getLength() - 1 >= preferredDim) {
                        this.dimensionMap.put(i, preferredDim);
                    } else {
                        this.dimensionMap.put(i, 0);
                    }
                    dimArr[i] = 1;
                } else {
                    this.loopVarsSize.add(dimension.getLength());
                }
                this.scalers.add(new Scaler(findVariable));
            } else if (findVariable != this.v && dimension.getLength() > 1) {
                this.loopVars.add(findVariable);
                this.indexMap.put(this.loopVars.size() - 1, i);
                this.size[i] = 1;
                this.loopVarsSize.add(dimension.getLength());
                this.scalers.add(new Scaler(findVariable));
            }
            ++i;
        }
        if (this.latIndex == -1 || this.lonIndex == -1 || this.time.isPresent() && this.timeIndex == -1 && timeVariable.map(IVariableData::isImported).orElse(false).booleanValue()) {
            throw new ParseException("Time (" + this.timeIndex + ") / lat (" + this.latIndex + ") / lon (" + this.lonIndex + ") dimensions couldn't be mapped together: ");
        }
        for (IVariableData data : copyFromTo) {
            if (data.equals(latitudeVariable)) {
                this.copies.add((Tuple<Integer, Integer>)new Tuple((Object)0, (Object)this.objectShapeSize));
            } else if (data.equals(longitudeVariable)) {
                this.copies.add((Tuple<Integer, Integer>)new Tuple((Object)1, (Object)this.objectShapeSize));
            } else if (data.equals(geo)) {
                this.copies.add((Tuple<Integer, Integer>)new Tuple((Object)2, (Object)this.objectShapeSize));
            } else if (this.timeIndex != -1 && data.equals(timeVariable.get())) {
                this.copies.add((Tuple<Integer, Integer>)new Tuple((Object)3, (Object)this.objectShapeSize));
            }
            ++this.objectShapeSize;
        }
        this.LOGGER.info("Loop vars {}", this.loopVars);
        this.LOGGER.info("Index map{}", this.indexMap);
        this.LOGGER.info(String.format("lat: %s, lon: %s, time: %s", this.latIndex, this.lonIndex, this.timeIndex));
        long shapeSize = 1L;
        int[] nArray = dimArr;
        int n = dimArr.length;
        int n2 = 0;
        while (n2 < n) {
            int sizeValue = nArray[n2];
            shapeSize *= (long)sizeValue;
            ++n2;
        }
        return new ParseStatistics(dimArr, shapeSize, this.lat.getSize(), this.lon.getSize(), this.timeIndex == -1 ? 0 : this.size[this.timeIndex]);
    }

    private void closeExisting() {
        try {
            try {
                if (this.ncfile != null) {
                    this.ncfile.close();
                }
            }
            catch (Exception exception) {
                File f = new File(String.valueOf(this.fileName) + ".gbx9");
                if (f.exists()) {
                    f.delete();
                }
                if ((f = new File(String.valueOf(this.fileName) + ".ncx2")).exists()) {
                    f.delete();
                }
            }
        }
        finally {
            File f = new File(String.valueOf(this.fileName) + ".gbx9");
            if (f.exists()) {
                f.delete();
            }
            if ((f = new File(String.valueOf(this.fileName) + ".ncx2")).exists()) {
                f.delete();
            }
        }
    }

    private static Variable checkVariable(Optional<Variable> var, String name) {
        if (!var.isPresent()) {
            throw new ParseException("Couldn't map \"" + name + "\" variable");
        }
        return var.get();
    }

    @Override
    public ParseStatistics parse(IVariableData lat, IVariableData lon, IVariableData geo, Optional<IVariableData> time, List<IVariableData> dimensions) {
        return this.parse(lat, lon, geo, time, dimensions, Collections.emptyList());
    }

    @Override
    public ParseStatistics parse(IVariableData lat, IVariableData lon, IVariableData geo, Optional<IVariableData> time) {
        return this.parse(lat, lon, geo, time, Collections.emptyList());
    }

    @Override
    public ParseStatistics parse(IVariableData lat, IVariableData lon, IVariableData geo, IVariableData time) {
        return this.parse(lat, lon, geo, Optional.of(time), Collections.emptyList());
    }

    @Override
    public ParseStatistics parse(IVariableData lat, IVariableData lon, IVariableData geo) {
        return this.parse(lat, lon, geo, Optional.empty(), Collections.emptyList());
    }

    @Override
    public IResult store(IStorer storer) throws IOException {
        return this.store(storer, new CancellationToken());
    }

    @Override
    public IResult store(IStorer storer, CancellationToken token) throws IOException {
        double d;
        this.LOGGER.debug("Started storing " + this.fileName);
        int[] shape = this.v.getShape();
        int[] origin = new int[this.v.getDimensions().size()];
        int[] shapeSizes = new int[this.loopVarsSize.size()];
        int jjj = 0;
        while (jjj < this.loopVarsSize.size()) {
            shapeSizes[jjj] = this.loopVarsSize.get(jjj);
            ++jjj;
        }
        Array latArray = this.lat.read();
        Array lonArray = this.lon.read();
        double[] latitudes = new double[shape[this.latIndex]];
        double[] longitudes = new double[shape[this.lonIndex]];
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        double lonDelta = 0.0;
        int it = 0;
        while (it < latitudes.length) {
            d = latArray.getDouble(it);
            if (minValue > d) {
                minValue = d;
            }
            if (maxValue < d) {
                maxValue = d;
            }
            latitudes[it] = d;
            ++it;
        }
        this.LOGGER.info("Latitude: min={}, max={}", (Object)minValue, (Object)maxValue);
        if (minValue < -91.0 || maxValue > 91.0) {
            throw new ParseException("Latitude is out of bounds: min=" + minValue + " max=" + maxValue);
        }
        minValue = Double.MAX_VALUE;
        maxValue = Double.MIN_VALUE;
        it = 0;
        while (it < longitudes.length) {
            d = lonArray.getDouble(it);
            if (minValue > d) {
                minValue = d;
            }
            if (maxValue < d) {
                maxValue = d;
            }
            longitudes[it] = d;
            ++it;
        }
        this.LOGGER.info("Longitude: min={}, max={}", (Object)minValue, (Object)maxValue);
        boolean needcorrection = false;
        if (minValue >= -10.0 && maxValue < 390.0 && Math.abs(maxValue - minValue) > 20.0) {
            lonDelta = 0.0;
            needcorrection = true;
        } else if (minValue >= 170.0 && maxValue < 570.0 && Math.abs(maxValue - minValue) > 20.0) {
            lonDelta = -360.0;
            needcorrection = true;
        } else if (minValue > 350.0 && maxValue < 750.0) {
            lonDelta = -540.0;
            needcorrection = true;
        }
        if (minValue < -181.0 || maxValue > 750.0) {
            throw new ParseException("Longitude is out of bounds: min=" + minValue + " max=" + maxValue);
        }
        if (needcorrection) {
            int dx = 0;
            while (dx < longitudes.length) {
                int n = dx;
                double d2 = longitudes[n] = longitudes[n] + lonDelta;
                double ll = d2;
                if (ll >= 180.0 && lonDelta == 0.0) {
                    longitudes[dx] = ll - 360.0;
                }
                ++dx;
            }
            this.LOGGER.info("Corrected longitudes by: " + lonDelta);
        }
        HashMap DATE_CACHE = new HashMap();
        HashMap date2 = new HashMap();
        if (this.timeIndex > -1) {
            this.time.ifPresent(t -> {
                try {
                    Array timeArray = t.read();
                    String sinceString = t.findAttribute("units").getStringValue();
                    int i = 0;
                    while (i < shape[this.timeIndex]) {
                        DATE_CACHE.put(i, date2.computeIfAbsent(timeArray.getInt(i), key -> this.generateString(sinceString, (int)key)));
                        ++i;
                    }
                }
                catch (IOException e) {
                    throw new ParseException("Couldn't parse time", e);
                }
            });
        }
        double shapeSize = 1.0;
        Object object = this.size;
        int n = this.size.length;
        int n2 = 0;
        while (n2 < n) {
            int sizeValue = object[n2];
            shapeSize *= (double)sizeValue;
            ++n2;
        }
        this.LOGGER.info("Grid size:" + this.size[this.lonIndex] + " x " + this.size[this.latIndex] + " ,array size is: " + shapeSize + ", indexmap: " + this.indexMap);
        BiConsumer<Integer, Integer> runt = this.indexMap.size() > 0 ? (x, y) -> {
            int n = nArray[this.indexMap.get((Object)x).intValue()] = this.dimensionMap.getOrDefault(this.indexMap.get(x), (Integer)y).intValue();
        } : (x, y) -> {};
        new ComposableStream(runt, shapeSizes).run(() -> {
            try {
                String dt = null;
                if (this.timeIndex != -1) {
                    dt = (String)DATE_CACHE.get(origin[this.timeIndex]);
                }
                int stepping = Math.min(10000, shape[this.latIndex]);
                int latSize = 0;
                while (latSize < latitudes.length) {
                    this.size[this.latIndex] = Math.min(stepping, shape[this.latIndex] - latSize);
                    nArray[this.latIndex] = latSize;
                    Array array = this.v.read(new Section(origin, this.size));
                    Index ix = array.getIndex();
                    int latIx = 0;
                    while (latIx < this.size[this.latIndex]) {
                        if (token.getCancelled()) {
                            throw new ParseCancelException("Cancelled by token");
                        }
                        int j = 0;
                        while (j < longitudes.length) {
                            ix.setDim(this.latIndex, latIx);
                            ix.setDim(this.lonIndex, j);
                            Object[] data = new Object[this.objectShapeSize];
                            data[0] = latitudes[latSize + latIx];
                            data[1] = longitudes[j];
                            data[2] = this.geoScaler.calculate(array.getDouble(ix));
                            if (this.options.isImportNulls() || data[2] != null) {
                                if (this.timeIndex != -1) {
                                    data[3] = dt;
                                }
                                for (Tuple<Integer, Integer> copy : this.copies) {
                                    data[((Integer)copy.second()).intValue()] = data[(Integer)copy.first()];
                                }
                                storer.add(data);
                            }
                            ++j;
                        }
                        ++latIx;
                    }
                    latSize += stepping;
                }
            }
            catch (ParseCancelException can) {
                return;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error while adding data", ex);
            }
        });
        try {
            object = storer.flush();
            return object;
        }
        catch (Exception ex) {
            throw new ParseException("Error while flushing data", ex);
        }
        finally {
            this.LOGGER.debug("Finished storing " + this.fileName);
        }
    }

    private String generateString(String sinceString, int i) {
        try {
            return new DateUnit(String.valueOf(i) + " " + sinceString).getDate().toInstant().toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public NetcdfFile getFile() {
        return this.ncfile;
    }

    @Override
    public void close() {
        this.closeExisting();
    }

    private class Scaler {
        private Double add_offset = 0.0;
        private Double factorValue = 1.0;
        private Double fillValue = null;
        private Double missingValue = null;

        Scaler(Variable v) {
            for (Attribute a : v.getAttributes()) {
                if (a.getShortName().equalsIgnoreCase("add_offset")) {
                    this.add_offset = Utils.getDoubleValue(a);
                    continue;
                }
                if (a.getShortName().equalsIgnoreCase("scale_factor")) {
                    this.factorValue = Utils.getDoubleValue(a);
                    continue;
                }
                if (a.getShortName().equalsIgnoreCase("_FillValue")) {
                    this.fillValue = Utils.getDoubleValue(a);
                    continue;
                }
                if (!a.getShortName().equalsIgnoreCase("missing_value")) continue;
                this.missingValue = Utils.getDoubleValue(a);
            }
        }

        Double calculate(Double value) {
            return this.missingValue != null && this.missingValue.equals(value) || this.fillValue != null && this.fillValue.equals(value) ? null : Double.valueOf(value * this.factorValue + this.add_offset);
        }
    }
}

