/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.gribbs;

import com.siggemannen.gribbs.GeoType;
import com.siggemannen.gribbs.IVariableData;
import java.util.Optional;

public class GeoVariableData
implements IVariableData {
    private final GeoType type;
    private String[] variableBindings = new String[0];
    private final Optional<Integer> preferredDimension;
    private boolean imported;

    public GeoVariableData(GeoType type) {
        this(type, Optional.empty());
    }

    public GeoVariableData(GeoType type, String binding) {
        this(type, Optional.ofNullable(binding));
    }

    public GeoVariableData(GeoType type, Optional<String> binding) {
        this(type, binding, Optional.empty());
    }

    public GeoVariableData(GeoType type, Optional<String> binding, Optional<Integer> preferredDimension) {
        this.type = type;
        this.preferredDimension = preferredDimension;
        binding.ifPresent(le -> {
            this.variableBindings = new String[]{(String)binding.get()};
        });
        this.imported = true;
    }

    @Override
    public Optional<Integer> getPreferredDimension() {
        return this.preferredDimension;
    }

    public void setVariableBinding(String ... variable) {
        this.variableBindings = variable;
    }

    public GeoType getType() {
        return this.type;
    }

    @Override
    public String[] getVariableBindings() {
        return this.variableBindings;
    }

    @Override
    public boolean isAutodetected() {
        return this.variableBindings.length == 0;
    }

    @Override
    public boolean isImported() {
        return this.imported;
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }
}

