/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.table;

import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.IBulk;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class ManualBulker {
    private static final int BATCH_SIZE = 800;
    protected int batchSize;
    private final Style style;

    public ManualBulker() {
        this(800);
    }

    public ManualBulker(int batchSize) {
        this(batchSize, Style.MULTIVALUES);
    }

    public ManualBulker(int batchSize, Style style) {
        this.batchSize = batchSize;
        this.style = style;
    }

    public ManualBulker(Style style) {
        this(800, style);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void insert(IDatabaseOperator operator, Connection c, String tableName, List<ColumnMapping> mapping, IBulk bulker) throws SQLException {
        Collections.sort(mapping, Comparator.comparing(ColumnMapping::getTo));
        StringBuilder sqlTemplate = new StringBuilder("INSERT INTO ").append(tableName).append("(");
        int i = 0;
        while (i < mapping.size()) {
            if (i > 0) {
                sqlTemplate.append(",");
            }
            sqlTemplate.append(operator.getQuotedIdentifier(mapping.get(i).getFrom().getName()));
            ++i;
        }
        sqlTemplate.append(")");
        PreparedStatement ps = null;
        switch (this.style) {
            case MULTIVALUES: {
                sqlTemplate.append(" VALUES ");
                break;
            }
            case UNION: {
                break;
            }
            case VALUES: {
                sqlTemplate.append(" VALUES ").append(System.lineSeparator());
                break;
            }
            case PREPARED_STATEMENTS: {
                sqlTemplate.append(" VALUES (");
                int i2 = 0;
                while (i2 < mapping.size()) {
                    if (i2 > 0) {
                        sqlTemplate.append(",");
                    }
                    sqlTemplate.append("?");
                    ++i2;
                }
                sqlTemplate.append(")");
                ps = c.prepareStatement(sqlTemplate.toString());
            }
        }
        int counter = 0;
        int size = sqlTemplate.length();
        Throwable throwable = null;
        Object var11_13 = null;
        try (Statement st = c.createStatement();){
            while (bulker.next()) {
                if (counter > 0) {
                    switch (this.style) {
                        case MULTIVALUES: {
                            sqlTemplate.append(",");
                            break;
                        }
                        case UNION: {
                            sqlTemplate.append(System.lineSeparator()).append(" UNION ALL ");
                            break;
                        }
                        case VALUES: {
                            sqlTemplate.append(";").append(System.lineSeparator());
                            break;
                        }
                    }
                }
                switch (this.style) {
                    case MULTIVALUES: {
                        sqlTemplate.append("(");
                        break;
                    }
                    case UNION: {
                        sqlTemplate.append(" SELECT ");
                        break;
                    }
                    case VALUES: {
                        sqlTemplate.append(" SELECT ").append(System.lineSeparator());
                        break;
                    }
                }
                ++counter;
                Object[] data = bulker.getData();
                int x = 0;
                while (x < data.length) {
                    switch (this.style) {
                        case PREPARED_STATEMENTS: {
                            ps.setString(x + 1, data[x] == null ? null : String.valueOf(data[x]));
                            break;
                        }
                        default: {
                            if (x > 0) {
                                sqlTemplate.append(",");
                            }
                            String s = data[x] == null ? null : String.valueOf(data[x]);
                            this.appendStringValue(sqlTemplate, s);
                        }
                    }
                    ++x;
                }
                switch (this.style) {
                    case MULTIVALUES: {
                        sqlTemplate.append(")");
                        break;
                    }
                    case PREPARED_STATEMENTS: {
                        ps.addBatch();
                        break;
                    }
                }
                if (counter != this.batchSize) continue;
                switch (this.style) {
                    case PREPARED_STATEMENTS: {
                        ps.executeBatch();
                        break;
                    }
                    default: {
                        st.execute(sqlTemplate.toString());
                        sqlTemplate.setLength(size);
                    }
                }
                counter = 0;
            }
            if (counter <= 0) return;
            switch (this.style) {
                case PREPARED_STATEMENTS: {
                    ps.executeBatch();
                    return;
                }
                default: {
                    st.execute(sqlTemplate.toString());
                    return;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            } else {
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void appendStringValue(StringBuilder sb, String s) {
        if (s == null) {
            sb.append("NULL");
        } else {
            sb.append("'").append(s.replace("'", "'")).append("'");
        }
    }

    public static enum Style {
        MULTIVALUES,
        UNION,
        VALUES,
        PREPARED_STATEMENTS;

    }
}

