/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.oracle;

import com.sigge.dbrunner.ADatabase;
import com.sigge.dbrunner.DatabaseServerConfig;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.oracle.OracleDatabaseOperator;
import com.sigge.dbrunner.oracle.OracleScriptRunner;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class OracleDatabase
extends ADatabase<OracleScriptRunner> {
    public static final String PROVIDER_NAME = "ORACLE";
    private final DatabaseServerConfig config;
    private final String label;

    @Override
    public List<String> getDatabases() throws SQLException {
        ArrayList<String> dbs = new ArrayList<String>();
        OracleScriptRunner r = (OracleScriptRunner)this.getScriptRunner("");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = r.getConnection().createStatement().executeQuery("select GLOBAL_NAME from global_name");){
                while (rs.next()) {
                    String string = rs.getString("GLOBAL_NAME");
                    dbs.add(string != null ? string : "(default)");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dbs.size() == 0) {
            dbs.add("(default)");
        }
        return dbs;
    }

    public OracleDatabase(DatabaseServerConfig config) {
        this.config = config;
        this.label = config.getServerLabel();
    }

    @Override
    public String getDatabaseProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public String getServer() {
        return this.config.getServer();
    }

    @Override
    public String getUser() {
        return this.config.getUser();
    }

    @Override
    public String getPassword() {
        return this.config.getPassword();
    }

    @Override
    public boolean isUseAD() {
        return false;
    }

    @Override
    public String getUniqueProviderName() {
        return String.valueOf(this.config.getUrl()) + "/" + (this.label != null ? this.label : "");
    }

    public String toString() {
        return this.config.getUrl();
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        Connection c = DriverManager.getConnection(this.config.getUrl());
        if (database != null && database.length() > 0) {
            c.setCatalog(database);
        }
        return c;
    }

    @Override
    public String getConnectionUrl() {
        return this.getUrl();
    }

    @Override
    protected OracleScriptRunner createScriptRunner(String databaseName) throws SQLException {
        return new OracleScriptRunner(this.createConnection(databaseName, null), this);
    }

    @Override
    public String getServerLabel() {
        return this.label;
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return new OracleDatabaseOperator(this);
    }
}

