/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.db2;

import com.sigge.dbrunner.AScriptRunner;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.NewLineReader;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.dbrunner.db2.DB2Database;
import com.sigge.dbrunner.db2.ParserUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class DB2ScriptRunner
extends AScriptRunner<DB2Database> {
    public DB2ScriptRunner(Connection connection, DB2Database database) {
        super(connection, database);
        this.setSendFullScript(false);
        this.setAutoCommit(true);
    }

    @Override
    public int openTransactions() {
        return 0;
    }

    @Override
    public String getCurrentDatabase() throws SQLException {
        if (this.currentDatabase != null) {
            return this.currentDatabase;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ResultSet rs = this.getConnection().createStatement().executeQuery("SELECT CURRENT SERVER AS GLOBAL_NAME FROM SYSIBM.SYSDUMMY1;");){
                while (rs.next()) {
                    String string = rs.getString("GLOBAL_NAME");
                    String string2 = this.currentDatabase = string != null ? string : "(default)";
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.currentDatabase;
    }

    @Override
    protected void executeByBatches(Reader reader, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, UnsupportedEncodingException, IOException {
        String script = NewLineReader.readAll(reader);
        ArrayList<String> strings = new ArrayList<String>();
        try {
            strings.addAll(ParserUtil.parse(script));
        }
        catch (Exception ex) {
            strings.add(script);
        }
        for (String exec : strings) {
            this.executeStatement(exec, reporter, options);
        }
    }

    @Override
    protected boolean runCommand(String command, SQLOptions options, Statement statement) throws SQLException {
        this.currentDatabase = null;
        if (options.isParseOnly()) {
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                PreparedStatement ps = this.connection.prepareStatement(command);
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return false;
        }
        return statement.execute(command);
    }
}

