/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner;

import com.sigge.dbrunner.SQLPlanType;
import com.siggemannen.functional.throwing.ThrowingBiConsumer;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.function.BiConsumer;

public class SQLOptions {
    private boolean parseOnly;
    private boolean rollbackAllUncommitedTransactions = true;
    private volatile boolean cancel;
    private SQLPlanType queryPlanType;
    private int timeout;
    private StatementPreparer statementConsumer;
    private boolean stopBatchesAtFirstError = false;
    private int currentBatchLineStart = 0;
    private int currentBatchLineEnd = 0;
    private boolean debugging = false;

    public boolean isParseOnly() {
        return this.parseOnly;
    }

    public boolean isCancelled() {
        return this.cancel;
    }

    public void cancel() {
        this.cancel = true;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean isRollbackAllUncommitedTransactions() {
        return this.rollbackAllUncommitedTransactions;
    }

    public SQLPlanType getSQLPlanType() {
        return this.queryPlanType;
    }

    public boolean isGenerateQueryPlan() {
        return this.queryPlanType == SQLPlanType.ACTUAL || this.queryPlanType == SQLPlanType.LIVE;
    }

    public StatementPreparer getStatementConsumer() {
        return this.statementConsumer;
    }

    public boolean isStopBatchesAtFirstError() {
        return this.stopBatchesAtFirstError;
    }

    public int getCurrentBatchLineStart() {
        return this.currentBatchLineStart;
    }

    public void setCurrentBatchLineStart(int currentBatchLineStart) {
        this.currentBatchLineStart = currentBatchLineStart;
    }

    public int getCurrentBatchLineEnd() {
        return this.currentBatchLineEnd;
    }

    public void setCurrentBatchLineEnd(int currentBatchLineEnd) {
        this.currentBatchLineEnd = currentBatchLineEnd;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public static class Builder {
        private final SQLOptions options = new SQLOptions();

        public Builder parseOnly(boolean parseOnly) {
            this.options.parseOnly = parseOnly;
            return this;
        }

        public Builder rollbackAllUncommitedTransactions(boolean rollbackAllUncommitedTransctions) {
            this.options.rollbackAllUncommitedTransactions = rollbackAllUncommitedTransctions;
            return this;
        }

        public Builder generateQueryPlan(SQLPlanType generateQueryPlan) {
            this.options.queryPlanType = generateQueryPlan;
            return this;
        }

        public Builder debugging(boolean debugging) {
            this.options.debugging = debugging;
            return this;
        }

        public Builder timeout(int timeout) {
            this.options.timeout = timeout;
            return this;
        }

        public Builder prepareStatement(ThrowingBiConsumer<Integer, PreparedStatement> statementConsumer) {
            this.options.statementConsumer = new StatementPreparer((BiConsumer<Integer, PreparedStatement>)statementConsumer);
            return this;
        }

        public Builder setStopBatchesAtFirstError(boolean stopBatchesAtFirstError) {
            this.options.stopBatchesAtFirstError = stopBatchesAtFirstError;
            return this;
        }

        public SQLOptions build() {
            return this.options;
        }
    }

    public static class StatementPreparer {
        private final BiConsumer<Integer, PreparedStatement> statementConsumer2;
        private int statement = 0;

        public StatementPreparer(BiConsumer<Integer, PreparedStatement> statementConsumer) {
            this.statementConsumer2 = statementConsumer;
        }

        public void consume(Statement ps) {
            if (!(ps instanceof PreparedStatement)) {
                return;
            }
            PreparedStatement pss = (PreparedStatement)ps;
            this.statementConsumer2.accept(this.statement, pss);
            ++this.statement;
        }
    }
}

