/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner;

import java.io.IOException;
import java.io.Reader;

public class NewLineReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private boolean skipLF = false;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;
    private String preNewLine = "";
    private String postNewLine = "";

    public NewLineReader(Reader in, int sz) {
        super((Object)in);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = in;
        this.cb = new char[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public NewLineReader(Reader in) {
        this(in, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        while ((n = this.in.read(this.cb, 0, this.cb.length)) == 0) {
        }
        if (n > 0) {
            this.nChars = n;
            this.nextChar = 0;
        }
    }

    @Override
    public int read() throws IOException {
        throw new IllegalArgumentException("Read not supported");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IllegalArgumentException("Read not supported");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readLine() throws IOException {
        StringBuffer s = null;
        this.preNewLine = "";
        this.postNewLine = "";
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            boolean omitLF = this.skipLF;
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (s != null && s.length() > 0) {
                        return s.toString();
                    }
                    return null;
                }
                boolean eol = false;
                char c = '\u0000';
                if (omitLF && this.cb[this.nextChar] == '\n') {
                    this.preNewLine = "\n";
                }
                this.skipLF = false;
                omitLF = false;
                int i = ++this.nextChar;
                while (i < this.nChars) {
                    c = this.cb[i];
                    if (c == '\n' || c == '\r') {
                        eol = true;
                        break;
                    }
                    ++i;
                }
                int startChar = this.nextChar;
                this.nextChar = i;
                if (eol) {
                    String str;
                    if (s == null) {
                        str = new String(this.cb, startChar, i - startChar);
                    } else {
                        s.append(this.cb, startChar, i - startChar);
                        str = s.toString();
                    }
                    ++this.nextChar;
                    if (c == '\r') {
                        this.skipLF = true;
                        this.postNewLine = "\r";
                    } else {
                        this.postNewLine = "\n";
                    }
                    return str;
                }
                if (s == null) {
                    s = new StringBuffer(defaultExpectedLineLength);
                }
                s.append(this.cb, startChar, i - startChar);
            }
        }
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IllegalArgumentException("skip not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.ready();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IllegalArgumentException("Mark not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new IllegalArgumentException("Mark not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            try {
                this.in.close();
            }
            finally {
                this.in = null;
                this.cb = null;
            }
        }
    }

    public String getPostNewLine() {
        return this.postNewLine;
    }

    public String getPreNewLine() {
        return this.preNewLine;
    }

    public static String readAll(Reader r) throws IOException {
        StringBuilder script = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (NewLineReader lineReader = new NewLineReader(r);){
            String line;
            while ((line = lineReader.readLine()) != null) {
                script.append(lineReader.getPreNewLine());
                script.append(line);
                script.append(lineReader.getPostNewLine());
            }
            script.append(lineReader.getPreNewLine());
            script.append(lineReader.getPostNewLine());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return script.toString();
    }
}

