/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import thredds.catalog.DataFormatType;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import ucar.nc2.constants.FeatureType;

class ThreddsMetadataImpl
implements ThreddsMetadata,
ThreddsMetadataBuilder {
    private boolean isBuilt = false;
    private List<DocumentationImpl> docs;
    private List<KeyphraseImpl> keyphrases;
    private List<ProjectNameImpl> projectNames;
    private List<ContributorImpl> creators;
    private List<ContributorImpl> contributors;
    private List<ContributorImpl> publishers;
    private List<DatePointImpl> otherDates;
    private DatePointImpl createdDate;
    private DatePointImpl modifiedDate;
    private DatePointImpl issuedDate;
    private DatePointImpl validDate;
    private DatePointImpl availableDate;
    private DatePointImpl metadataCreatedDate;
    private DatePointImpl metadataModifiedDate;
    private GeospatialCoverageImpl geospatialCoverage;
    private DateRangeImpl temporalCoverage;
    private List<VariableGroupImpl> variableGroups;
    private long dataSizeInBytes = -1L;
    private DataFormatType dataFormat;
    private FeatureType dataType;
    private String collectionType;

    ThreddsMetadataImpl() {
    }

    @Override
    public boolean isEmpty() {
        if (this.docs != null && !this.docs.isEmpty()) {
            return false;
        }
        if (this.keyphrases != null && !this.keyphrases.isEmpty()) {
            return false;
        }
        if (this.projectNames != null && !this.projectNames.isEmpty()) {
            return false;
        }
        if (this.creators != null && !this.creators.isEmpty()) {
            return false;
        }
        if (this.contributors != null && !this.contributors.isEmpty()) {
            return false;
        }
        if (this.publishers != null && !this.publishers.isEmpty()) {
            return false;
        }
        if (this.createdDate != null || this.modifiedDate != null || this.issuedDate != null || this.validDate != null || this.availableDate != null || this.metadataCreatedDate != null || this.metadataModifiedDate != null || this.geospatialCoverage != null || this.temporalCoverage != null) {
            return false;
        }
        if (this.variableGroups != null && !this.variableGroups.isEmpty()) {
            return false;
        }
        return this.dataSizeInBytes == -1L && this.dataFormat == null && this.dataType == null && this.collectionType == null;
    }

    @Override
    public ThreddsMetadataBuilder.DocumentationBuilder addDocumentation(String docType, String title, String externalReference) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.docs == null) {
            this.docs = new ArrayList<DocumentationImpl>();
        }
        DocumentationImpl doc = new DocumentationImpl(docType, title, externalReference);
        this.docs.add(doc);
        return doc;
    }

    @Override
    public ThreddsMetadataBuilder.DocumentationBuilder addDocumentation(String docType, String content) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (content == null) {
            throw new IllegalArgumentException("Content may not be null.");
        }
        if (this.docs == null) {
            this.docs = new ArrayList<DocumentationImpl>();
        }
        DocumentationImpl doc = new DocumentationImpl(docType, content);
        this.docs.add(doc);
        return doc;
    }

    @Override
    public boolean removeDocumentation(ThreddsMetadataBuilder.DocumentationBuilder docBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (docBuilder == null) {
            return false;
        }
        if (this.docs == null) {
            return false;
        }
        return this.docs.remove((DocumentationImpl)docBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.DocumentationBuilder> getDocumentationBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DocumentationImpl>(this.docs));
    }

    @Override
    public List<ThreddsMetadata.Documentation> getDocumentation() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.docs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DocumentationImpl>(this.docs));
    }

    @Override
    public ThreddsMetadataBuilder.KeyphraseBuilder addKeyphrase(String authority, String phrase) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (phrase == null) {
            throw new IllegalArgumentException("Phrase may not be null.");
        }
        if (this.keyphrases == null) {
            this.keyphrases = new ArrayList<KeyphraseImpl>();
        }
        KeyphraseImpl keyphrase = new KeyphraseImpl(authority, phrase);
        this.keyphrases.add(keyphrase);
        return keyphrase;
    }

    @Override
    public boolean removeKeyphrase(ThreddsMetadataBuilder.KeyphraseBuilder keyphraseBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (keyphraseBuilder == null) {
            return false;
        }
        if (this.keyphrases == null) {
            return false;
        }
        return this.keyphrases.remove((KeyphraseImpl)keyphraseBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.KeyphraseBuilder> getKeyphraseBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.keyphrases == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<KeyphraseImpl>(this.keyphrases));
    }

    @Override
    public List<ThreddsMetadata.Keyphrase> getKeyphrases() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.keyphrases == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<KeyphraseImpl>(this.keyphrases));
    }

    @Override
    public ThreddsMetadataBuilder.ProjectNameBuilder addProjectName(String namingAuthority, String name) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Project name may not be null.");
        }
        if (this.projectNames == null) {
            this.projectNames = new ArrayList<ProjectNameImpl>();
        }
        ProjectNameImpl projectName = new ProjectNameImpl(namingAuthority, name);
        this.projectNames.add(projectName);
        return projectName;
    }

    @Override
    public boolean removeProjectName(ThreddsMetadataBuilder.ProjectNameBuilder projectNameBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (projectNameBuilder == null) {
            return false;
        }
        if (this.projectNames == null) {
            return false;
        }
        return this.projectNames.remove((ProjectNameImpl)projectNameBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ProjectNameBuilder> getProjectNameBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.projectNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ProjectNameImpl>(this.projectNames));
    }

    @Override
    public List<ThreddsMetadata.ProjectName> getProjectNames() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.projectNames == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ProjectNameImpl>(this.projectNames));
    }

    @Override
    public ThreddsMetadataBuilder.ContributorBuilder addCreator() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.creators == null) {
            this.creators = new ArrayList<ContributorImpl>();
        }
        ContributorImpl contributor = new ContributorImpl();
        this.creators.add(contributor);
        return contributor;
    }

    @Override
    public boolean removeCreator(ThreddsMetadataBuilder.ContributorBuilder creatorBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (creatorBuilder == null) {
            return false;
        }
        if (this.creators == null) {
            return false;
        }
        return this.creators.remove((ContributorImpl)creatorBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ContributorBuilder> getCreatorBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.creators == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.creators));
    }

    @Override
    public List<ThreddsMetadata.Contributor> getCreator() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.creators == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.creators));
    }

    @Override
    public ThreddsMetadataBuilder.ContributorBuilder addContributor() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.contributors == null) {
            this.contributors = new ArrayList<ContributorImpl>();
        }
        ContributorImpl contributor = new ContributorImpl();
        this.contributors.add(contributor);
        return contributor;
    }

    @Override
    public boolean removeContributor(ThreddsMetadataBuilder.ContributorBuilder contributorBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (contributorBuilder == null) {
            return false;
        }
        if (this.contributors == null) {
            return false;
        }
        return this.contributors.remove((ContributorImpl)contributorBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ContributorBuilder> getContributorBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.contributors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.contributors));
    }

    @Override
    public List<ThreddsMetadata.Contributor> getContributor() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.contributors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.contributors));
    }

    @Override
    public ThreddsMetadataBuilder.ContributorBuilder addPublisher() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.publishers == null) {
            this.publishers = new ArrayList<ContributorImpl>();
        }
        ContributorImpl contributor = new ContributorImpl();
        this.publishers.add(contributor);
        return contributor;
    }

    @Override
    public boolean removePublisher(ThreddsMetadataBuilder.ContributorBuilder publisherBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (publisherBuilder == null) {
            return false;
        }
        if (this.publishers == null) {
            return false;
        }
        return this.publishers.remove((ContributorImpl)publisherBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.ContributorBuilder> getPublisherBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.publishers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.publishers));
    }

    @Override
    public List<ThreddsMetadata.Contributor> getPublisher() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.publishers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ContributorImpl>(this.publishers));
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder addOtherDatePointBuilder(String date, String format, String type) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        ThreddsMetadata.DatePointType datePointType = ThreddsMetadata.DatePointType.getTypeForLabel(type);
        if (datePointType != ThreddsMetadata.DatePointType.Other && datePointType != ThreddsMetadata.DatePointType.Untyped) {
            throw new IllegalArgumentException("Must use explicit setter method for given type [" + type + "].");
        }
        if (this.otherDates == null) {
            this.otherDates = new ArrayList<DatePointImpl>();
        }
        DatePointImpl dp = new DatePointImpl(date, format, type);
        this.otherDates.add(dp);
        return dp;
    }

    @Override
    public boolean removeOtherDatePointBuilder(ThreddsMetadataBuilder.DatePointBuilder builder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (builder == null) {
            return false;
        }
        if (this.otherDates == null) {
            return false;
        }
        return this.otherDates.remove((DatePointImpl)builder);
    }

    @Override
    public List<ThreddsMetadataBuilder.DatePointBuilder> getOtherDatePointBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.otherDates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DatePointImpl>(this.otherDates));
    }

    @Override
    public List<ThreddsMetadata.DatePoint> getOtherDates() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.otherDates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<DatePointImpl>(this.otherDates));
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setCreatedDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.createdDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.Created.toString());
        return this.createdDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getCreatedDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.createdDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getCreatedDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.createdDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setModifiedDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.modifiedDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.Modified.toString());
        return this.modifiedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getModifiedDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.modifiedDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getModifiedDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.modifiedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setIssuedDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.issuedDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.Issued.toString());
        return this.issuedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getIssuedDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.issuedDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getIssuedDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.issuedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setValidDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.validDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.Valid.toString());
        return this.validDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getValidDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.validDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getValidDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.validDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setAvailableDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.availableDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.Available.toString());
        return this.availableDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getAvailableDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.availableDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getAvailableDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.availableDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setMetadataCreatedDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.metadataCreatedDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.MetadataCreated.toString());
        return this.metadataCreatedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getMetadataCreatedDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.metadataCreatedDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getMetadataCreatedDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.metadataCreatedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder setMetadataModifiedDatePointBuilder(String date, String format) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.metadataModifiedDate = new DatePointImpl(date, format, ThreddsMetadata.DatePointType.MetadataModified.toString());
        return this.metadataModifiedDate;
    }

    @Override
    public ThreddsMetadataBuilder.DatePointBuilder getMetadataModifiedDatePointBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.metadataModifiedDate;
    }

    @Override
    public ThreddsMetadata.DatePoint getMetadataModifiedDate() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.metadataModifiedDate;
    }

    @Override
    public ThreddsMetadataBuilder.GeospatialCoverageBuilder setNewGeospatialCoverageBuilder(URI crsUri) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        GeospatialCoverageImpl gci = new GeospatialCoverageImpl();
        gci.setCRS(crsUri);
        this.geospatialCoverage = gci;
        return null;
    }

    @Override
    public void removeGeospatialCoverageBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.geospatialCoverage = null;
    }

    @Override
    public ThreddsMetadataBuilder.GeospatialCoverageBuilder getGeospatialCoverageBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.geospatialCoverage;
    }

    @Override
    public ThreddsMetadata.GeospatialCoverage getGeospatialCoverage() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.geospatialCoverage;
    }

    @Override
    public ThreddsMetadataBuilder.DateRangeBuilder setTemporalCoverageBuilder(String startDate, String startDateFormat, String endDate, String endDateFormat, String duration, String resolution) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.temporalCoverage = new DateRangeImpl(startDate, startDateFormat, endDate, endDateFormat, duration, resolution);
        return this.temporalCoverage;
    }

    @Override
    public ThreddsMetadataBuilder.DateRangeBuilder getTemporalCoverageBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        return this.temporalCoverage;
    }

    @Override
    public ThreddsMetadata.DateRange getTemporalCoverage() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        return this.temporalCoverage;
    }

    @Override
    public ThreddsMetadataBuilder.VariableGroupBuilder addVariableGroupBuilder() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.variableGroups == null) {
            this.variableGroups = new ArrayList<VariableGroupImpl>();
        }
        VariableGroupImpl varGroup = new VariableGroupImpl();
        this.variableGroups.add(varGroup);
        return varGroup;
    }

    @Override
    public boolean removeVariableGroupBuilder(ThreddsMetadataBuilder.VariableGroupBuilder variableGroupBuilder) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (variableGroupBuilder == null) {
            return false;
        }
        if (this.variableGroups == null) {
            return false;
        }
        return this.variableGroups.remove((VariableGroupImpl)variableGroupBuilder);
    }

    @Override
    public List<ThreddsMetadataBuilder.VariableGroupBuilder> getVariableGroupBuilders() {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        if (this.variableGroups == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<VariableGroupImpl>(this.variableGroups));
    }

    @Override
    public List<ThreddsMetadata.VariableGroup> getVariableGroups() {
        if (!this.isBuilt) {
            throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
        }
        if (this.variableGroups == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<VariableGroupImpl>(this.variableGroups));
    }

    @Override
    public void setDataSizeInBytes(long dataSizeInBytes) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dataSizeInBytes = dataSizeInBytes;
    }

    @Override
    public long getDataSizeInBytes() {
        return this.dataSizeInBytes;
    }

    @Override
    public void setDataFormat(DataFormatType dataFormat) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dataFormat = dataFormat;
    }

    @Override
    public void setDataFormat(String dataFormat) {
        this.setDataFormat(DataFormatType.getType(dataFormat));
    }

    @Override
    public DataFormatType getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public void setDataType(FeatureType dataType) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.dataType = dataType;
    }

    @Override
    public void setDataType(String dataType) {
        this.setDataType(FeatureType.getType(dataType));
    }

    @Override
    public FeatureType getDataType() {
        return this.dataType;
    }

    @Override
    public void setCollectionType(String collectionType) {
        if (this.isBuilt) {
            throw new IllegalStateException("This Builder has been built.");
        }
        this.collectionType = collectionType;
    }

    @Override
    public String getCollectionType() {
        return this.collectionType;
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public BuilderIssues getIssues() {
        BuilderIssues issues = new BuilderIssues();
        if (this.docs != null) {
            for (DocumentationImpl doc : this.docs) {
                issues.addAllIssues(doc.getIssues());
            }
        }
        if (this.keyphrases != null) {
            for (KeyphraseImpl keyphrase : this.keyphrases) {
                issues.addAllIssues(keyphrase.getIssues());
            }
        }
        if (this.creators != null) {
            for (ContributorImpl creator : this.creators) {
                issues.addAllIssues(creator.getIssues());
            }
        }
        if (this.contributors != null) {
            for (ContributorImpl contributor : this.contributors) {
                issues.addAllIssues(contributor.getIssues());
            }
        }
        if (this.publishers != null) {
            for (ContributorImpl publisher : this.publishers) {
                issues.addAllIssues(publisher.getIssues());
            }
        }
        if (this.otherDates != null) {
            for (DatePointImpl date : this.otherDates) {
                issues.addAllIssues(date.getIssues());
            }
        }
        if (this.createdDate != null) {
            issues.addAllIssues(this.createdDate.getIssues());
        }
        if (this.modifiedDate != null) {
            issues.addAllIssues(this.modifiedDate.getIssues());
        }
        if (this.issuedDate != null) {
            issues.addAllIssues(this.issuedDate.getIssues());
        }
        if (this.validDate != null) {
            issues.addAllIssues(this.validDate.getIssues());
        }
        if (this.availableDate != null) {
            issues.addAllIssues(this.availableDate.getIssues());
        }
        if (this.metadataCreatedDate != null) {
            issues.addAllIssues(this.metadataCreatedDate.getIssues());
        }
        if (this.metadataModifiedDate != null) {
            issues.addAllIssues(this.metadataModifiedDate.getIssues());
        }
        if (this.geospatialCoverage != null) {
            issues.addAllIssues(this.geospatialCoverage.getIssues());
        }
        if (this.temporalCoverage != null) {
            issues.addAllIssues(this.temporalCoverage.getIssues());
        }
        if (this.variableGroups != null) {
            for (VariableGroupImpl variableGroup : this.variableGroups) {
                issues.addAllIssues(variableGroup.getIssues());
            }
        }
        return issues;
    }

    @Override
    public ThreddsMetadata build() throws BuilderException {
        if (this.isBuilt) {
            return this;
        }
        if (this.docs != null) {
            for (DocumentationImpl doc : this.docs) {
                doc.build();
            }
        }
        if (this.keyphrases != null) {
            for (KeyphraseImpl keyphrase : this.keyphrases) {
                keyphrase.build();
            }
        }
        if (this.creators != null) {
            for (ContributorImpl creator : this.creators) {
                creator.build();
            }
        }
        if (this.contributors != null) {
            for (ContributorImpl contributor : this.contributors) {
                contributor.build();
            }
        }
        if (this.publishers != null) {
            for (ContributorImpl publisher : this.publishers) {
                publisher.build();
            }
        }
        if (this.otherDates != null) {
            for (DatePointImpl date : this.otherDates) {
                date.build();
            }
        }
        if (this.createdDate != null) {
            this.createdDate.build();
        }
        if (this.modifiedDate != null) {
            this.modifiedDate.build();
        }
        if (this.issuedDate != null) {
            this.issuedDate.build();
        }
        if (this.validDate != null) {
            this.validDate.build();
        }
        if (this.availableDate != null) {
            this.availableDate.build();
        }
        if (this.metadataCreatedDate != null) {
            this.metadataCreatedDate.build();
        }
        if (this.metadataModifiedDate != null) {
            this.metadataModifiedDate.build();
        }
        if (this.geospatialCoverage != null) {
            this.geospatialCoverage.build();
        }
        if (this.temporalCoverage != null) {
            this.temporalCoverage.build();
        }
        if (this.variableGroups != null) {
            for (VariableGroupImpl variableGroup : this.variableGroups) {
                variableGroup.build();
            }
        }
        this.isBuilt = true;
        return this;
    }

    static class GeospatialRangeImpl
    implements ThreddsMetadata.GeospatialRange,
    ThreddsMetadataBuilder.GeospatialRangeBuilder {
        private boolean isBuilt = false;
        private boolean isHorizontal = false;
        private double start = 0.0;
        private double size = 0.0;
        private double resolution = 0.0;
        private String units = "";

        GeospatialRangeImpl() {
        }

        @Override
        public void setHorizontal(boolean isHorizontal) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.isHorizontal = isHorizontal;
        }

        @Override
        public boolean isHorizontal() {
            return this.isHorizontal;
        }

        @Override
        public void setStart(double start) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.start = start;
        }

        @Override
        public double getStart() {
            return this.start;
        }

        @Override
        public void setSize(double size) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.size = size;
        }

        @Override
        public double getSize() {
            return this.size;
        }

        @Override
        public void setResolution(double resolution) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.resolution = resolution;
        }

        @Override
        public double getResolution() {
            return this.resolution;
        }

        @Override
        public void setUnits(String units) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.units = units == null ? "" : units;
        }

        @Override
        public String getUnits() {
            return this.units;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.GeospatialRange build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class GeospatialCoverageImpl
    implements ThreddsMetadata.GeospatialCoverage,
    ThreddsMetadataBuilder.GeospatialCoverageBuilder {
        private boolean isBuilt = false;
        private URI defaultCrsUri;
        private URI crsUri;
        private boolean isZPositiveUp;
        private boolean isGlobal;
        private List<GeospatialRangeImpl> extent;

        GeospatialCoverageImpl() {
            String defaultCrsUriString = "urn:x-mycrs:2D-WGS84-ellipsoid";
            try {
                this.defaultCrsUri = new URI(defaultCrsUriString);
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Bad URI syntax for default CRS URI [" + defaultCrsUriString + "]: " + e.getMessage());
            }
            this.crsUri = this.defaultCrsUri;
        }

        @Override
        public void setCRS(URI crsUri) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (crsUri == null) {
                this.crsUri = this.defaultCrsUri;
            }
            this.crsUri = crsUri;
        }

        @Override
        public URI getCRS() {
            return this.crsUri;
        }

        @Override
        public void setGlobal(boolean isGlobal) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.isGlobal = isGlobal;
        }

        @Override
        public boolean isGlobal() {
            return this.isGlobal;
        }

        @Override
        public void setZPositiveUp(boolean isZPositiveUp) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.isZPositiveUp = isZPositiveUp;
        }

        @Override
        public boolean isZPositiveUp() {
            return this.isZPositiveUp;
        }

        @Override
        public ThreddsMetadataBuilder.GeospatialRangeBuilder addExtentBuilder() {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (this.extent == null) {
                this.extent = new ArrayList<GeospatialRangeImpl>();
            }
            GeospatialRangeImpl gri = new GeospatialRangeImpl();
            this.extent.add(gri);
            return gri;
        }

        @Override
        public boolean removeExtentBuilder(ThreddsMetadataBuilder.GeospatialRangeBuilder geospatialRangeBuilder) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (geospatialRangeBuilder == null) {
                return true;
            }
            if (this.extent == null) {
                return false;
            }
            return this.extent.remove((GeospatialRangeImpl)geospatialRangeBuilder);
        }

        @Override
        public List<ThreddsMetadataBuilder.GeospatialRangeBuilder> getExtentBuilders() {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (this.extent == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<GeospatialRangeImpl>(this.extent));
        }

        @Override
        public List<ThreddsMetadata.GeospatialRange> getExtent() {
            if (!this.isBuilt) {
                throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
            }
            if (this.extent == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<GeospatialRangeImpl>(this.extent));
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.GeospatialCoverage build() throws BuilderException {
            return this;
        }
    }

    static class VariableImpl
    implements ThreddsMetadata.Variable,
    ThreddsMetadataBuilder.VariableBuilder {
        private boolean isBuilt;
        private String name;
        private String description;
        private String units;
        private String vocabularyId;
        private String vocabularyName;
        private ThreddsMetadataBuilder.VariableGroupBuilder parent;

        VariableImpl(String name, String description, String units, String vocabId, String vocabName, ThreddsMetadataBuilder.VariableGroupBuilder parent) {
            this.name = name;
            this.description = description;
            this.units = units;
            this.vocabularyId = vocabId;
            this.vocabularyName = vocabName;
            this.parent = parent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.name = name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String description) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.description = description;
        }

        @Override
        public String getUnits() {
            return this.units;
        }

        @Override
        public void setUnits(String units) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.units = units;
        }

        @Override
        public String getVocabularyId() {
            return this.vocabularyId;
        }

        @Override
        public void setVocabularyId(String vocabularyId) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.vocabularyId = vocabularyId;
        }

        @Override
        public String getVocabularyName() {
            return this.vocabularyName;
        }

        @Override
        public void setVocabularyName(String vocabularyName) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.vocabularyName = vocabularyName;
        }

        @Override
        public String getVocabularyAuthorityId() {
            return this.parent.getVocabularyAuthorityId();
        }

        @Override
        public String getVocabularyAuthorityUrl() {
            return this.parent.getVocabularyAuthorityUrl();
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            if (this.name == null || this.name.length() == 0) {
                return new BuilderIssues(BuilderIssue.Severity.WARNING, "Variable name is null or empty.", this, null);
            }
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.Variable build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class VariableGroupImpl
    implements ThreddsMetadata.VariableGroup,
    ThreddsMetadataBuilder.VariableGroupBuilder {
        private boolean isBuilt = false;
        private String vocabularyAuthorityId;
        private String vocabularyAuthorityUrl;
        private List<VariableImpl> variables;
        private String variableMapUrl;

        VariableGroupImpl() {
        }

        @Override
        public String getVocabularyAuthorityId() {
            return this.vocabularyAuthorityId;
        }

        @Override
        public void setVocabularyAuthorityId(String vocabAuthId) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            this.vocabularyAuthorityId = vocabAuthId;
        }

        @Override
        public String getVocabularyAuthorityUrl() {
            return this.vocabularyAuthorityUrl;
        }

        @Override
        public void setVocabularyAuthorityUrl(String vocabAuthUrl) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            this.vocabularyAuthorityUrl = vocabAuthUrl;
        }

        @Override
        public List<ThreddsMetadata.Variable> getVariables() {
            if (!this.isBuilt) {
                throw new IllegalStateException("Sorry, I've escaped from my Builder before being built.");
            }
            if (this.variables == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<VariableImpl>(this.variables));
        }

        @Override
        public List<ThreddsMetadataBuilder.VariableBuilder> getVariableBuilders() {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            if (this.variables == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<VariableImpl>(this.variables));
        }

        @Override
        public ThreddsMetadataBuilder.VariableBuilder addVariableBuilder(String name, String description, String units, String vocabId, String vocabName) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            if (this.variableMapUrl != null) {
                throw new IllegalStateException("Already contains variableMap, can't add variables.");
            }
            VariableImpl newVar = new VariableImpl(name, description, units, vocabId, vocabName, this);
            if (this.variables == null) {
                this.variables = new ArrayList<VariableImpl>();
            }
            this.variables.add(newVar);
            return newVar;
        }

        @Override
        public String getVariableMapUrl() {
            return this.variableMapUrl;
        }

        @Override
        public void setVariableMapUrl(String variableMapUrl) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has already been built.");
            }
            if (variableMapUrl != null && this.variables != null && !this.variables.isEmpty()) {
                throw new IllegalStateException("Already contains variables, can't set variableMap.");
            }
            this.variableMapUrl = variableMapUrl;
        }

        @Override
        public boolean isEmpty() {
            return this.variableMapUrl == null && (this.variables == null || this.variables.isEmpty());
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            if (this.variableMapUrl != null && this.variables != null && !this.variables.isEmpty()) {
                return new BuilderIssues(BuilderIssue.Severity.ERROR, "This VariableGroupBuilder has variables and variableMap.", this, null);
            }
            return new BuilderIssues();
        }

        @Override
        public Object build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class ContributorImpl
    implements ThreddsMetadata.Contributor,
    ThreddsMetadataBuilder.ContributorBuilder {
        private boolean isBuilt;
        private String authority;
        private String name;
        private String role;
        private String email;
        private String webPage;

        ContributorImpl() {
        }

        @Override
        public String getNamingAuthority() {
            return this.authority;
        }

        @Override
        public void setNamingAuthority(String authority) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.authority = authority;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            if (name == null) {
                throw new IllegalArgumentException("Name may not be null.");
            }
            this.name = name;
        }

        @Override
        public String getRole() {
            return this.role;
        }

        @Override
        public void setRole(String role) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.role = role;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public void setEmail(String email) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.email = email;
        }

        @Override
        public String getWebPage() {
            return this.webPage;
        }

        @Override
        public void setWebPage(String webPage) {
            if (this.isBuilt) {
                throw new IllegalStateException("This Builder has been built.");
            }
            this.webPage = webPage;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            if (this.name == null) {
                return new BuilderIssues(BuilderIssue.Severity.ERROR, "Name may not be null.", this, null);
            }
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.Contributor build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class DateRangeImpl
    implements ThreddsMetadata.DateRange,
    ThreddsMetadataBuilder.DateRangeBuilder {
        private boolean isBuilt = false;
        private final String startDateFormat;
        private final String startDate;
        private final String endDateFormat;
        private final String endDate;
        private final String duration;
        private final String resolution;

        DateRangeImpl(String startDate, String startDateFormat, String endDate, String endDateFormat, String duration, String resolution) {
            this.startDateFormat = startDateFormat;
            this.startDate = startDate;
            this.endDateFormat = endDateFormat;
            this.endDate = endDate;
            this.duration = duration;
            this.resolution = resolution;
        }

        @Override
        public String getStartDateFormat() {
            return this.startDateFormat;
        }

        @Override
        public String getStartDate() {
            return this.startDate;
        }

        @Override
        public String getEndDateFormat() {
            return this.endDateFormat;
        }

        @Override
        public String getEndDate() {
            return this.endDate;
        }

        @Override
        public String getDuration() {
            return this.duration;
        }

        @Override
        public String getResolution() {
            return this.resolution;
        }

        public String toString() {
            return (this.isBuilt ? "DateRange" : "DateRangeBuilder") + " [" + this.startDate + " <-- " + this.duration + " --> " + this.endDate + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DateRangeImpl)) {
                return false;
            }
            return obj.hashCode() == this.hashCode();
        }

        public int hashCode() {
            int result = 17;
            if (this.startDate != null) {
                result = 37 * result + this.startDate.hashCode();
            }
            if (this.startDateFormat != null) {
                result = 37 * result + this.startDateFormat.hashCode();
            }
            if (this.endDate != null) {
                result = 37 * result + this.endDate.hashCode();
            }
            if (this.endDateFormat != null) {
                result = 37 * result + this.endDateFormat.hashCode();
            }
            if (this.duration != null) {
                result = 37 * result + this.duration.hashCode();
            }
            return result;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            int specified = 3;
            if (this.startDate == null || this.startDate.length() == 0) {
                --specified;
            }
            if (this.endDate == null || this.endDate.length() == 0) {
                --specified;
            }
            if (this.duration == null || this.duration.length() == 0) {
                --specified;
            }
            if (specified == 2) {
                return new BuilderIssues();
            }
            if (specified < 2) {
                return new BuilderIssues(BuilderIssue.Severity.ERROR, "Underspecified " + this.toString(), this, null);
            }
            return new BuilderIssues(BuilderIssue.Severity.ERROR, "Overspecified " + this.toString(), this, null);
        }

        @Override
        public ThreddsMetadata.DateRange build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class DatePointImpl
    implements ThreddsMetadata.DatePoint,
    ThreddsMetadataBuilder.DatePointBuilder {
        private boolean isBuilt = false;
        private final String date;
        private final String format;
        private final String type;

        DatePointImpl(String date, String format, String type) {
            if (date == null) {
                throw new IllegalArgumentException("Date may not be null.");
            }
            this.date = date;
            this.format = format;
            this.type = type;
        }

        @Override
        public String getDate() {
            return this.date;
        }

        @Override
        public String getDateFormat() {
            return this.format;
        }

        @Override
        public boolean isTyped() {
            return this.type != null || this.type.length() == 0;
        }

        @Override
        public String getType() {
            return this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DatePointImpl)) {
                return false;
            }
            return obj.hashCode() == this.hashCode();
        }

        public int hashCode() {
            int result = 17;
            if (this.date != null) {
                result = 37 * result + this.date.hashCode();
            }
            if (this.format != null) {
                result = 37 * result + this.format.hashCode();
            }
            if (this.type != null) {
                result = 37 * result + this.type.hashCode();
            }
            return result;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            if (this.date == null) {
                return new BuilderIssues(BuilderIssue.Severity.ERROR, "Date may not be null.", this, null);
            }
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.DatePoint build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class ProjectNameImpl
    implements ThreddsMetadata.ProjectName,
    ThreddsMetadataBuilder.ProjectNameBuilder {
        private boolean isBuilt;
        private String namingAuthority;
        private String projectName;

        ProjectNameImpl(String namingAuthority, String projectName) {
            if (projectName == null || projectName.length() == 0) {
                throw new IllegalArgumentException("Phrase may not be null.");
            }
            this.namingAuthority = namingAuthority;
            this.projectName = projectName;
            this.isBuilt = false;
        }

        @Override
        public String getNamingAuthority() {
            return this.namingAuthority;
        }

        @Override
        public String getName() {
            return this.projectName;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            if (this.projectName == null || this.projectName.length() == 0) {
                return new BuilderIssues(BuilderIssue.Severity.WARNING, "Phrase may not be null or empty.", this, null);
            }
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.ProjectName build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class KeyphraseImpl
    implements ThreddsMetadata.Keyphrase,
    ThreddsMetadataBuilder.KeyphraseBuilder {
        private boolean isBuilt;
        private final String authority;
        private final String phrase;

        KeyphraseImpl(String authority, String phrase) {
            if (phrase == null || phrase.length() == 0) {
                throw new IllegalArgumentException("Phrase may not be null.");
            }
            this.authority = authority;
            this.phrase = phrase;
            this.isBuilt = false;
        }

        @Override
        public String getAuthority() {
            return this.authority;
        }

        @Override
        public String getPhrase() {
            return this.phrase;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            if (this.phrase == null || this.phrase.length() == 0) {
                return new BuilderIssues(BuilderIssue.Severity.WARNING, "Phrase may not be null or empty.", this, null);
            }
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.Keyphrase build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }

    static class DocumentationImpl
    implements ThreddsMetadata.Documentation,
    ThreddsMetadataBuilder.DocumentationBuilder {
        private boolean isBuilt = false;
        private final boolean isContainedContent;
        private final String docType;
        private final String title;
        private final String externalReference;
        private final String content;

        DocumentationImpl(String docType, String title, String externalReference) {
            this.isContainedContent = false;
            this.docType = docType;
            this.title = title;
            this.externalReference = externalReference;
            this.content = null;
        }

        DocumentationImpl(String docType, String content) {
            if (content == null) {
                throw new IllegalArgumentException("Content may not be null.");
            }
            this.isContainedContent = true;
            this.docType = docType;
            this.title = null;
            this.externalReference = null;
            this.content = content;
        }

        @Override
        public boolean isContainedContent() {
            return this.isContainedContent;
        }

        @Override
        public String getDocType() {
            return this.docType;
        }

        @Override
        public String getContent() {
            if (!this.isContainedContent) {
                throw new IllegalStateException("No contained content, use externally reference to access documentation content.");
            }
            return this.content;
        }

        @Override
        public String getTitle() {
            if (this.isContainedContent) {
                throw new IllegalStateException("Documentation with contained content has no title.");
            }
            return this.title;
        }

        @Override
        public String getExternalReference() {
            if (this.isContainedContent) {
                throw new IllegalStateException("Documentation with contained content has no external reference.");
            }
            return this.externalReference;
        }

        @Override
        public URI getExternalReferenceAsUri() throws URISyntaxException {
            if (this.isContainedContent) {
                throw new IllegalStateException("Documentation with contained content has no external reference.");
            }
            return this.externalReference != null ? new URI(this.externalReference) : null;
        }

        @Override
        public boolean isBuilt() {
            return this.isBuilt;
        }

        @Override
        public BuilderIssues getIssues() {
            return new BuilderIssues();
        }

        @Override
        public ThreddsMetadata.Documentation build() throws BuilderException {
            this.isBuilt = true;
            return this;
        }
    }
}

