/*
 * Decompiled with CFR 0.152.
 */
package com.alluretechnology.noheapdb;

public interface DataStore {
    public static final byte INACTIVE_RECORD = 0;
    public static final byte ACTIVE_RECORD = 1;
    public static final byte EMPTY_RECORD_TYPE = -1;
    public static final byte OBJ_RECORD_TYPE = 1;
    public static final byte TEXT_RECORD_TYPE = 2;
    public static final byte LONG_RECORD_TYPE = 3;
    public static final byte INT_RECORD_TYPE = 4;
    public static final byte DOUBLE_RECORD_TYPE = 5;
    public static final byte FLOAT_RECORD_TYPE = 6;
    public static final byte SHORT_RECORD_TYPE = 7;
    public static final byte CHAR_RECORD_TYPE = 8;
    public static final byte BYTEARRAY_RECORD_TYPE = 9;

    public long getRecordCount();

    public long getEmptyCount();

    public String getName();

    public String getFolder();

    public long getFilesize();

    public boolean putInteger(String var1, Integer var2);

    public Integer getInteger(String var1);

    public boolean putShort(String var1, Short var2);

    public Short getShort(String var1);

    public boolean putLong(String var1, Long var2);

    public Long getLong(String var1);

    public boolean putFloat(String var1, Float var2);

    public Float getFloat(String var1);

    public boolean putDouble(String var1, Double var2);

    public Double getDouble(String var1);

    public boolean putString(String var1, String var2);

    public String getString(String var1);

    public boolean putObject(String var1, Object var2);

    public Object getObject(String var1);

    public boolean putBytes(String var1, byte[] var2);

    public byte[] getBytes(String var1);

    public boolean putChar(String var1, char var2);

    public char getChar(String var1);

    public boolean remove(String var1);

    public Object iterateStart();

    public Object iterateNext();

    public void delete();

    public static enum Storage {
        IN_MEMORY,
        PERSISTED;

    }
}

