/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view;

import com.siggemannen.view.IStatusProgress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class StatusProgress
implements IStatusProgress {
    private IStatusProgress progress;
    private boolean cancel = false;
    private final List<IStatusProgress> listeners = new ArrayList<IStatusProgress>();
    private String initialStatus = null;

    StatusProgress() {
    }

    @Override
    public void status(String message, Optional<Exception> ex) {
        if (this.progress == null) {
            this.initialStatus = message;
            return;
        }
        this.progress.status(message, ex);
    }

    public void setProgress(IStatusProgress progress) {
        this.progress = progress;
        this.listeners.forEach(this.progress::addListener);
        if (this.initialStatus != null) {
            progress.status(this.initialStatus);
            this.initialStatus = null;
        }
    }

    @Override
    public void cancel() {
        if (this.progress == null) {
            this.cancel = true;
            return;
        }
        this.progress.cancel();
    }

    @Override
    public boolean isCancelled() {
        if (this.progress == null) {
            return this.cancel;
        }
        return this.progress.isCancelled();
    }

    @Override
    public void addListener(IStatusProgress listener) {
        if (this.progress == null) {
            this.listeners.add(listener);
            return;
        }
        this.progress.addListener(listener);
    }

    @Override
    public void removeListener(IStatusProgress listener) {
        if (this.progress == null) {
            this.listeners.remove(listener);
            return;
        }
        this.progress.removeListener(listener);
    }
}

