/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view;

import com.siggemannen.core.Tuple;
import com.siggemannen.view.SerializableTableModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TableModelEvent;

public abstract class ListTableElementModel<E, C>
extends SerializableTableModel
implements Serializable {
    protected List<E> dataVector;
    protected List<C> columnIdentifiers;

    public ListTableElementModel() {
        this(new ArrayList(), new ArrayList());
    }

    public ListTableElementModel(List<C> columnNames) {
        this.setDataVector(new ArrayList(), columnNames);
    }

    public ListTableElementModel(List<E> rows, List<C> columns) {
        this.dataVector = rows;
        this.columnIdentifiers = columns;
    }

    public void setColumns(List<C> columns) {
        this.columnIdentifiers = columns;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void setRows(List<E> rows) {
        this.dataVector = rows;
        this.fireTableChanged(new TableModelEvent(this));
    }

    public List<E> getDataVector() {
        return this.dataVector;
    }

    private static <E> List<E> nonNullVector(List<E> v) {
        return v != null ? v : new ArrayList();
    }

    public void setDataVector(List<E> dataVector, List<C> columnIdentifiers) {
        this.dataVector = ListTableElementModel.nonNullVector(dataVector);
        this.columnIdentifiers = columnIdentifiers == null ? new ArrayList() : columnIdentifiers;
        this.fireTableStructureChanged();
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent e) {
        this.fireTableChanged(e);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void insertRow(int row, E rowData) {
        this.dataVector.add(row, rowData);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRows(int row, Collection<E> rowData) {
        this.dataVector.addAll(row, rowData);
        this.fireTableRowsInserted(row, row + rowData.size());
    }

    public void insertRows(Collection<E> rowData) {
        if (rowData.isEmpty()) {
            return;
        }
        int index = this.dataVector.size();
        this.dataVector.addAll(rowData);
        this.fireTableRowsInserted(index, index + rowData.size() - 1);
    }

    public void insertAndReplaceRows(Collection<E> rowData) {
        this.dataVector.clear();
        this.dataVector.addAll(rowData);
        this.fireTableChanged(new TableModelEvent(this));
    }

    public void addRow(E rowData) {
        int index = this.dataVector.size();
        this.dataVector.add(rowData);
        this.fireTableRowsInserted(index, index);
    }

    public void removeRow(int row) {
        this.dataVector.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void removeRow(E object) {
        int indexOf = this.dataVector.indexOf(object);
        if (indexOf >= 0) {
            this.removeRow(indexOf);
        }
    }

    public void setColumnIdentifiers(C[] newIdentifiers) {
        this.setColumns(Arrays.asList(newIdentifiers));
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int column) {
        Object id = null;
        if (column < this.columnIdentifiers.size() && column >= 0) {
            id = this.columnIdentifiers.get(column);
        }
        return id == null ? super.getColumnName(column) : id.toString();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public abstract Object getValueAt(int var1, int var2);

    public void replaceRow(int row, E value) {
        this.dataVector.set(row, value);
        this.fireTableRowsUpdated(row, row);
    }

    public void replaceRows(List<Integer> rows, List<E> values) {
        ArrayList<Tuple<Integer, Tuple>> data = new ArrayList<Tuple<Integer, Tuple>>();
        int i = 0;
        while (i < rows.size()) {
            data.add(Tuple.of((Object)rows.get(i), values.get(i)));
            ++i;
        }
        if (rows.size() < 5) {
            this.rawReplace(data);
            return;
        }
    }

    public void replaceRows(List<Tuple<Integer, E>> rowvalues) {
        if (rowvalues.size() < 2) {
            this.rawReplace(rowvalues);
            return;
        }
        rowvalues.sort(Comparator.comparing(Tuple::first));
        int firstIndex = -2;
        int lastIndex = -2;
        int el = 0;
        while (el < rowvalues.size()) {
            Tuple<Integer, E> rowdata = rowvalues.get(el);
            int row = (Integer)rowdata.first();
            Object dataValue = rowdata.second();
            this.dataVector.set(row, dataValue);
            if (row != lastIndex + 1) {
                if (lastIndex >= 0) {
                    this.fireTableRowsUpdated(firstIndex, lastIndex);
                }
                firstIndex = row;
                lastIndex = row;
            } else {
                lastIndex = row;
            }
            ++el;
        }
        if (lastIndex >= 0) {
            this.fireTableRowsUpdated(firstIndex, lastIndex);
        }
    }

    private void rawReplace(List<Tuple<Integer, E>> rowsvalues) {
        int i = 0;
        while (i < rowsvalues.size()) {
            this.replaceRow((Integer)rowsvalues.get(i).first(), rowsvalues.get(i).second());
            ++i;
        }
    }

    public E getValueAt(int row) {
        return this.dataVector.get(row);
    }

    @Override
    public abstract void setValueAt(Object var1, int var2, int var3);
}

