/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.FastDateFormat;
import org.geotools.data.geojson.GeoJSONWriter;
import org.geotools.util.logging.Logging;

class DateParser {
    static final Logger LOGGER = Logging.getLogger(DateParser.class);
    static final List<FastDateFormat> DEFAULT_FAST_DATE_FORMATS = Arrays.asList(FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSX", (TimeZone)GeoJSONWriter.DEFAULT_TIME_ZONE), FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (TimeZone)GeoJSONWriter.DEFAULT_TIME_ZONE), FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssX", (TimeZone)GeoJSONWriter.DEFAULT_TIME_ZONE), FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss", (TimeZone)GeoJSONWriter.DEFAULT_TIME_ZONE), FastDateFormat.getInstance((String)"yyyy-MM-ddX", (TimeZone)GeoJSONWriter.DEFAULT_TIME_ZONE), FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)GeoJSONWriter.DEFAULT_TIME_ZONE));
    List<FastDateFormat> formats = DEFAULT_FAST_DATE_FORMATS;

    DateParser() {
    }

    public void setTimeZone(TimeZone tz) {
        this.formats = this.formats.stream().map(f -> FastDateFormat.getInstance((String)f.getPattern(), (TimeZone)tz)).collect(Collectors.toList());
    }

    public TimeZone getTimeZone() {
        return this.formats.get(0).getTimeZone();
    }

    public void setDatePattern(String ... pattern) {
        if (pattern == null || pattern.length == 0) {
            throw new IllegalArgumentException("Date patterns must be non null, and non empty");
        }
        this.formats = Arrays.stream(pattern).map(p -> FastDateFormat.getInstance((String)p, (TimeZone)this.getTimeZone())).collect(Collectors.toList());
    }

    public String[] getDatePatterns() {
        return (String[])this.formats.stream().map(f -> f.getPattern()).toArray(String[]::new);
    }

    public Date parse(String text) {
        for (FastDateFormat format : this.formats) {
            try {
                return format.parse(text);
            }
            catch (NumberFormatException | ParseException e) {
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, "Failed to parse " + text + " using " + format.getPattern(), e);
            }
        }
        return null;
    }
}

