/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.AutoCompleteComboBoxEditor;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.AutoCompleteDocument;
import org.jdesktop.swingx.autocomplete.ComboBoxAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

final class AutoComplete {
    private AutoComplete() {
    }

    static class FocusAdapter
    extends java.awt.event.FocusAdapter {
        private final AbstractAutoCompleteAdaptor adaptor;

        public FocusAdapter(AbstractAutoCompleteAdaptor adaptor) {
            this.adaptor = adaptor;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.adaptor.markEntireText();
        }
    }

    static class InputMap
    extends javax.swing.InputMap {
        private static final long serialVersionUID = 1L;

        InputMap() {
        }
    }

    static class KeyAdapter
    extends java.awt.event.KeyAdapter {
        private final JComboBox comboBox;

        public KeyAdapter(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isActionKey()) {
                return;
            }
            if (this.comboBox.isDisplayable() && !this.comboBox.isPopupVisible()) {
                int keyCode = keyEvent.getKeyCode();
                int modifiers = keyEvent.getModifiers();
                if (keyCode == 16 || keyCode == 17 || keyCode == 18) {
                    return;
                }
                if (keyCode == 10 || keyCode == 27) {
                    return;
                }
                if ((modifiers & 0x80) > 0 || (modifiers & 2) > 0) {
                    return;
                }
                this.comboBox.setPopupVisible(true);
            }
        }
    }

    static class PropertyChangeListener
    implements java.beans.PropertyChangeListener {
        private final JComboBox comboBox;

        public PropertyChangeListener(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof AutoCompleteComboBoxEditor) {
                return;
            }
            AutoCompleteComboBoxEditor acEditor = (AutoCompleteComboBoxEditor)evt.getOldValue();
            boolean strictMatching = false;
            if (acEditor.getEditorComponent() != null) {
                JTextComponent textComponent = (JTextComponent)acEditor.getEditorComponent();
                strictMatching = ((AutoCompleteDocument)textComponent.getDocument()).strictMatching;
                AutoCompleteDecorator.undecorate((JTextComponent)textComponent);
                KeyListener[] keyListenerArray = textComponent.getKeyListeners();
                int n = keyListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyListener l = keyListenerArray[n2];
                    if (l instanceof KeyAdapter) {
                        textComponent.removeKeyListener(l);
                        break;
                    }
                    ++n2;
                }
            }
            JTextComponent editorComponent = (JTextComponent)this.comboBox.getEditor().getEditorComponent();
            ComboBoxAdaptor adaptor = new ComboBoxAdaptor(this.comboBox);
            AutoCompleteDocument document = AutoCompleteDecorator.createAutoCompleteDocument((AbstractAutoCompleteAdaptor)adaptor, (boolean)strictMatching, (ObjectToStringConverter)acEditor.stringConverter, (Document)editorComponent.getDocument());
            AutoCompleteDecorator.decorate((JTextComponent)editorComponent, (AutoCompleteDocument)document, (AbstractAutoCompleteAdaptor)adaptor);
            editorComponent.addKeyListener(new KeyAdapter(this.comboBox));
            this.comboBox.setEditor(new AutoCompleteComboBoxEditor(this.comboBox.getEditor(), document.stringConverter));
        }
    }

    static class SelectionAction
    implements Action {
        private final Action delegate;

        public SelectionAction(Action delegate) {
            this.delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            JTextComponent textComponent = (JTextComponent)comboBox.getEditor().getEditorComponent();
            AutoCompleteDocument doc = (AutoCompleteDocument)textComponent.getDocument();
            doc.strictMatching = true;
            try {
                this.delegate.actionPerformed(e);
            }
            finally {
                doc.strictMatching = false;
            }
        }

        @Override
        public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
            this.delegate.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
            this.delegate.removePropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.delegate.putValue(key, value);
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this.delegate.setEnabled(b);
        }
    }
}

