/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tools;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.RunnerModel;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tools.ExternalTool;
import com.sigge.fileutils.FileUtils;
import com.siggemannen.view.Feedback;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ToolRunner {
    private final JFrame mainFrame;
    private static Logger LOGGER = LoggerFactory.getLogger(ToolRunner.class);
    private final RunnerModel model;
    private final IEditorManager editorManager;

    @Inject
    public ToolRunner(@Named(value="mainFrame") JFrame mainFrame, RunnerModel model, IEditorManager editorManager) {
        this.mainFrame = mainFrame;
        this.model = model;
        this.editorManager = editorManager;
    }

    public void runTool(ExternalTool tool) {
        String command = this.getCommandFromString(tool.getCommand());
        String args = this.getCommandFromString(tool.getArguments());
        try {
            new ProcessBuilder(command, args).start();
        }
        catch (IOException e) {
            LOGGER.error(String.format("Error occured when running command %s with args %s", command, args), (Throwable)e);
            JOptionPane.showMessageDialog(this.mainFrame, String.format("Error %s occured while executing tool %s", e.getMessage(), tool), String.format("Error running tool:%s", tool.getTitle()), 0, null);
        }
    }

    private String getCommandFromString(String str) {
        String command = str;
        TabContent tc = this.editorManager.currentTab();
        if (tc.isAFile()) {
            command = command.replace("${fullpath}", tc.getFileName());
            command = command.replace("${filename}", Paths.get(tc.getFileName(), new String[0]).getFileName().toString());
            command = command.replace("${dirpath}", Paths.get(tc.getFileName(), new String[0]).getParent().toString());
        }
        command = command.replace("${selected}", ((String)this.model.getSelectedScript().getValue()).isEmpty() ? "" : (CharSequence)this.model.getSelectedScript().getValue());
        if ((command = command.replace("${alltext}", ((RSyntaxTextArea)this.model.getCurrentEditor().getValue()).getText())).contains("${windowcontentfile}")) {
            try {
                File tempFile = File.createTempFile(tc.getTitle(), null);
                FileUtils.writeFile((File)tempFile, (String)tc.getEncoding(), (String)((RSyntaxTextArea)this.model.getCurrentEditor().getValue()).getText());
                command.replace("${windowcontentfile}", tempFile.getAbsolutePath());
            }
            catch (IOException e) {
                new Feedback().showError((Component)this.mainFrame, "Error creating command", "While creating temporary file, an error occured", (Exception)e);
                return null;
            }
        }
        return command;
    }
}

