/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tools;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.config.Config;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.core.Feedback;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.GsonFactory;
import com.sigge.filerunner.view.tools.ExternalTool;
import com.sigge.filerunner.view.tools.ExternalToolView;
import com.sigge.filerunner.view.tools.ITool;
import com.sigge.filerunner.view.tools.SQLTool;
import com.sigge.filerunner.view.tools.SQLToolView;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.APropertyListModel;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ListModelClass;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.JTextComponent;

public class ToolHandler {
    private static final String CHARSET_NAME = "UTF-8";
    private static final Gson GSON_WRITER = GsonFactory.forWriting();
    private static final FileFilter JSON_FILTER = new FileNameExtensionFilter("JSON (*.jsn)", "jsn");

    private ToolHandler() {
    }

    private static <T> void importToolsInternal(JFrame frame, List<T> fromJson, APropertyListModel<T> objectsModel) {
        int opt = 0;
        if (objectsModel.getSize() > 0) {
            opt = JOptionPane.showOptionDialog(frame, "Do you want to add or replace " + objectsModel.getSize() + (objectsModel.getSize() > 1 ? " elements" : " element") + "?", "Confirm import", 1, 3, null, new String[]{"Add", "Merge", "Replace all", "Cancel"}, "Add");
        }
        switch (opt) {
            case -1: 
            case 3: {
                return;
            }
            case 0: {
                for (T tool : fromJson) {
                    objectsModel.addElement(tool);
                }
                break;
            }
            case 1: {
                for (T tool : fromJson) {
                    if (objectsModel.getObject().contains(tool)) continue;
                    objectsModel.addElement(tool);
                }
                break;
            }
            case 2: {
                objectsModel.clearAndSetNew(fromJson);
                break;
            }
            default: {
                return;
            }
        }
        JOptionPane.showMessageDialog(frame, "Import successful");
    }

    public static void handleSQLTools(final JFrame frame) {
        final SQLToolView tv = new SQLToolView();
        final SQLToolHolder t = new SQLToolHolder();
        final SQLToolModel aModel = new SQLToolModel();
        final Config c = ConfigHandler.getConfig();
        t.setObjects(c.getSqlTools().stream().map(x -> new SQLTool((SQLTool)x)).collect(Collectors.toList()));
        APresenter<SQLToolHolder, SQLToolModel, SQLToolView> presenter = new APresenter<SQLToolHolder, SQLToolModel, SQLToolView>(aModel, tv){

            protected void initBindings() {
                this.bind(((SQLToolView)this.view).sqlTitleTextbox).to(aModel.title);
                this.bind((JTextComponent)((SQLToolView)this.view).sqlCommandTextArea).to(aModel.command);
                this.bind(((SQLToolView)this.view).runInTextModeCheckbox).to(aModel.textmode);
                this.bind((JList)((SQLToolView)this.view).toolList).to(aModel.objectsModel);
                this.bind(((SQLToolView)this.view).bindingTextField).to(aModel.binding);
                this.bind(((SQLToolView)this.view).showInMenuCheckbox).to(aModel.showInMenu);
                this.bind(((SQLToolView)this.view).typesList).toSelection(aModel.types, Arrays.asList(SQLObjectType.values()).stream().filter(f -> f != SQLObjectType.UNKNOWN).collect(Collectors.toList()));
                aModel.objectsModel.addSelectionChangeListener((item, index) -> this.enableButtons((SQLTool)item));
                this.addListenersToProperties(() -> sQLToolModel.objectsModel.currentElementUpdated(), new IProperty[]{aModel.title, aModel.command, aModel.textmode});
                JPopupMenu jp = new JPopupMenu();
                for (String key : ITool.TOOL_MAP.keySet()) {
                    JMenuItem jm = new JMenuItem(key);
                    jp.add(jm);
                    jm.addActionListener(z -> {
                        ((SQLToolView)this.view).sqlCommandTextArea.replaceSelection(ITool.TOOL_MAP.get(key));
                        jp.setVisible(false);
                    });
                }
                ((SQLToolView)this.view).sqlArgumentHelpButton.addActionListener(l -> jp.show(((SQLToolView)this.view).sqlArgumentHelpButton, 0, 0));
                ((SQLToolView)this.view).addButton.addActionListener(l -> {
                    SQLTool tool = new SQLTool();
                    tool.setTitle("Untitled");
                    ((SQLToolModel)this.model).objectsModel.addElement((Object)tool);
                    ((SQLToolModel)this.model).objectsModel.setSelectedItem((Object)tool);
                    SwingUtilities.invokeLater(() -> {
                        ((SQLToolView)this.view).sqlTitleTextbox.requestFocusInWindow();
                        ((SQLToolView)this.view).sqlTitleTextbox.selectAll();
                        ((SQLToolView)this.view).toolList.ensureIndexIsVisible(((SQLToolModel)this.model).objectsModel.getSize() - 1);
                    });
                });
                ((SQLToolView)this.view).duplicateButton.addActionListener(l -> {
                    SQLTool tool = new SQLTool((SQLTool)sQLToolModel.objectsModel.getSelectedItem());
                    tool.setTitle(String.valueOf(tool.getTitle()) + " (Copy)");
                    ((SQLToolModel)this.model).objectsModel.addElement((Object)tool);
                    ((SQLToolModel)this.model).objectsModel.setSelectedItem((Object)tool);
                    SwingUtilities.invokeLater(() -> {
                        ((SQLToolView)this.view).sqlTitleTextbox.requestFocusInWindow();
                        ((SQLToolView)this.view).sqlTitleTextbox.selectAll();
                        ((SQLToolView)this.view).toolList.ensureIndexIsVisible(((SQLToolModel)this.model).objectsModel.getSize() - 1);
                    });
                });
                ((SQLToolView)this.view).exportButton.addActionListener(l -> ToolHandler.exportTools("sqltools.jsn", sQLToolModel.objectsModel, (Component)this.view));
                ((SQLToolView)this.view).importButton.addActionListener(l -> this.importTools());
                ((SQLToolView)this.view).removeButton.addActionListener(l -> sQLToolModel.objectsModel.removeCurrentElement());
                ((SQLToolView)this.view).upButton.addActionListener(l -> sQLToolModel.objectsModel.moveCurrentElement(true));
                ((SQLToolView)this.view).downButton.addActionListener(l -> sQLToolModel.objectsModel.moveCurrentElement(false));
                ((SQLToolView)this.view).cancelButton.addActionListener(l -> tv.close());
                ((SQLToolView)this.view).okButton.addActionListener(l -> {
                    this.saveSettings();
                    tv.close();
                });
                ((SQLToolView)this.view).applyButton.addActionListener(l -> this.saveSettings());
                ((SQLToolView)this.view).advancedButton.addActionListener(l -> {
                    JPopupMenu menu = new JPopupMenu("Advanced menu");
                    if (((SQLToolModel)this.model).objectsModel.getSize() > 0) {
                        menu.add(ActionUtils.createAction("Export to clipboard", () -> {
                            StringWriter writer = new StringWriter();
                            GSON_WRITER.toJson((Object)((SQLToolModel)this.model).objectsModel.getObject(), (Appendable)writer);
                            ClipboardUtils.setStringDataToClipboard(writer.toString());
                            JOptionPane.showMessageDialog((Component)this.view, "Export successful");
                        }));
                    }
                    menu.add(ActionUtils.createAction("Import from clipboard", () -> {
                        String s = ClipboardUtils.getStringDataFromClipboard();
                        if (s == null || s.length() == 0) {
                            return;
                        }
                        try {
                            List fromJson = (List)GSON_WRITER.fromJson(s, new TypeToken<List<SQLTool>>(){}.getType());
                            if (fromJson.size() > 0) {
                                ToolHandler.importToolsInternal(frame, fromJson, ((SQLToolModel)this.model).objectsModel);
                            }
                        }
                        catch (JsonParseException ex) {
                            new Feedback().showMessage((JComponent)this.view, "The data in clipboard doesn't appear to be in valid SQL Tool data format");
                        }
                        catch (Exception ex) {
                            new com.siggemannen.view.Feedback().showError((Component)frame, "Error while parsing", "Error while clipboard into sql tools", ex);
                        }
                    }));
                    menu.show(((SQLToolView)this.view).advancedButton, 0, 0);
                });
            }

            private void importTools() {
                File f = FileUtils.openFile((Component)this.view, JSON_FILTER);
                if (f != null) {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), ToolHandler.CHARSET_NAME);){
                            List fromJson = (List)GSON_WRITER.fromJson((Reader)reader, new TypeToken<List<SQLTool>>(){}.getType());
                            ToolHandler.importToolsInternal(frame, fromJson, ((SQLToolModel)this.model).objectsModel);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        new com.siggemannen.view.Feedback().showError((Component)this.view, "Error importing tools", "File couldn't be read due to: " + e.getMessage(), e);
                    }
                }
            }

            private void saveSettings() {
                c.setSqlTools(t.getObjects());
                ConfigHandler.saveInBackground();
            }

            private void enableButtons(SQLTool item) {
                ToolHandler.enableControl(item != null, new JComponent[]{((SQLToolView)this.view).downButton, ((SQLToolView)this.view).upButton, ((SQLToolView)this.view).duplicateButton, ((SQLToolView)this.view).removeButton, ((SQLToolView)this.view).sqlTitleTextbox, ((SQLToolView)this.view).sqlCommandTextArea, ((SQLToolView)this.view).sqlArgumentHelpButton, ((SQLToolView)this.view).runInTextModeCheckbox, ((SQLToolView)this.view).showInMenuCheckbox, ((SQLToolView)this.view).typesList, ((SQLToolView)this.view).bindingTextField});
            }

            protected void afterObjectSet() {
                if (aModel.objectsModel.getSize() > 0) {
                    aModel.objectsModel.setSelectedItem(aModel.objectsModel.getElementAt(0));
                } else {
                    this.enableButtons((SQLTool)aModel.objectsModel.getSelectedItem());
                }
            }
        };
        presenter.setObject((Object)t);
        tv.editTools(frame);
    }

    private static void enableControl(boolean enable, JComponent ... components) {
        JComponent[] jComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent comp = jComponentArray[n2];
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setEditable(enable);
            } else {
                comp.setEnabled(enable);
            }
            ++n2;
        }
    }

    public static void addSnippet(SQLTool snippet) {
        Config c = ConfigHandler.getConfig();
        c.getSqlTools().add(snippet);
        ConfigHandler.saveInBackground();
    }

    public static void handleExternalTools(final JFrame mainFrame) {
        final ExternalToolView tv = new ExternalToolView();
        final ExternalToolHolder t = new ExternalToolHolder();
        final ExternalToolModel aModel = new ExternalToolModel();
        final Config c = ConfigHandler.getConfig();
        t.setObjects(c.getExternalTools().stream().map(x -> new ExternalTool((ExternalTool)x)).collect(Collectors.toList()));
        APresenter<ExternalToolHolder, ExternalToolModel, ExternalToolView> presenter = new APresenter<ExternalToolHolder, ExternalToolModel, ExternalToolView>(aModel, tv){

            protected void initBindings() {
                this.bind(((ExternalToolView)this.view).titleTextbox).to(aModel.title);
                this.bind(((ExternalToolView)this.view).commandTextBox).to(aModel.command);
                this.bind(((ExternalToolView)this.view).multiCommandCheckBox).to(aModel.multicommand);
                this.bind(((ExternalToolView)this.view).argumentTextBox).to(aModel.arguments);
                this.bind((JList)((ExternalToolView)this.view).toolList).to(aModel.objectsModel);
                this.bind(((ExternalToolView)this.view).bindingTextField).to(aModel.binding);
                ((ExternalToolView)this.view).browseCommandButton.addActionListener(l -> {
                    File f = FileUtils.openFile(((ExternalToolView)this.view).browseCommandButton, new FileFilter[0]);
                    if (f != null) {
                        ((ExternalToolView)this.view).commandTextBox.setText(String.valueOf(((ExternalToolView)this.view).commandTextBox.getText()) + f.getAbsolutePath());
                    }
                });
                aModel.objectsModel.addSelectionChangeListener((item, index) -> this.enableButtons((ExternalTool)item));
                this.addListenersToProperties(() -> externalToolModel.objectsModel.currentElementUpdated(), new IProperty[]{aModel.title, aModel.command, aModel.arguments, aModel.multicommand});
                JPopupMenu jp = new JPopupMenu();
                for (String key : ITool.TOOL_MAP.keySet()) {
                    JMenuItem jm = new JMenuItem(key);
                    jp.add(jm);
                    jm.addActionListener(z -> {
                        ((ExternalToolView)this.view).commandTextBox.replaceSelection(ITool.TOOL_MAP.get(key));
                        jp.setVisible(false);
                    });
                }
                ((ExternalToolView)this.view).argumentHelpButton.addActionListener(l -> jp.show(((ExternalToolView)this.view).argumentHelpButton, 0, 0));
                ((ExternalToolView)this.view).addButton.addActionListener(l -> {
                    ExternalTool tool = new ExternalTool();
                    tool.setTitle("Untitled");
                    ((ExternalToolModel)this.model).objectsModel.addElement((Object)tool);
                    ((ExternalToolModel)this.model).objectsModel.setSelectedItem((Object)tool);
                    SwingUtilities.invokeLater(() -> {
                        ((ExternalToolView)this.view).titleTextbox.requestFocusInWindow();
                        ((ExternalToolView)this.view).titleTextbox.selectAll();
                        ((ExternalToolView)this.view).toolList.ensureIndexIsVisible(((ExternalToolModel)this.model).objectsModel.getSize() - 1);
                    });
                });
                ((ExternalToolView)this.view).duplicateButton.addActionListener(l -> {
                    ExternalTool tool = new ExternalTool((ExternalTool)externalToolModel.objectsModel.getSelectedItem());
                    tool.setTitle(String.valueOf(tool.getTitle()) + " (Copy)");
                    ((ExternalToolModel)this.model).objectsModel.addElement((Object)tool);
                    ((ExternalToolModel)this.model).objectsModel.setSelectedItem((Object)tool);
                    SwingUtilities.invokeLater(() -> {
                        ((ExternalToolView)this.view).titleTextbox.requestFocusInWindow();
                        ((ExternalToolView)this.view).titleTextbox.selectAll();
                        ((ExternalToolView)this.view).toolList.ensureIndexIsVisible(((ExternalToolModel)this.model).objectsModel.getSize() - 1);
                    });
                });
                ((ExternalToolView)this.view).exportButton.addActionListener(l -> ToolHandler.exportTools("exttools.jsn", externalToolModel.objectsModel, (Component)this.view));
                ((ExternalToolView)this.view).importButton.addActionListener(l -> this.importTools());
                ((ExternalToolView)this.view).removeButton.addActionListener(l -> externalToolModel.objectsModel.removeCurrentElement());
                ((ExternalToolView)this.view).upButton.addActionListener(l -> externalToolModel.objectsModel.moveCurrentElement(true));
                ((ExternalToolView)this.view).downButton.addActionListener(l -> externalToolModel.objectsModel.moveCurrentElement(false));
                ((ExternalToolView)this.view).cancelButton.addActionListener(l -> tv.close());
                ((ExternalToolView)this.view).okButton.addActionListener(l -> {
                    this.saveSettings();
                    tv.close();
                });
                ((ExternalToolView)this.view).advancedButton.addActionListener(l -> {
                    JPopupMenu menu = new JPopupMenu("Advanced menu");
                    if (((ExternalToolModel)this.model).objectsModel.getSize() > 0) {
                        menu.add(ActionUtils.createAction("Export to clipboard", () -> {
                            StringWriter writer = new StringWriter();
                            GSON_WRITER.toJson((Object)((ExternalToolModel)this.model).objectsModel.getObject(), (Appendable)writer);
                            ClipboardUtils.setStringDataToClipboard(writer.toString());
                            JOptionPane.showMessageDialog((Component)this.view, "Export successful");
                        }));
                    }
                    menu.add(ActionUtils.createAction("Import from clipboard", () -> {
                        String s = ClipboardUtils.getStringDataFromClipboard();
                        if (s == null || s.length() == 0) {
                            return;
                        }
                        try {
                            List fromJson = (List)GSON_WRITER.fromJson(s, new TypeToken<List<ExternalTool>>(){}.getType());
                            if (fromJson.size() > 0) {
                                ToolHandler.importToolsInternal(mainFrame, fromJson, ((ExternalToolModel)this.model).objectsModel);
                            }
                        }
                        catch (JsonParseException ex) {
                            new Feedback().showMessage((JComponent)this.view, "The data in clipboard doesn't appear to be in valid SQL Tool data format");
                        }
                        catch (Exception ex) {
                            new com.siggemannen.view.Feedback().showError((Component)mainFrame, "Error while parsing", "Error while clipboard into sql tools", ex);
                        }
                    }));
                    menu.show(((ExternalToolView)this.view).advancedButton, 0, 0);
                });
                ((ExternalToolView)this.view).applyButton.addActionListener(l -> this.saveSettings());
            }

            private void importTools() {
                File f = FileUtils.openFile((Component)this.view, JSON_FILTER);
                if (f != null) {
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(f), ToolHandler.CHARSET_NAME);){
                            List fromJson = (List)GSON_WRITER.fromJson((Reader)reader, new TypeToken<List<ExternalTool>>(){}.getType());
                            ToolHandler.importToolsInternal(mainFrame, fromJson, ((ExternalToolModel)this.model).objectsModel);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        new com.siggemannen.view.Feedback().showError((Component)this.view, "Error importing tools", "File couldn't be read due to: " + e.getMessage(), e);
                    }
                }
            }

            private void saveSettings() {
                c.setExternalTools(t.getObjects());
                ConfigHandler.saveInBackground();
            }

            private void enableButtons(ExternalTool item) {
                ToolHandler.enableControl(item != null, new JComponent[]{((ExternalToolView)this.view).downButton, ((ExternalToolView)this.view).upButton, ((ExternalToolView)this.view).duplicateButton, ((ExternalToolView)this.view).removeButton, ((ExternalToolView)this.view).titleTextbox, ((ExternalToolView)this.view).commandTextBox, ((ExternalToolView)this.view).argumentHelpButton, ((ExternalToolView)this.view).browseCommandButton, ((ExternalToolView)this.view).argumentTextBox, ((ExternalToolView)this.view).multiCommandCheckBox, ((ExternalToolView)this.view).bindingTextField});
            }

            protected void afterObjectSet() {
                if (aModel.objectsModel.getSize() > 0) {
                    aModel.objectsModel.setSelectedItem(aModel.objectsModel.getElementAt(0));
                } else {
                    this.enableButtons((ExternalTool)aModel.objectsModel.getSelectedItem());
                }
            }
        };
        presenter.setObject((Object)t);
        tv.editTools(mainFrame);
    }

    private static <E> void exportTools(String tools, APropertyListModel<E> objectsModel, Component view) {
        File f;
        if (objectsModel.getSize() > 0 && (f = FileUtils.saveFile(view, tools, new FileNameExtensionFilter("JSON (*.jsn)", "jsn"))) != null) {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), CHARSET_NAME);){
                    GSON_WRITER.toJson((Object)objectsModel.getObject(), (Appendable)writer);
                    JOptionPane.showMessageDialog(view, "Export successful");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(view, "File couldn't be created due to: " + e.getMessage());
            }
        }
    }

    static class ExternalToolHolder
    extends ListModelClass<ExternalTool> {
        ExternalToolHolder() {
        }
    }

    static class ExternalToolModel
    extends AModel<ExternalToolHolder> {
        final IProperty<String> title = this.getProperty("current.title");
        final IProperty<String> command = this.getProperty("current.command");
        final IProperty<String> arguments = this.getProperty("current.arguments");
        final IProperty<Boolean> multicommand = this.getProperty("current.multicommand");
        final IProperty<String> binding = this.getProperty("current.binding");
        final AModel.BoundedListProperty<ExternalTool> objects = this.getBoundListProperty("objects", "current", new IProperty[]{this.title, this.command, this.arguments, this.multicommand, this.binding});
        final APropertyListModel<ExternalTool> objectsModel = new APropertyListModel(this.objects);

        ExternalToolModel() {
        }
    }

    static class SQLToolHolder
    extends ListModelClass<SQLTool> {
        SQLToolHolder() {
        }
    }

    static class SQLToolModel
    extends AModel<SQLToolHolder> {
        final IProperty<String> title = this.getProperty("current.title");
        final IProperty<String> command = this.getProperty("current.command");
        final IProperty<Boolean> textmode = this.getProperty("current.textmode");
        final IProperty<Boolean> showInMenu = this.getProperty("current.showInMenu");
        final IListProperty<SQLObjectType> types = this.getListProperty("current.types");
        final IProperty<String> binding = this.getProperty("current.binding");
        final AModel.BoundedListProperty<SQLTool> objects = this.getBoundListProperty("objects", "current", new IProperty[]{this.title, this.command, this.textmode, this.types, this.binding, this.showInMenu});
        final APropertyListModel<SQLTool> objectsModel = new APropertyListModel(this.objects);

        SQLToolModel() {
        }
    }
}

