/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.sigge.filerunner.core.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class TabContent {
    private String title = null;
    private String fileName = null;
    private String content = "";
    private String encoding = null;
    protected transient int id;
    private final transient Map<String, Object> state;
    private String contentType;

    public TabContent() {
        this("", "");
    }

    public TabContent(String title) {
        this(title, "");
    }

    public TabContent(String title, String content) {
        this(title, content, null);
    }

    public TabContent(String title, String content, String contentType) {
        this.contentType = contentType;
        this.title = title;
        this.content = content;
        this.state = new HashMap<String, Object>();
    }

    public TabContent(String title, String fileName, String content, String encoding) {
        this(title, fileName, content, encoding, null);
    }

    public TabContent(String title, String fileName, String content, String encoding, String contentType) {
        this.fileName = fileName;
        this.title = title;
        this.content = content;
        this.encoding = encoding;
        this.contentType = contentType;
        this.state = new HashMap<String, Object>();
    }

    public void assignId(int id) {
        this.id = id;
    }

    public TabContent withoutFileContent() {
        return new TabContent(this.title, this.fileName, this.isAFile() ? "" : this.content, this.encoding, this.contentType);
    }

    public boolean isAFile() {
        return StringUtils.isNotEmpty(this.fileName);
    }

    public String getTitle() {
        return this.title;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TabContent)) {
            return false;
        }
        TabContent other = (TabContent)obj;
        return this.id == other.id;
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public String toString() {
        return "TabContent[" + this.title + "@" + this.getId() + "]";
    }

    public Integer getId() {
        return this.id;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStateValue(String key, Object value) {
        this.state.put(key, value);
    }

    public Object getStateValue(String key) {
        return this.state.get(key);
    }

    public void copyStateTo(TabContent tc) {
        for (String key : this.state.keySet()) {
            tc.setStateValue(key, this.state.get(key));
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

