/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.search;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.view.DefaultSearchListener;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.search.FindNextAction;
import com.sigge.filerunner.view.search.GoToLineAction;
import com.sigge.filerunner.view.search.ShowFindDialogAction;
import com.sigge.filerunner.view.search.ShowReplaceDialogAction;
import com.siggemannen.core.Tuple;
import java.awt.Frame;
import javax.swing.JFrame;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rtextarea.SearchContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchModule
extends AbstractModule {
    public static final String MESSAGE_TAG = "searches";
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchModule.class);

    protected void configure() {
        LOGGER.info("start bind");
        Multibinder menuActions = Multibinder.newSetBinder((Binder)this.binder(), FileRunnerAction.class);
        menuActions.addBinding().to(GoToLineAction.class);
        menuActions.addBinding().to(ShowFindDialogAction.class);
        menuActions.addBinding().to(ShowReplaceDialogAction.class);
        menuActions.addBinding().to(FindNextAction.class);
        LOGGER.info("finish bind");
    }

    @Provides
    @Singleton
    Tuple<FindDialog, ReplaceDialog> createFindDialog(@Named(value="mainFrame") JFrame mainFrame, IEditorManager manager, IStatusUpdater updater) {
        DefaultSearchListener searchListener = new DefaultSearchListener(manager, updater, MESSAGE_TAG);
        FindDialog findDialog = new FindDialog((Frame)mainFrame, (SearchListener)searchListener);
        SearchContext context = findDialog.getSearchContext();
        ReplaceDialog replaceDialog = new ReplaceDialog((Frame)mainFrame, (SearchListener)searchListener);
        replaceDialog.setSearchContext(context);
        return Tuple.of((Object)findDialog, (Object)replaceDialog);
    }
}

