/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IStatusUpdater;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;

@Singleton
public class GoToLineAction
implements FileRunnerAction {
    private final JFrame mainFrame;
    private final IEditorManager manager;
    private final IStatusUpdater updater;
    private final FindDialog findDialog;
    private final ReplaceDialog replaceDialog;

    @Inject
    GoToLineAction(@Named(value="mainFrame") JFrame mainFrame, IEditorManager manager, IStatusUpdater updater, Tuple<FindDialog, ReplaceDialog> dialogs) {
        this.mainFrame = mainFrame;
        this.manager = manager;
        this.updater = updater;
        this.findDialog = (FindDialog)dialogs.first();
        this.replaceDialog = (ReplaceDialog)dialogs.second();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.findDialog.isVisible()) {
            this.findDialog.setVisible(false);
        }
        if (this.replaceDialog.isVisible()) {
            this.replaceDialog.setVisible(false);
        }
        this.updater.removeMessage("searches");
        GoToDialog dialog = new GoToDialog((Frame)this.mainFrame);
        dialog.setMaxLineNumberAllowed(this.manager.getCurrentTab().getLineCount());
        dialog.setVisible(true);
        int line = dialog.getLineNumber();
        if (line > 0) {
            try {
                this.manager.getCurrentTab().setCaretPosition(this.manager.getCurrentTab().getLineStartOffset(line - 1));
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.manager.getCurrentTab());
            }
        }
    }

    @Override
    public String id() {
        return "goto-line";
    }

    @Override
    public KeyStroke getDefaultKeyStroke() {
        return KeyStroke.getKeyStroke(71, this.mainFrame.getToolkit().getMenuShortcutKeyMask());
    }
}

