/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.runners;

import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.ProgressReportedAdaptor;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.sql.DatabaseManager;
import com.sigge.filerunner.sql.RunContext;
import com.sigge.filerunner.sql.Server;
import com.sigge.filerunner.sql.ServerDatabase;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.TimerLabel;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.InlineResultView;
import com.sigge.filerunner.view.results.ResultSetPresenter;
import com.sigge.filerunner.view.results.ResultTableHandler;
import com.sigge.filerunner.view.runners.RecurringRunState;
import com.sigge.filerunner.view.runners.SQLScriptReporter;
import com.sigge.filerunner.view.tabs.TabContent;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.ThreadUtils;
import com.siggemannen.functional.throwing.ThrowingRunnable;
import com.siggemannen.functional.throwing.ThrowingSupplier;
import com.siggemannen.view.IBackgroundExecutorHandler;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.RootPaneContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLScriptState
extends ProgressReportedAdaptor {
    private static final ImageIcon CANCEL_2_ICON = IconUtils.getSmallIcon("stop2.png");
    private static final ImageIcon CANCEL_1_ICON = IconUtils.getSmallIcon("stop.png");
    private static final ThrowingRunnable DUMMY = () -> System.out.println("Dummy");
    private boolean running;
    private final TimerLabel tl = new TimerLabel("00:00:00");
    private boolean hasRun;
    private boolean lastErrorErrors;
    private int lastRunResultsSets;
    private int lastRunRows;
    private final Action cancelAction;
    private boolean cancelling;
    private Statement statement = null;
    private SQLOptions options;
    private final SQLScriptReporter reporter;
    private RunContext context;
    private final TabContent tabContent;
    private final ResultSetPresenter resultSetPresenter;
    private boolean toggled;
    private boolean closed;
    private IScriptRunner scriptRunner;
    private List<Server> servers;
    private Runnable hardCancel = DUMMY;
    private RecurringRunState recurringState = null;
    private final CancelQueryAction cancelRecurringAction;
    private final Logger LOGGER = LoggerFactory.getLogger(SQLScriptState.class);
    private JFrame mainFrame;

    public SQLScriptState(SQLScriptReporter reporter, TabContent tc, ResultTableHandler handler, JFrame mainFrame, Map<String, IResultSetTable> repository) {
        this.reporter = reporter;
        this.tabContent = tc;
        this.mainFrame = mainFrame;
        this.resultSetPresenter = new ResultSetPresenter(new InlineResultView(), reporter.getSwitcher(), handler, repository);
        this.cancelAction = new CancelQueryAction("Cancel...", mainFrame, CANCEL_1_ICON, false);
        this.cancelRecurringAction = new CancelQueryAction("Stop...", mainFrame, CANCEL_2_ICON, true);
    }

    public void init() {
        this.lastErrorErrors = false;
        this.lastRunResultsSets = 0;
        this.lastRunRows = 0;
    }

    @Override
    public void reportStarted(SQLOptions options) {
        this.options = options;
        this.cancelling = false;
        this.reporter.reportStarted(this);
    }

    @Override
    public void reportScriptStarted(String command, Statement s) {
        this.reporter.reportScriptStarted(this, command, this.options, s);
    }

    @Override
    public void reportFinished() {
        this.reporter.reportFinished(this);
        this.cancelling = false;
        this.hardCancel = DUMMY;
    }

    @Override
    public void reportScriptFailure(String command, Statement s, Exception e, boolean result) {
        this.reporter.reportScriptFailure(this, command, s, e, result);
    }

    @Override
    public void reportServerStarted() {
        this.context.setServerStarted(LocalDateTime.now());
        this.reporter.reportServerStarted(this);
    }

    @Override
    public void reportServerFinished() {
        this.context.setServerFinished(LocalDateTime.now());
        this.reporter.reportServerFinished(this);
    }

    @Override
    public void reportCancelled() {
        this.reporter.reportCancelled(this);
    }

    @Override
    public void reportScriptFinished(String command, Statement s, boolean result) {
        this.reporter.reportScriptFinished(this, command, s, result);
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        if (this.running == running) {
            return;
        }
        if (running) {
            this.tl.start();
        } else {
            this.tl.end();
            if (this.running) {
                this.hasRun = true;
            }
        }
        this.running = running;
    }

    public List<ServerDatabase> getCurrentDatabases() {
        if (this.servers != null) {
            return this.servers.stream().flatMap(s -> s.getDatabases().stream().map(q -> DatabaseManager.findDb(new ServerDatabase(s.getDatabase(), (String)q).getId()))).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (this.scriptRunner != null) {
            ServerDatabase serverDatabase;
            if (this.isRunning() && this.context != null && this.context.getDatabase() != null) {
                serverDatabase = new ServerDatabase(this.scriptRunner.getDatabase(), StringUtils.isBlank(this.context.getDatabase(), this.context.getDatabase()));
                String lookupId = serverDatabase.getId();
                ServerDatabase sd = DatabaseManager.findDb(lookupId);
                if (sd == null) {
                    this.LOGGER.debug("Creating db from: {}, lookup: {}", (Object)serverDatabase, (Object)lookupId);
                    sd = DatabaseManager.createDb(serverDatabase);
                }
                if (sd != null) {
                    if (sd.getDatabase() == null) {
                        this.LOGGER.error("Something went wrong here, db is null");
                    }
                    return Arrays.asList(sd);
                }
            }
            try {
                serverDatabase = new ServerDatabase(this.scriptRunner.getDatabase(), this.scriptRunner.getCurrentDatabase());
                ServerDatabase sd = DatabaseManager.findDb(serverDatabase.getId());
                if (sd == null) {
                    sd = DatabaseManager.createDb(serverDatabase);
                    this.LOGGER.info("Created database: {} from {}, {}", new Object[]{sd, serverDatabase, serverDatabase.getId()});
                }
                if (sd != null) {
                    return Arrays.asList(sd);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getSafeDatabase(IScriptRunner runner) {
        try {
            return this.scriptRunner.getCurrentDatabase();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean isLastErrorErrors() {
        return this.lastErrorErrors;
    }

    public void setLastErrorErrors(boolean lastErrorErrors) {
        this.lastErrorErrors = lastErrorErrors;
    }

    public int getLastRunResultsSets() {
        return this.lastRunResultsSets;
    }

    public void setLastRunResultsSets(int lastRunResultsSets) {
        this.lastRunResultsSets = lastRunResultsSets;
    }

    public int getLastRunRows() {
        return this.lastRunRows;
    }

    public void setLastRunRows(int lastRunRows) {
        this.lastRunRows = lastRunRows;
    }

    public boolean isHasRun() {
        return this.hasRun;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public boolean isCancelling() {
        return this.cancelling;
    }

    public RunContext getRunContext() {
        return this.context;
    }

    @Override
    public void setRunContext(RunContext context) {
        if (context != null && this.context != null && this.context.getServerStarted() != null) {
            context.setServerStarted(this.context.getServerStarted());
        }
        this.context = context;
    }

    public TabContent getTabContent() {
        return this.tabContent;
    }

    public ResultSetPresenter getResultSetPresenter() {
        return this.resultSetPresenter;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean toggled) {
        this.toggled = toggled;
    }

    public IScriptRunner getScriptRunner() {
        return this.scriptRunner;
    }

    public void setScriptRunner(IScriptRunner scriptRunner) {
        this.scriptRunner = scriptRunner;
    }

    public String toString() {
        return String.format(String.valueOf(super.toString()) + ", running %s, toggled:%s, tabContent: %s, hasRun: %s, lastError:%s, lastRunResultSets:%d, lastRunRows:%d, scriptRunner: %s", this.running, this.toggled, this.tabContent, this.hasRun, this.lastErrorErrors, this.lastRunResultsSets, this.lastRunRows, this.scriptRunner);
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public void setServers(List<Server> servers) {
        this.servers = servers != null && servers.size() == 0 ? null : servers;
    }

    public void setHardCancel(Runnable hardCancel) {
        this.hardCancel = hardCancel;
    }

    public Action getCancelAction() {
        return this.cancelAction;
    }

    public TimerLabel getTimerLabel() {
        return this.tl;
    }

    public RecurringRunState getRecurringState() {
        return this.recurringState;
    }

    public void setRecurringState(RecurringRunState rrr) {
        this.recurringState = rrr;
    }

    public CancelQueryAction getCancelRecurringAction() {
        return this.cancelRecurringAction;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    private final class CancelQueryAction
    extends AbstractAction {
        private final JFrame mainFrame;
        private final boolean recurring;

        private CancelQueryAction(String name, JFrame mainFrame, ImageIcon icon, boolean recurring) {
            super(name);
            this.mainFrame = mainFrame;
            this.recurring = recurring;
            this.putValue("SmallIcon", icon);
        }

        @Override
        public void setEnabled(boolean newValue) {
            if (!newValue) {
                try {
                    throw new RuntimeException("Error: incorrect set of cancel query action");
                }
                catch (Exception ex) {
                    SQLScriptState.this.LOGGER.error("For some reason we cancel cancel action", (Throwable)ex);
                    return;
                }
            }
            super.setEnabled(newValue);
        }

        @Override
        public void putValue(String key, Object newValue) {
            if (key.equals("enabled") && Boolean.FALSE.equals(newValue)) {
                try {
                    throw new RuntimeException("Error: incorrect set of cancel query action");
                }
                catch (Exception ex) {
                    SQLScriptState.this.LOGGER.error("For some reason we cancel cancel action", (Throwable)ex);
                    return;
                }
            }
            super.putValue(key, newValue);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block13: {
                int val;
                if (SQLScriptState.this.context != null && LocalDateTime.now().minusMinutes(3L).isAfter(SQLScriptState.this.context.getServerStarted()) && (val = JOptionPane.showConfirmDialog(this.mainFrame, "Do you really want to cancel this query?", "Confirm cancellation", 0)) != 0) {
                    return;
                }
                boolean alreadyCancelled = false;
                SQLScriptState.this.recurringState = null;
                SQLScriptState.this.options.cancel();
                if (SQLScriptState.this.cancelling) {
                    alreadyCancelled = true;
                }
                if (SQLScriptState.this.statement == null || SQLScriptState.this.servers == null && SQLScriptState.this.scriptRunner == null) {
                    if (SQLScriptState.this.cancelling) {
                        ThreadUtils.sleep((int)100);
                    }
                    if (!SQLScriptState.this.cancelling) {
                        SQLScriptState.this.cancelling = true;
                        return;
                    }
                }
                SQLScriptState.this.cancelling = true;
                boolean cance = alreadyCancelled;
                ThrowingSupplier supplier = () -> {
                    try {
                        if (cance && SQLScriptState.this.scriptRunner.isAlive() && SQLScriptState.this.cancelling) {
                            return true;
                        }
                        return false;
                    }
                    catch (Exception ex) {
                        return false;
                    }
                };
                ValueHolder consumer = new ValueHolder();
                UIOptionSupplier opt = (UIOptionSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(supplier, cb -> {
                    SQLScriptState.this.LOGGER.debug("cance: {}, ex: {}", (Object)cance, cb);
                    if (!cb.booleanValue()) {
                        return;
                    }
                    int res = JOptionPane.showOptionDialog(this.mainFrame, "The last connection cancel didn't seem to work. Do you want to try to force the connection close?", "Trying to cancel connection", 0, 2, null, new String[]{"Yes, try to force cancel connection and reset the current one", "No, let's wait a bit longer and see"}, null);
                    if (res == 0 && SQLScriptState.this.cancelling) {
                        this.closeAll();
                    }
                }).mainPanel((RootPaneContainer)this.mainFrame)).title("Trying to cancel", "Checking if connection is cancellable", "Force-close connection")).backgroundHandler(consumer, "Wait in the background")).build();
                UIBackgroundRunner.execute((UIOptionSupplier)opt);
                if (consumer.getOptionalValue().map(IBackgroundExecutorHandler::isInBackground).orElse(false).booleanValue()) {
                    return;
                }
                try {
                    if (SQLScriptState.this.statement != null && !SQLScriptState.this.statement.isClosed()) {
                        SQLScriptState.this.LOGGER.debug("Cancelling statement");
                        SQLScriptState.this.statement.cancel();
                        if (!alreadyCancelled) break block13;
                        try {
                            new BackgroundRunner(this::closeConnection).execute();
                            SQLScriptState.this.hardCancel.run();
                        }
                        catch (Exception exxx) {
                            SQLScriptState.this.LOGGER.error("Error while hard cancelling", (Object)e);
                        }
                        SQLScriptState.this.LOGGER.info("Hard cancel failed");
                        break block13;
                    }
                    if (alreadyCancelled) {
                        SQLScriptState.this.LOGGER.debug("close all #2");
                        this.closeAll();
                    }
                }
                catch (SQLException e1) {
                    SQLScriptState.this.LOGGER.error("cancel failed", (Throwable)e1);
                }
            }
            if (this.recurring) {
                SQLScriptState.this.reporter.repaintInner(SQLScriptState.this.tabContent, SQLScriptState.this);
            }
        }

        private void closeAll() {
            this.closeConnection();
            SQLScriptState.this.LOGGER.debug("Hard cancel");
            try {
                SQLScriptState.this.hardCancel.run();
            }
            catch (Exception e) {
                SQLScriptState.this.LOGGER.error("Error while hard cancelling", (Throwable)e);
            }
        }

        private void closeConnection() {
            try {
                if (SQLScriptState.this.statement != null) {
                    SQLScriptState.this.statement.getConnection().close();
                } else {
                    SQLScriptState.this.scriptRunner.closeConnection();
                }
            }
            catch (Exception exx) {
                exx.printStackTrace();
            }
        }
    }
}

