/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers;

import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSVTransformer
implements ICSVTransformer {
    @Override
    public String transform(String csv, Optional<IResultSetTable> table, TransformContext context) {
        List<String> s;
        if (!table.isPresent()) {
            s = Arrays.asList(csv.split("[\n\r]"));
        } else {
            IResultSetTable model = table.get();
            s = new ArrayList<String>();
            int i = 0;
            while (i < model.getRowCount()) {
                s.add(this.stringify(model.getValueForDisplay(i, 0)));
                ++i;
            }
        }
        StringBuilder sb = new StringBuilder("");
        int cnt = 0;
        for (String str : s) {
            if (str.length() == 0) continue;
            if (cnt > 0) {
                sb.append(", ");
            }
            ++cnt;
            sb.append(this.getStringFromLine(str));
        }
        return sb.toString();
    }

    private String stringify(Object x) {
        if (x == null) {
            return "NULL";
        }
        return x.toString();
    }

    @Override
    public int supports(String csv, Optional<IResultSetTable> table, int lines, int cols) {
        return lines > 0 || table.filter(p -> p.getColumnCount() == 1 && p.getRowCount() > 1).isPresent() ? 1 : 0;
    }

    private String getStringFromLine(String str) {
        Pattern p;
        Matcher m;
        if (str.length() == 0 || !str.matches(".*[^\\s].*")) {
            return str;
        }
        if (str.contains("]")) {
            String strex = str.replace("]]", "\n");
            Pattern p2 = Pattern.compile("^\\s*,?\\s*(\\[.*\\])\\s*");
            Matcher m2 = p2.matcher(strex);
            if (m2.matches()) {
                return m2.group(1).replace("\n", "]]");
            }
        }
        if ((m = (p = Pattern.compile("^\\s*,?\\s*([^\\s]+)\\s*.*$")).matcher(str)).matches()) {
            return m.group(1);
        }
        return str;
    }
}

