/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.rsyntaxtextarea.DefaultKeyTypedActionWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.DeleteNextCharWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.DeletePrevCharWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.EndLineAction;
import com.sigge.filerunner.view.rsyntaxtextarea.InsertBreakActionWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.InsertTabActionWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.NextVisualPositionActionWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.rsyntaxtextarea.SelectWordActionWithNewLines;
import com.sigge.filerunner.view.rsyntaxtextarea.UpperSelectionCaseActionFixed;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StringContent;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextPaneUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextPaneUtil.class);
    private static final AbstractAction altAction = TextPaneUtil.createAltAction();
    private static final AbstractAction menuKeyAction = TextPaneUtil.createMenuKeyAction();

    public static void addText(JTextComponent pane, String text) {
        TextPaneUtil.addText(pane, text, new SimpleAttributeSet());
    }

    private static AbstractAction createMenuKeyAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof RSyntaxTextArea) {
                    RSyntaxTextArea rx = (RSyntaxTextArea)e.getSource();
                    JPopupMenu popup = rx.getPopupMenu();
                    try {
                        Rectangle r = rx.modelToView(rx.getCaretPosition());
                        popup.show((Component)rx, r.x, r.y + r.height);
                    }
                    catch (BadLocationException ex) {
                        popup.show((Component)rx, 0, 0);
                    }
                }
            }
        };
    }

    private static AbstractAction createAltAction() {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof RTextArea) {
                    SwingUtilities.invokeLater(() -> {
                        boolean bl = ((RTextArea)e.getSource()).requestFocusInWindow();
                    });
                }
            }
        };
    }

    public static void addText(JTextComponent pane, String text, AttributeSet set) {
        Document doc = pane.getDocument();
        try {
            doc.insertString(doc.getLength(), String.valueOf(text) + "\r\n", set);
            if (pane instanceof RTextArea) {
                ((RTextArea)pane).discardAllEdits();
            }
        }
        catch (Exception e) {
            LOGGER.error("error while adding error text", (Throwable)e);
        }
    }

    public static void disableUndo(RTextArea ra) {
        try {
            TextPaneUtil.setValue(AbstractDocument.class, ra.getDocument(), "data", new StringContent());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static <E, Y> E getValue(Y object, String value) throws Exception {
        Field f = object.getClass().getDeclaredField(value);
        f.setAccessible(true);
        return (E)f.get(object);
    }

    private static void setValue(Object object, String value, Object val) throws Exception {
        Field f = object.getClass().getDeclaredField(value);
        f.setAccessible(true);
        f.set(object, val);
    }

    private static void setValue(Class clazz, Object object, String value, Object val) throws Exception {
        Field f = clazz.getDeclaredField(value);
        f.setAccessible(true);
        f.set(object, val);
    }

    public static void configureSyntaxTextArea(final RSyntaxTextArea rx) {
        if (rx.getTabSize() != 8) {
            rx.setTabSize(8);
        }
        rx.setAutoIndentEnabled(true);
        rx.setHighlightCurrentLine(false);
        rx.setEOLMarkersVisible(false);
        rx.setShowMatchedBracketPopup(false);
        rx.getSyntaxScheme().setStyle(17, new Style(null));
        rx.getInputMap(0).put(KeyStroke.getKeyStroke(18, 0, true), "ALTKEY");
        rx.getActionMap().put("ALTKEY", altAction);
        rx.getInputMap(0).put(KeyStroke.getKeyStroke(525, 0), "showPopupViaKeyboard");
        rx.getActionMap().put("showPopupViaKeyboard", menuKeyAction);
        RTextScrollPane rTextScrollPane = (RTextScrollPane)rx.getParent().getParent();
        rTextScrollPane.setHorizontalScrollBarPolicy(32);
        rTextScrollPane.setVerticalScrollBarPolicy(22);
        rTextScrollPane.getHorizontalScrollBar().getInputMap().put(KeyStroke.getKeyStroke(112, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "none");
        rTextScrollPane.getHorizontalScrollBar().getInputMap().put(KeyStroke.getKeyStroke(112, 0), "none");
        rTextScrollPane.setLineNumbersEnabled(true);
        LineNumberList lineNumberComp = TextPaneUtil.getLineNumberList((RTextArea)rx);
        if (lineNumberComp != null) {
            lineNumberComp.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int pos;
                    if (e.getClickCount() >= 2 && e.getButton() == 1 && (pos = rx.viewToModel(new Point(0, e.getY()))) >= 0) {
                        rx.select(rx.getLineStartOffsetOfCurrentLine(), rx.getLineEndOffsetOfCurrentLine() - 1);
                    }
                }
            });
        }
        rx.getActionMap().put("insert-break", (Action)((Object)new InsertBreakActionWithNewLines()));
        rx.getActionMap().put("caret-end-line", (Action)((Object)new EndLineAction(false)));
        rx.getActionMap().put("selection-end-line", (Action)((Object)new EndLineAction(true)));
        rx.getActionMap().put("delete-previous", (Action)((Object)new DeletePrevCharWithNewLines()));
        rx.getActionMap().put("delete-next", (Action)((Object)new DeleteNextCharWithNewLines()));
        rx.getActionMap().put("caret-backward", (Action)((Object)new NextVisualPositionActionWithNewLines("caret-backward", false, 7)));
        rx.getActionMap().put("caret-forward", (Action)((Object)new NextVisualPositionActionWithNewLines("caret-forward", false, 3)));
        rx.getActionMap().put("selection-backward", (Action)((Object)new NextVisualPositionActionWithNewLines("selection-backward", true, 7)));
        rx.getActionMap().put("selection-forward", (Action)((Object)new NextVisualPositionActionWithNewLines("selection-forward", true, 3)));
        rx.getActionMap().put("select-word", (Action)((Object)new SelectWordActionWithNewLines()));
        rx.getActionMap().put("insert-tab", (Action)((Object)new InsertTabActionWithNewLines()));
        rx.getActionMap().put("selection-down", (Action)((Object)new NextVisualPositionActionWithNewLines("selection-down", true, 5)));
        rx.getActionMap().put("RTA.UpperCaseAction", (Action)((Object)new UpperSelectionCaseActionFixed()));
        rx.getInputMap().put(KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40), "RTA.UpperCaseAction");
        rx.getInputMap().put(KeyStroke.getKeyStroke(37, 8), "RTA.PrevOccurrenceAction");
        rx.getInputMap().put(KeyStroke.getKeyStroke(39, 8), "RTA.NextOccurrenceAction");
        rx.getInputMap().put(KeyStroke.getKeyStroke(86, 192), "none");
        rx.getInputMap().put(KeyStroke.getKeyStroke(72, 192), "RTA.PasteHistoryAction");
        rx.getInputMap().put(KeyStroke.getKeyStroke(90, 192), "RTA.RedoAction");
        Keymap map = rx.getKeymap();
        map.setDefaultAction((Action)((Object)new DefaultKeyTypedActionWithNewLines()));
    }

    public static LineNumberList getLineNumberList(RTextArea textarea) {
        Gutter g = RSyntaxUtilities.getGutter((RTextArea)textarea);
        if (g != null) {
            int i = 0;
            while (i < g.getComponentCount()) {
                if (g.getComponent(i) instanceof LineNumberList) {
                    return (LineNumberList)g.getComponent(i);
                }
                ++i;
            }
        }
        return null;
    }

    public static IconRowHeader getIconRowHeader(RTextArea textarea) {
        Gutter g = RSyntaxUtilities.getGutter((RTextArea)textarea);
        IconRowHeader ir = null;
        if (g != null) {
            Component cp = null;
            int i = 0;
            while (i < g.getComponentCount()) {
                cp = g.getComponent(i);
                if (cp instanceof IconRowHeader) {
                    ir = (IconRowHeader)cp;
                    break;
                }
                ++i;
            }
        }
        return ir;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDotInBetweenLineBreak(RTextArea textArea) {
        Caret caret = textArea.getCaret();
        int dot = caret.getDot();
        Document d = textArea.getDocument();
        if (textArea.getCaretOffsetFromLineStart() == 0) {
            return false;
        }
        if (textArea.getCaretOffsetFromLineStart() == 1) {
            try {
                if (!TextPaneUtil.isDotOnNewLine(dot, d)) return false;
                return true;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        } else {
            try {
                if (!TextPaneUtil.isDotOnNewLine(dot, d)) return false;
                return true;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isDotOnR(int dot, Document d) {
        try {
            String text = d.getText(dot, 1);
            return "\r".equals(text);
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public static void fixDotAndMarks(RTextArea sta) {
        Caret c = sta.getCaret();
        int dot = c.getDot();
        int mark = c.getMark();
        if (dot > 0 && TextPaneUtil.isDotOnR(dot - 1, sta.getDocument())) {
            if (dot != mark) {
                c.moveDot(dot - 1);
            } else {
                c.setDot(dot - 1);
            }
        }
        if ((dot = c.getDot()) != (mark = c.getMark()) && TextPaneUtil.isDotOnR(mark - 1, sta.getDocument())) {
            c.setDot(Math.min(dot, mark - 1));
            c.moveDot(Math.max(dot, mark - 1));
        }
    }

    public static boolean isDotOnNewLine(int dot, Document d) throws BadLocationException {
        String text = d.getText(dot, 1);
        return text.matches("(?s)\r|\n");
    }

    public static String getTextOnLine(Document doc, TextLineStartEnd textLine) throws BadLocationException {
        return doc.getText(textLine.getStart(), textLine.getEnd() - textLine.getStart());
    }

    public static String getTextOnLine(RTextArea sta) {
        int caretPos = sta.getCaretPosition();
        Document doc = sta.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(caretPos);
        Element line = map.getElement(lineNum);
        int start = line.getStartOffset();
        int end = line.getEndOffset();
        String txt = "";
        try {
            txt = doc.getText(start, end - start);
        }
        catch (BadLocationException e) {
            txt = "";
        }
        return txt;
    }

    public static TextLineStartEnd getStartEndNewline(RTextArea sta) throws BadLocationException {
        int caretPos = sta.getCaretPosition();
        Document doc = sta.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(caretPos);
        return TextPaneUtil.getStartEndLine(doc, lineNum);
    }

    public static TextLineStartEnd getStartEndNewline(Document doc, int pos) throws BadLocationException {
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(pos);
        return TextPaneUtil.getStartEndLine(doc, lineNum);
    }

    public static TextLineStartEnd getStartEndLine(Document doc, int lineNum) throws BadLocationException {
        Element map = doc.getDefaultRootElement();
        Element line = map.getElement(lineNum);
        int start = line.getStartOffset();
        int end = line.getEndOffset();
        int endBeforeNewLine = end - 1;
        String s = doc.getText(end - start > 1 ? end - 2 : end - 1, end - start > 1 ? 2 : 1);
        if (s.charAt(s.length() - 1) == '\n') {
            if (s.length() == 2 && s.charAt(s.length() - 2) == '\r') {
                --endBeforeNewLine;
            }
        } else if (s.charAt(s.length() - 1) == '\r') {
            --endBeforeNewLine;
        }
        return new TextLineStartEnd(start, endBeforeNewLine);
    }

    public static void replaceCurrentLine(RTextArea sta, String replaceValue) {
        try {
            TextLineStartEnd startEndNewline = TextPaneUtil.getStartEndNewline(sta);
            sta.replaceRange(replaceValue, startEndNewline.getStart(), startEndNewline.getEnd());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static Tuple<Integer, Integer> dotMark(RTextArea textArea) {
        Caret caret = textArea.getCaret();
        int p0 = Math.min(caret.getDot(), caret.getMark());
        int p1 = Math.max(caret.getDot(), caret.getMark());
        return new Tuple((Object)p0, (Object)p1);
    }

    public static String getNewLineFromCurrentPosition(RTextArea sta) {
        int caretPos = sta.getCaretPosition();
        Document doc = sta.getDocument();
        Element map = doc.getDefaultRootElement();
        int lineNum = map.getElementIndex(caretPos);
        Element line = map.getElement(lineNum);
        int start = line.getStartOffset();
        int end = line.getEndOffset();
        String txt = "";
        try {
            txt = doc.getText(start, end - start);
        }
        catch (BadLocationException e) {
            txt = "";
        }
        return TextPaneUtil.getNewLineToUse(doc, txt, lineNum);
    }

    public static String getNewLineToUse(Document doc, String currentLine, int line) {
        String newLine = null;
        Element map = doc.getDefaultRootElement();
        if (line != map.getElementCount() - 1 && (newLine = TextPaneUtil.getNewLineFromString(currentLine)) != null) {
            return newLine;
        }
        if (line > 0) {
            Element linez = map.getElement(line - 1);
            int start = linez.getStartOffset();
            int end = linez.getEndOffset();
            try {
                String prev = doc.getText(start, end - start);
                newLine = TextPaneUtil.getNewLineFromString(prev);
                if (newLine != null) {
                    return newLine;
                }
            }
            catch (BadLocationException e) {
                LOGGER.error("Error while getting newline text", (Throwable)e);
            }
        }
        if ((newLine = (String)doc.getProperty("__EndOfLine__")) == null || newLine.length() == 0) {
            return System.lineSeparator();
        }
        return newLine;
    }

    public static String getNewLineFromString(String currentLine) {
        if (currentLine.length() > 0) {
            String last = currentLine.substring(currentLine.length() - 1);
            if (!last.matches("(?s)\r|\n")) {
                return null;
            }
            if (currentLine.length() > 1) {
                String nextToLast = currentLine.substring(currentLine.length() - 2, currentLine.length() - 2 + 1);
                if (nextToLast.matches("(?s)\r|\n")) {
                    return String.valueOf(nextToLast) + last;
                }
                return last;
            }
        }
        return null;
    }

    public static void replaceColumnSelection(RSQLSyntaxTextArea textArea, String replace) {
        TextPaneUtil.replaceColumnSelection(textArea, (String r) -> replace, null);
    }

    public static void replaceColumnSelection(RSQLSyntaxTextArea textArea, String replace, Boolean deleteForward) {
        TextPaneUtil.replaceColumnSelection(textArea, (String r) -> replace, deleteForward);
    }

    private static String getRange(Document doc, int start, int end) {
        try {
            return doc.getText(start, end - start);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void replaceColumnSelectionWithColumnSelection(RSQLSyntaxTextArea textArea, Function<String, String> replace) {
        TextPaneUtil.replaceColumnSelection(textArea, replace, (Boolean)true);
    }

    public static void replaceColumnSelection(RSQLSyntaxTextArea textArea, Function<String, String> replace, Boolean deleteForward) {
        Document doc = textArea.getDocument();
        Element defaultRootElement = doc.getDefaultRootElement();
        StringBuilder sb = new StringBuilder();
        Highlighter highlighter = textArea.getHighlighter();
        Highlighter.Highlight[] lights = highlighter.getHighlights();
        ArrayList<Tuple> offsets = new ArrayList<Tuple>();
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        int[] ax = new int[lights.length];
        Element l1 = null;
        Element l2 = null;
        int caretLine = -1;
        int cnter = -1;
        if (lights.length == 0) {
            try {
                highlighter.addHighlight(textArea.getCaretPosition(), textArea.getCaretPosition(), null);
                lights = highlighter.getHighlights();
            }
            catch (Exception ex) {
                return;
            }
        }
        if (lights.length == 1) {
            String t = TextPaneUtil.getRange(doc, lights[0].getStartOffset(), lights[0].getEndOffset());
            textArea.replaceRange(replace.apply(t), lights[0].getStartOffset(), lights[0].getEndOffset());
            textArea.getHighlighter().removeAllHighlights();
            return;
        }
        try {
            Highlighter.Highlight[] highlightArray = lights;
            int n = lights.length;
            int n2 = 0;
            while (n2 < n) {
                Highlighter.Highlight hl = highlightArray[n2];
                ++cnter;
                offsets.add(Tuple.of((Object)hl.getStartOffset(), (Object)hl.getEndOffset()));
                if (caretLine == -1 && textArea.getCaretPosition() >= hl.getStartOffset() && textArea.getCaretPosition() <= hl.getEndOffset() + 1) {
                    caretLine = cnter;
                }
                Element rowElement = defaultRootElement.getElement(defaultRootElement.getElementIndex(hl.getStartOffset()));
                if (l2 != null && rowElement.getStartOffset() != l2.getEndOffset()) {
                    try {
                        sb.append(doc.getText(l2.getEndOffset(), rowElement.getStartOffset() - l2.getEndOffset()));
                    }
                    catch (Exception ex) {
                        LOGGER.error("Append failed: line content: \"{}\", count: {} l2: {} - {}, rowElement: {} - {}", new Object[]{doc.getText(rowElement.getStartOffset(), rowElement.getEndOffset() - rowElement.getStartOffset()), lights.length, l2.getStartOffset(), l2.getEndOffset(), rowElement.getStartOffset(), rowElement.getEndOffset()});
                        throw ex;
                    }
                }
                l2 = rowElement;
                if (l1 == null) {
                    l1 = rowElement;
                }
                String selection = doc.getText(rowElement.getStartOffset(), (rowElement.getEndOffset() >= doc.getLength() ? -1 : 0) + rowElement.getEndOffset() - rowElement.getStartOffset());
                String apply = TextPaneUtil.getRange(doc, hl.getStartOffset(), (hl.getEndOffset() >= doc.getLength() ? -1 : 0) + hl.getEndOffset());
                String x = replace.apply(apply);
                lengths.add(x.length());
                if ("\t".equals(x)) {
                    String tab = TextPaneUtil.insertTab(sb, selection, hl.getStartOffset() - rowElement.getStartOffset(), hl.getEndOffset() - rowElement.getStartOffset(), textArea.getTabSize());
                    ax[cnter] = -1 + tab.length() - (selection.length() - (hl.getEndOffset() - hl.getStartOffset()));
                } else {
                    TextPaneUtil.replaceStringWith(sb, selection, x, hl.getStartOffset() - rowElement.getStartOffset(), hl.getEndOffset() - rowElement.getStartOffset(), deleteForward);
                }
                ++n2;
            }
            if (doc instanceof AbstractDocument) {
                textArea.beginAtomicEdit();
                ((AbstractDocument)doc).replace(l1.getStartOffset(), (l2.getEndOffset() >= doc.getLength() ? -1 : 0) + l2.getEndOffset() - l1.getStartOffset(), sb.toString(), null);
                textArea.endAtomicEdit();
            } else {
                textArea.beginAtomicEdit();
                doc.remove(l1.getStartOffset(), (l2.getEndOffset() >= doc.getLength() ? -1 : 0) + l2.getEndOffset() - l1.getStartOffset());
                doc.insertString(l1.getStartOffset(), sb.toString(), null);
                textArea.endAtomicEdit();
            }
            highlighter.removeAllHighlights();
            int j = 0;
            while (j <= 1) {
                int compound = 0;
                if (Boolean.FALSE.equals(deleteForward)) {
                    compound = -1;
                }
                int aggOffset = 0;
                int q = 0;
                while (q < offsets.size()) {
                    Tuple offset = (Tuple)offsets.get(q);
                    int length = (Integer)lengths.get(q);
                    int position = (Integer)offset.first() + length + compound + (aggOffset += ax[q]);
                    if (position >= textArea.getDocument().getLength()) {
                        position = textArea.getDocument().getLength() - 1;
                    }
                    if (j == 0 && caretLine == q) {
                        textArea.setCaretPosition(position);
                    } else if (j == 1) {
                        highlighter.addHighlight(position, position, new RSQLSyntaxTextArea.ZeroWidthPainter(null));
                    }
                    compound = deleteForward == null ? (compound += length - ((Integer)offset.second() - (Integer)offset.first())) : (compound += (Integer)offset.second() - (Integer)offset.first() == 0 ? -1 : -((Integer)offset.second() - (Integer)offset.first()));
                    ++q;
                }
                ++j;
            }
            textArea.repaint();
        }
        catch (BadLocationException e) {
            LOGGER.error("Error replacing", (Throwable)e);
        }
    }

    static String insertTab(StringBuilder sbResult, String lineText, int posFrom, int posTo, int tabSize) {
        StringBuilder sbTemp;
        block14: {
            sbTemp = new StringBuilder();
            int cursor = 0;
            int pos = 0;
            int lineLength = lineText.length();
            int buffer = 0;
            int codePoint = 0;
            String s = "";
            StringBuilder sbBuffer = new StringBuilder();
            int state = 0;
            while (true) {
                if (cursor == lineLength) {
                    state = 666;
                }
                if (state == 0 && pos == posFrom) {
                    sbTemp.append(StringUtils.repeat("\t", (int)Math.ceil((double)buffer / (1.0 * (double)tabSize))));
                    if (buffer % tabSize == 0) {
                        sbTemp.append("\t");
                    }
                    state = 700;
                    continue;
                }
                if (state == 0) {
                    codePoint = Character.codePointAt(lineText, cursor);
                    s = new String(Character.toChars(codePoint));
                    state = 1;
                }
                if (state == 1) {
                    if ("\t".equals(s)) {
                        buffer = buffer - buffer % tabSize + tabSize;
                        sbBuffer.append(s);
                        ++pos;
                    } else if (" ".equals(s)) {
                        ++buffer;
                        sbBuffer.append(s);
                        ++pos;
                    } else {
                        ++buffer;
                        buffer %= tabSize;
                        sbTemp.append((CharSequence)sbBuffer);
                        sbBuffer.setLength(0);
                        sbTemp.append(s);
                        pos += TextPaneUtil.charCount(codePoint);
                    }
                    cursor += Character.charCount(codePoint);
                    state = 0;
                    continue;
                }
                if (state == 666) {
                    sbTemp.append((CharSequence)sbBuffer);
                    if (pos <= posTo) {
                        sbTemp.append("\t");
                    }
                    break block14;
                }
                if (state == 700) {
                    if (pos == posTo) {
                        state = 750;
                        continue;
                    }
                    codePoint = Character.codePointAt(lineText, cursor);
                    s = new String(Character.toChars(codePoint));
                    cursor += Character.charCount(codePoint);
                    pos += TextPaneUtil.charCount(codePoint);
                    continue;
                }
                if (state == 750) break;
            }
            sbTemp.append(lineText.substring(cursor));
        }
        sbResult.append((CharSequence)sbTemp);
        return sbTemp.toString();
    }

    static int charCount(int codepoint) {
        if (codepoint <= 256) {
            return 1;
        }
        return 1;
    }

    public static void replaceStringWith(StringBuilder sb, String replace, String replaceWith, int posFrom, int posTo, Boolean deleteForward) {
        int z = 0;
        if (deleteForward != null) {
            replaceWith = "";
        }
        if (posTo == 0 && deleteForward != null && !deleteForward.booleanValue()) {
            sb.append(replace);
            return;
        }
        char[] array = replace.toCharArray();
        if (Boolean.TRUE.equals(deleteForward) && posFrom == posTo) {
            ++posTo;
        }
        if (Boolean.FALSE.equals(deleteForward) && posFrom == posTo) {
            --posFrom;
        }
        boolean newLines = false;
        while (z < array.length) {
            int codePoint = Character.codePointAt(array, z);
            char[] c = Character.toChars(codePoint);
            if (c[0] == '\n' || c[0] == '\r') {
                if (!newLines && z < posFrom) {
                    if (deleteForward == null) {
                        sb.append(replaceWith);
                    }
                    newLines = true;
                }
                sb.append(c);
                z += Character.charCount(codePoint);
                continue;
            }
            if (z < posFrom) {
                sb.append(c);
            }
            if (z == posFrom) {
                sb.append(replaceWith);
            }
            if (z >= posTo) {
                sb.append(c);
            }
            z += Character.charCount(codePoint);
        }
    }

    public static class AlwaysSelectedCaret
    extends DefaultCaret {
        private boolean isFocused;
        Point lastPoint = new Point(0, 0);
        boolean altDown = false;
        boolean moving = false;

        @Override
        public void setSelectionVisible(boolean hasFocus) {
            if (hasFocus != this.isFocused) {
                this.isFocused = hasFocus;
                super.setSelectionVisible(false);
                super.setSelectionVisible(true);
            }
        }
    }

    public static class TextLineStartEnd {
        private final int start;
        private final int end;

        public TextLineStartEnd(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public String toString() {
            return "[" + this.start + "," + this.end + "]";
        }
    }
}

