/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.ITokenState;
import com.sigge.parsql.sql.transform.TSQLLexer;
import com.sigge.parsql.sql.transform.TokenResult;
import com.sigge.parsql.sql.transform.TokenType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class TSQLTokenMaker
extends AbstractTokenMaker {
    private static final int MULTILINE_TOKEN_TYPE = -100000;
    private static final int SPANNED_TOKEN_TYPE = -200000;
    private static final String[] LINE_COMMENTS;
    private final Map<Integer, Integer> unfinishedState = new HashMap<Integer, Integer>();

    static {
        String[] stringArray = new String[2];
        stringArray[0] = "--";
        LINE_COMMENTS = stringArray;
    }

    public boolean isIdentifierChar(int languageIndex, char ch) {
        return super.isIdentifierChar(languageIndex, ch) || ch == '@' || ch == '#';
    }

    public String[] getLineCommentStartAndEnd(int languageIndex) {
        return LINE_COMMENTS;
    }

    public Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        this.resetTokenList();
        char[] array = text.array;
        int offset = text.offset;
        int count = text.count;
        int end = offset + count;
        int newStartOffset = startOffset - offset;
        int nestedCommentLevel = 0;
        ParseTokenState ts = new ParseTokenState(0, offset, 0);
        TokenType ttx = null;
        if (initialTokenType != 0) {
            if (initialTokenType <= -200000) {
                ttx = TokenType.getFromTypeOrdinal((int)(-200000 - initialTokenType));
                initialTokenType = TSQLTokenMaker.mapTSQLTokenToTokenMakerToken(ttx);
            } else if (initialTokenType < -100000 && initialTokenType > -200000) {
                nestedCommentLevel = -100000 - initialTokenType;
                initialTokenType = 2;
            }
            ts = new ParseTokenState(this.internalTokenStateFromTokenMakerTokenType(initialTokenType), offset, nestedCommentLevel, ttx);
        }
        TokenResult result = TSQLLexer.parse((char[])array, (int)offset, (int)end, (ITokenState)ts);
        List l = result.getTokens();
        int i = 0;
        while (i < l.size()) {
            ISQLToken t = (ISQLToken)l.get(i);
            this.addToken(text, t.getStart(), t.getEnd(), TSQLTokenMaker.mapTSQLTokenToTokenMakerToken(t.getTokenType()), t.getStart() + newStartOffset);
            ++i;
        }
        if (result.getState().getState() > 0) {
            int last = offset;
            if (result.getTokens().size() > 0) {
                last = ((ISQLToken)l.get(result.getTokens().size() - 1)).getEnd() + 1;
            }
            Integer tt = this.unfinishedState.computeIfAbsent(result.getState().getState(), r -> TSQLTokenMaker.mapTSQLTokenToTokenMakerToken((TokenType)result.getState().getUnfinishedToken().get()));
            this.addToken(text, last, end - 1, tt, last + newStartOffset);
            if (result.getState().getNestedCommentLevel() > 0) {
                tt = -100000 - result.getState().getNestedCommentLevel();
                this.addToken(text, end, end, tt, last + newStartOffset);
            } else if (result.getState().getUnfinishedToken().isPresent()) {
                TokenType tx = (TokenType)result.getState().getUnfinishedToken().get();
                tt = -200000 - tx.ordinal();
                this.addToken(text, end, end, tt, last + newStartOffset);
            }
        } else {
            this.addNullToken();
        }
        return this.firstToken;
    }

    private int internalTokenStateFromTokenMakerTokenType(int tokenType) {
        for (Integer keys : this.unfinishedState.keySet()) {
            if (tokenType != this.unfinishedState.get(keys)) continue;
            return keys;
        }
        return tokenType;
    }

    public int getClosestStandardTokenTypeForInternalType(int type) {
        if (type <= -200000) {
            return 14;
        }
        if (type <= -100000) {
            return 2;
        }
        return type;
    }

    public boolean getCurlyBracesDenoteCodeBlocks(int languageIndex) {
        return true;
    }

    public static int mapTSQLTokenToTokenMakerToken(TokenType t) {
        switch (t) {
            case IDENTIFIER: {
                return 20;
            }
            case KEYWORD: {
                return 6;
            }
            case STRING: {
                return 14;
            }
            case MULTILINE_STRING: {
                return -200000;
            }
            case TAB: {
                return 21;
            }
            case WHITESPACE: {
                return 21;
            }
            case VARIABLE: {
                return 17;
            }
            case MULTICOMMENT: {
                return 2;
            }
            case NESTED_MULTICOMMENT: {
                return -100000;
            }
            case NEWLINE: {
                return 38;
            }
            case NUMBER: {
                return 10;
            }
            case OPERATOR: {
                return 23;
            }
            case BRACES_IDENTIFIER: {
                return 20;
            }
            case DOUBLE_QUOTE_IDENTIFIER: {
                return 20;
            }
            case START_BRACKET: {
                return 22;
            }
            case END_BRACKET: {
                return 22;
            }
            case COMMA: {
                return 22;
            }
            case COMMENT: {
                return 1;
            }
            case CURRENCY_NUMBER: {
                return 10;
            }
            case HEX_NUMBER: {
                return 12;
            }
            case ILLEGAL_IDENTIFIER: {
                return 35;
            }
            case ILLEGAL_OPERATOR: {
                return 23;
            }
            case SCOPE_OR_SYSFUNCTION_OPERATOR: {
                return 23;
            }
            case STATEMENT_SPLITTER: {
                return 22;
            }
        }
        return 35;
    }

    public static TokenType mapTokenToToken(int t) {
        switch (t) {
            case 20: {
                return TokenType.IDENTIFIER;
            }
            case 6: {
                return TokenType.KEYWORD;
            }
            case 14: {
                return TokenType.STRING;
            }
            case 21: {
                return TokenType.WHITESPACE;
            }
            case 17: {
                return TokenType.VARIABLE;
            }
            case 2: {
                return TokenType.MULTICOMMENT;
            }
            case 38: {
                return TokenType.ILLEGAL_IDENTIFIER;
            }
            case 10: {
                return TokenType.NUMBER;
            }
            case 23: {
                return TokenType.OPERATOR;
            }
            case 22: {
                return TokenType.GENERIC_SEPARATOR;
            }
            case 1: {
                return TokenType.COMMENT;
            }
            case 12: {
                return TokenType.HEX_NUMBER;
            }
            case 35: {
                return TokenType.ILLEGAL_IDENTIFIER;
            }
        }
        return TokenType.ERROR;
    }

    public TokenMap getWordsToHighlight() {
        TokenMap t = new TokenMap(true);
        TSQLLexer.KEYWORDS.forEach(kw -> t.put(kw, 6));
        TSQLLexer.BUILD_INS.forEach(kw -> t.put(kw, 6));
        return t;
    }

    private final class ParseTokenState
    implements ITokenState {
        private final int state;
        private final int tokenStart;
        private final int nestedCommentLevel;
        private final Optional<TokenType> unfinishedToken;

        public ParseTokenState(int state, int tokenStart, int nestedCommentLevel) {
            this(state, tokenStart, nestedCommentLevel, null);
        }

        public ParseTokenState(int state, int tokenStart, int nestedCommentLevel, TokenType unfinishedToken) {
            this.state = state;
            this.tokenStart = tokenStart;
            this.nestedCommentLevel = nestedCommentLevel;
            this.unfinishedToken = Optional.ofNullable(unfinishedToken);
        }

        public Optional<TokenType> getUnfinishedToken() {
            return this.unfinishedToken;
        }

        public int tokenStart() {
            return this.tokenStart;
        }

        public int getState() {
            return this.state;
        }

        public int getNestedCommentLevel() {
            return this.nestedCommentLevel;
        }

        public String toString() {
            return "State=" + this.state + ", tokenStart =" + this.tokenStart + ", nestedLevel=" + this.nestedCommentLevel;
        }
    }
}

