/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

public class SelectWordActionWithNewLines
extends RSyntaxTextAreaEditorKit.SelectWordAction {
    protected void createActions() {
        this.start = new BeginWordAction("pigdog", false);
        this.end = new EndWordAction("pigdog", true);
    }

    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        TextPaneUtil.fixDotAndMarks(textArea);
        super.actionPerformedImpl(e, textArea);
    }

    protected static class BeginWordAction
    extends RecordableTextAction {
        private final Segment seg;
        private final boolean select;

        protected BeginWordAction(String name, boolean select) {
            super(name);
            this.select = select;
            this.seg = new Segment();
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            try {
                int offs = textArea.getCaretPosition();
                int begOffs = this.getWordStart(textArea, offs);
                if (this.select) {
                    textArea.moveCaretPosition(begOffs);
                } else {
                    textArea.setCaretPosition(begOffs);
                }
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            }
        }

        protected int getWordStart(RTextArea textArea, int offs) throws BadLocationException {
            if (offs == 0) {
                return offs;
            }
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            int line = textArea.getLineOfOffset(offs);
            int start = textArea.getLineStartOffset(line);
            if (offs == start) {
                return start;
            }
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            if (TextPaneUtil.isDotOnR(end - 1, (Document)doc)) {
                --end;
            }
            doc.getText(start, end - start, this.seg);
            int firstIndex = this.seg.getBeginIndex() + (offs - start) - 1;
            this.seg.setIndex(firstIndex);
            char ch = this.seg.current();
            char nextCh = offs == end ? (char)'\u0000' : this.seg.array[this.seg.getIndex() + 1];
            int languageIndex = 0;
            if (doc.isIdentifierChar(languageIndex, ch)) {
                if (offs != end && !doc.isIdentifierChar(languageIndex, nextCh)) {
                    return offs;
                }
                while (doc.isIdentifierChar(languageIndex, ch = this.seg.previous()) && ch != '\uffff') {
                }
            } else if (Character.isWhitespace(ch)) {
                if (offs != end && !Character.isWhitespace(nextCh)) {
                    return offs;
                }
                while (Character.isWhitespace(ch = this.seg.previous())) {
                }
            }
            offs -= firstIndex - this.seg.getIndex() + 1;
            if (ch != '\uffff' && nextCh != '\n') {
                ++offs;
            }
            return offs;
        }

        public String getMacroID() {
            return this.getName();
        }
    }

    protected static class EndWordAction
    extends RecordableTextAction {
        private final Segment seg;
        private final boolean select;

        protected EndWordAction(String name, boolean select) {
            super(name);
            this.select = select;
            this.seg = new Segment();
        }

        protected int getWordEnd(RTextArea textArea, int offs) throws BadLocationException {
            RSyntaxDocument doc = (RSyntaxDocument)textArea.getDocument();
            if (offs == doc.getLength()) {
                return offs;
            }
            int line = textArea.getLineOfOffset(offs);
            int end = textArea.getLineEndOffset(line);
            if (line != textArea.getLineCount() - 1) {
                --end;
            }
            if (offs == end) {
                return end;
            }
            doc.getText(offs, end - offs, this.seg);
            char ch = this.seg.first();
            int languageIndex = 0;
            if (doc.isIdentifierChar(languageIndex, ch)) {
                while (doc.isIdentifierChar(languageIndex, ch = this.seg.next()) && ch != '\uffff') {
                }
            } else if (Character.isWhitespace(ch)) {
                while (Character.isWhitespace(ch = this.seg.next())) {
                }
            }
            return offs += this.seg.getIndex() - this.seg.getBeginIndex();
        }

        public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
            try {
                int offs = textArea.getCaretPosition();
                int endOffs = this.getWordEnd(textArea, offs);
                if (this.select) {
                    textArea.moveCaretPosition(endOffs);
                } else {
                    textArea.setCaretPosition(endOffs);
                }
            }
            catch (BadLocationException ble) {
                UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            }
        }

        public String getMacroID() {
            return this.getName();
        }
    }
}

