/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.ColumnSelectedText;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TextTransformer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import net.sourceforge.tess4j.Tesseract;
import net.sourceforge.tess4j.TesseractException;
import net.sourceforge.tess4j.util.LoadLibs;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.RTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RTATextTransferHandlerWithNewLines
extends TransferHandler {
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private int p0;
    private int p1;
    private boolean withinSameComponent;
    private TextTransformer transformer;
    private static final Logger LOGGER = LoggerFactory.getLogger(RTATextTransferHandlerWithNewLines.class);
    private Consumer<List<File>> fileConsumer;

    public RTATextTransferHandlerWithNewLines() {
    }

    public RTATextTransferHandlerWithNewLines(TextTransformer transformer, Consumer<List<File>> fileConsumer) {
        this.transformer = transformer;
        this.fileConsumer = fileConsumer;
    }

    protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
        DataFlavor refFlavor = null;
        DataFlavor stringFlavor = null;
        int i = 0;
        while (i < flavors.length) {
            String mime = flavors[i].getMimeType();
            if (mime.startsWith("text/plain")) {
                return flavors[i];
            }
            if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                refFlavor = flavors[i];
            } else if (stringFlavor == null && flavors[i].equals(DataFlavor.stringFlavor)) {
                stringFlavor = flavors[i];
            } else {
                if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                    return flavors[i];
                }
                if (flavors[i].equals(DataFlavor.imageFlavor)) {
                    return flavors[i];
                }
            }
            ++i;
        }
        if (refFlavor != null) {
            return refFlavor;
        }
        if (stringFlavor != null) {
            return stringFlavor;
        }
        return null;
    }

    public boolean transferrableWithinApplication(Transferable t) {
        return t instanceof TextTransferable;
    }

    private void handleReaderImport(StringBuilder sbuff, JTextComponent c, IResultSetTable rb, boolean columnSelected, boolean IsImage) {
        RTextArea ra = (RTextArea)c;
        String newLine = TextPaneUtil.getNewLineFromCurrentPosition(ra);
        if (!newLine.equals("\r\n")) {
            System.err.println("Bad newline detected: " + newLine.replace("\r", "\\r").replace("\n", "\\n"));
        }
        if (this.withinSameComponent) {
            ra.beginAtomicEdit();
        }
        String edit = StringUtils.normalizeNewLines(sbuff, newLine);
        if (!this.withinSameComponent && this.transformer != null) {
            String transform = this.transformer.transform(edit, rb);
            if (transform == null) {
                return;
            }
            if (transform != edit) {
                edit = StringUtils.normalizeNewLines(transform, newLine);
            }
        }
        TextPaneUtil.fixDotAndMarks(ra);
        if (!columnSelected) {
            ra.replaceSelection(edit);
        } else {
            ((RSQLSyntaxTextArea)ra).replaceSelectionWithColumnSelection(edit);
        }
    }

    private StringBuilder getStringFromReader(Reader in) throws IOException {
        int nch;
        char[] buff = new char[1024];
        StringBuilder sbuff = new StringBuilder(1024);
        while ((nch = in.read(buff, 0, buff.length)) != -1) {
            sbuff.append(buff, 0, nch);
        }
        return sbuff;
    }

    @Override
    public int getSourceActions(JComponent c) {
        if (((JTextComponent)c).isEditable()) {
            return 3;
        }
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        this.exportComp = (JTextComponent)comp;
        this.shouldRemove = true;
        if (comp instanceof RTextArea) {
            TextPaneUtil.fixDotAndMarks((RTextArea)comp);
        }
        this.p0 = this.exportComp.getSelectionStart();
        this.p1 = this.exportComp.getSelectionEnd();
        TextTransferable tt = null;
        if (this.p0 != this.p1) {
            tt = new TextTransferable(this.exportComp, this.p0, this.p1);
        } else if (ConfigHandler.getConfig().getBooleanConfigValue("editing.copy_paste_work_on_whole_line_if_empty", false).booleanValue()) {
            try {
                TextPaneUtil.TextLineStartEnd ts = TextPaneUtil.getStartEndNewline(this.exportComp.getDocument(), this.p0);
                this.p0 = ts.getStart();
                this.p1 = ts.getEnd();
                tt = new TextTransferable(this.exportComp, this.p0, this.p1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return tt;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (this.shouldRemove && action == 2) {
            TextTransferable t = (TextTransferable)data;
            t.removeText();
        }
        if (this.withinSameComponent) {
            ((RTextArea)source).endAtomicEdit();
            this.withinSameComponent = false;
        }
        this.exportComp = null;
        if (data instanceof TextTransferable) {
            ClipboardHistory.get().add(((TextTransferable)data).getPlainData());
        }
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        JTextComponent c = (JTextComponent)comp;
        boolean bl = this.withinSameComponent = c == this.exportComp;
        if (this.withinSameComponent && c.getCaretPosition() >= this.p0 && c.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean imported = false;
        DataFlavor importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c);
        if (importFlavor != null) {
            StringBuilder stringFromTransferable;
            block22: {
                if (importFlavor.equals(DataFlavor.javaFileListFlavor)) {
                    try {
                        List droppedFiles = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                        this.fileConsumer.accept(droppedFiles);
                        return imported;
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while getting transferable", (Throwable)e);
                        return false;
                    }
                }
                InputContext ic = c.getInputContext();
                if (ic != null) {
                    ic.endComposition();
                }
                stringFromTransferable = null;
                if (importFlavor.equals(DataFlavor.imageFlavor)) {
                    File ff = null;
                    try {
                        try {
                            Image img = (Image)t.getTransferData(importFlavor);
                            Tesseract instance = new Tesseract();
                            ff = LoadLibs.extractTessResources((String)"tessdata");
                            instance.setDatapath(ff.getAbsolutePath());
                            try {
                                String result = instance.doOCR(RTATextTransferHandlerWithNewLines.toBufferedImage(img));
                                stringFromTransferable = new StringBuilder(result);
                            }
                            catch (TesseractException e) {
                                System.err.println(e.getMessage());
                            }
                            break block22;
                        }
                        catch (Exception e) {
                            if (ff != null) {
                                ff.deleteOnExit();
                            }
                            return false;
                        }
                    }
                    finally {
                        if (ff != null) {
                            ff.deleteOnExit();
                        }
                    }
                }
                try {
                    Reader r = importFlavor.getReaderForText(t);
                    stringFromTransferable = this.getStringFromReader(r);
                }
                catch (UnsupportedFlavorException ufe) {
                    LOGGER.error("Couldn't get import flavor", (Throwable)ufe);
                }
                catch (IOException ioe) {
                    LOGGER.error("Couldn't read clipboard data", (Throwable)ioe);
                }
            }
            DataFlavor flavor = new DataFlavor(IResultSetTable.class, "ResultSetTableModel");
            DataFlavor cpFlavor = new DataFlavor(ColumnSelectedText.class, "ColumnSelectedText");
            IResultSetTable rb = null;
            try {
                if (t.isDataFlavorSupported(flavor)) {
                    rb = (IResultSetTable)t.getTransferData(flavor);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while unveiling the clipboard data", (Throwable)ex);
            }
            this.handleReaderImport(stringFromTransferable, c, rb, t.isDataFlavorSupported(cpFlavor), t.isDataFlavorSupported(DataFlavor.imageFlavor));
            imported = true;
        }
        return imported;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        JTextComponent c = (JTextComponent)comp;
        if (!c.isEditable() || !c.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(flavors, c) != null;
    }

    static class TextTransferable
    implements Transferable {
        private Position p0;
        private Position p1;
        private final JTextComponent c;
        protected String plainData;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        static {
            try {
                plainFlavors = new DataFlavor[3];
                TextTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                TextTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                TextTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                TextTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                TextTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException cle) {
                System.err.println("Error initializing org.fife.ui.RTATextTransferHandler");
            }
        }

        TextTransferable(JTextComponent c, int start, int end) {
            this.c = c;
            int startReal = start;
            int endReal = end;
            Document doc = c.getDocument();
            try {
                this.p0 = doc.createPosition(startReal);
                this.p1 = doc.createPosition(endReal);
                this.plainData = c.getDocument().getText(startReal, endReal - startReal);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected String getPlainData() {
            return this.plainData;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(data);
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            int plainCount = this.isPlainSupported() ? plainFlavors.length : 0;
            int stringCount = this.isPlainSupported() ? stringFlavors.length : 0;
            int totalCount = plainCount + stringCount;
            DataFlavor[] flavors = new DataFlavor[totalCount];
            int pos = 0;
            if (plainCount > 0) {
                System.arraycopy(plainFlavors, 0, flavors, pos, plainCount);
                pos += plainCount;
            }
            if (stringCount > 0) {
                System.arraycopy(stringFlavors, 0, flavors, pos, stringCount);
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(flavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = plainFlavors;
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(flavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = stringFlavors;
            int i = 0;
            while (i < flavors.length) {
                if (flavors[i].equals(flavor)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        void removeText() {
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    Document doc = this.c.getDocument();
                    doc.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }
}

