/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;

public class InsertTabAction
extends RecordableTextAction {
    private static final long serialVersionUID = 1L;

    public InsertTabAction() {
        super("insert-tab");
    }

    public InsertTabAction(String name) {
        super(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        if (!textArea.isEditable() || !textArea.isEnabled()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            return;
        }
        Document document = textArea.getDocument();
        Element map = document.getDefaultRootElement();
        Caret c = textArea.getCaret();
        int dot = c.getDot();
        int mark = c.getMark();
        int dotLine = map.getElementIndex(dot);
        int markLine = map.getElementIndex(mark);
        if (this.isColumnSelection(textArea)) {
            TextPaneUtil.replaceColumnSelection((RSQLSyntaxTextArea)textArea, "\t");
            return;
        } else if (dotLine != markLine) {
            int first = Math.min(dotLine, markLine);
            int last = Math.max(dotLine, markLine);
            String replacement = "\t";
            if (textArea.getTabsEmulated()) {
                StringBuilder sb = new StringBuilder();
                int temp = textArea.getTabSize();
                int i = 0;
                while (i < temp) {
                    sb.append(' ');
                    ++i;
                }
                replacement = sb.toString();
            }
            textArea.beginAtomicEdit();
            try {
                try {
                    int start;
                    Element elem;
                    int i = first;
                    while (i < last) {
                        elem = map.getElement(i);
                        start = elem.getStartOffset();
                        document.insertString(start, replacement, null);
                        ++i;
                    }
                    elem = map.getElement(last);
                    start = elem.getStartOffset();
                    if (Math.max(c.getDot(), c.getMark()) == start) return;
                    document.insertString(start, replacement, null);
                    return;
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
                    textArea.endAtomicEdit();
                }
                return;
            }
            finally {
                textArea.endAtomicEdit();
            }
        } else {
            int cursor = Math.min(dot, mark);
            Element elem = map.getElement(dotLine);
            String lineText = TextPaneUtil.getTextOnLine(textArea);
            int charCount = 0;
            int tabsToAdd = 1;
            int lastNonSpace = -1;
            int z = 0;
            int startOffset = elem.getStartOffset();
            while (z < cursor - startOffset) {
                int codePoint = Character.codePointAt(lineText, z);
                String s = new String(Character.toChars(codePoint));
                if ("\t".equals(s)) {
                    ++tabsToAdd;
                    charCount = 0;
                } else if (" ".equals(s)) {
                    if (++charCount == textArea.getTabSize() || charCount % textArea.getTabSize() == 0) {
                        charCount = 0;
                        tabsToAdd = lastNonSpace + textArea.getTabSize() <= z ? ++tabsToAdd : ++tabsToAdd;
                    }
                } else {
                    lastNonSpace = z + s.length() - 1;
                    tabsToAdd = (charCount += s.length()) == textArea.getTabSize() ? 1 : (charCount > textArea.getTabSize() || charCount == 1 ? 1 : 1);
                }
                z += Character.charCount(codePoint);
            }
            String toInsert = StringUtils.repeat("\t", Math.max(tabsToAdd, 1));
            textArea.replaceRange(toInsert, lastNonSpace + 1 + startOffset, Math.max(dot, mark));
        }
    }

    private boolean isColumnSelection(RTextArea area) {
        return area instanceof RSQLSyntaxTextArea && ((RSQLSyntaxTextArea)area).isColumnSelection();
    }

    public final String getMacroID() {
        return "insert-tab";
    }
}

