/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class EndLineAction
extends RTextAreaEditorKit.EndLineAction {
    private final boolean select;

    public EndLineAction(boolean select) {
        super(select ? "selection-end-line" : "caret-end-line", select);
        this.select = select;
    }

    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        int offs = textArea.getCaretPosition();
        int endOffs = 0;
        try {
            if (textArea.getLineWrap()) {
                endOffs = Utilities.getRowEnd((JTextComponent)textArea, offs);
            } else {
                Element root = textArea.getDocument().getDefaultRootElement();
                int line = root.getElementIndex(offs);
                endOffs = root.getElement(line).getEndOffset() - 1;
            }
            if (TextPaneUtil.isDotOnR(endOffs - 1, textArea.getDocument())) {
                --endOffs;
            }
            if (this.select) {
                textArea.moveCaretPosition(endOffs);
            } else {
                textArea.setCaretPosition(endOffs);
            }
        }
        catch (Exception ex) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
        }
    }
}

