/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.simple;

import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.graph.GraphHandler;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.GraphType;
import com.sigge.filerunner.view.results.graph.ResultColumnMapper;
import com.sigge.filerunner.view.results.graph.simple.ISimpleGraphSetting;
import com.siggemannen.core.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class SimpleGraphSetting
implements ISimpleGraphSetting<SimpleGraphSetting> {
    private List<String> columns = new ArrayList<String>();
    private GraphType graphType;
    private TextListItem<Integer> x;
    private TextListItem<Integer> y;
    private TextListItem<Integer> identifier;
    private transient GraphResult resultSet;

    public SimpleGraphSetting() {
    }

    public SimpleGraphSetting(SimpleGraphSetting copy) {
        this.columns = new ArrayList<String>(copy.columns);
        this.graphType = copy.graphType;
        this.x = copy.x;
        this.y = copy.y;
        this.identifier = copy.identifier;
        this.resultSet = copy.resultSet;
    }

    @Override
    public boolean isValid() {
        if (this.y.getValue() == -1 || !this.isNumber(this.y) && !this.isDate(this.y)) {
            return false;
        }
        return this.x.getValue() <= -1 || this.isNumber(this.x) || this.isDate(this.x);
    }

    @Override
    public GraphType getType() {
        return this.graphType;
    }

    @Override
    public Optional<SimpleGraphSetting> resolveFromStorage(ResultColumnMapper columnMapper) {
        Optional<SimpleGraphSetting> emp = Optional.empty();
        try {
            Optional<Tuple<Integer, String>> x = this.resolve(columnMapper, this.x, this.columns, false, GraphHandler.VALUE_TYPE.NUMBER, GraphHandler.VALUE_TYPE.DATE);
            Optional<Tuple<Integer, String>> y = this.resolve(columnMapper, this.y, this.columns, true, GraphHandler.VALUE_TYPE.NUMBER, GraphHandler.VALUE_TYPE.DATE);
            Optional<Tuple<Integer, String>> id = this.resolve(columnMapper, this.identifier, this.columns, new GraphHandler.VALUE_TYPE[0]);
            SimpleGraphSetting sg = new SimpleGraphSetting(this);
            sg.columns = new ArrayList<String>();
            sg.x = x.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.y = y.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.identifier = id.map(TextListItem::new).orElse(EMPTY_VALUE);
            sg.resultSet = columnMapper.getResult();
            return Optional.of(sg);
        }
        catch (Exception ex) {
            return emp;
        }
    }

    @Override
    public SimpleGraphSetting toStorage() {
        SimpleGraphSetting storage = new SimpleGraphSetting(this);
        int i = 0;
        while (i < this.resultSet.getResultSet().getColumnCount()) {
            storage.columns.add(this.resultSet.getResultSet().getColumnName(i));
            ++i;
        }
        storage.resultSet = null;
        return storage;
    }

    @Override
    public IResultSetTable getChosenResultSet() {
        return this.resultSet.getResultSet();
    }

    public TextListItem<Integer> getX() {
        return this.x;
    }

    public void setX(TextListItem<Integer> x) {
        this.x = x;
    }

    public TextListItem<Integer> getY() {
        return this.y;
    }

    public void setY(TextListItem<Integer> y) {
        this.y = y;
    }

    public TextListItem<Integer> getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(TextListItem<Integer> identifier) {
        this.identifier = identifier;
    }

    public GraphType getGraphType() {
        return this.graphType;
    }

    public void setGraphType(GraphType graphType) {
        this.graphType = graphType;
    }

    public GraphResult getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(GraphResult resultSet) {
        this.resultSet = resultSet;
    }
}

